/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class VariableUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean used;
    @NotNull
    private final PsiVariable variable;

    private VariableUsedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableUsedVisitor", "<init>"));
        }
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableUsedVisitor", "visitElement"));
        }
        if (this.used) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/VariableUsedVisitor", "visitReferenceExpression"));
        }
        if (this.used) {
            return;
        }
        super.visitReferenceExpression(referenceExpression);
        PsiElement target = referenceExpression.resolve();
        if (target == null) {
            return;
        }
        if (target.equals(this.variable)) {
            this.used = true;
        }
    }

    public boolean isUsed() {
        return this.used;
    }

    static boolean isVariableUsedIn(@NotNull PsiVariable variable, @NotNull PsiElement code) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableUsedVisitor", "isVariableUsedIn"));
        }
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/siyeh/ig/psiutils/VariableUsedVisitor", "isVariableUsedIn"));
        }
        VariableUsedVisitor visitor = new VariableUsedVisitor(variable);
        code.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }
}

