/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class CustomSecurityManagerInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("custom.security.manager.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/CustomSecurityManagerInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("custom.security.manager.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/CustomSecurityManagerInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CustomSecurityManagerVisitor();
    }

    private static class CustomSecurityManagerVisitor
    extends BaseInspectionVisitor {
        private CustomSecurityManagerVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/security/CustomSecurityManagerInspection$CustomSecurityManagerVisitor", "visitClass"));
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.SecurityManager")) {
                return;
            }
            if ("java.lang.SecurityManager".equals(aClass.getQualifiedName())) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

