/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.asserttoif;

import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.asserttoif.AssertStatementPredicate;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class AssertToIfIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AssertStatementPredicate assertStatementPredicate = new AssertStatementPredicate();
        if (assertStatementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/asserttoif/AssertToIfIntention", "getElementPredicate"));
        }
        return assertStatementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/asserttoif/AssertToIfIntention", "processIntention"));
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)element;
        StringBuilder newStatement = new StringBuilder();
        PsiExpression condition = assertStatement.getAssertCondition();
        newStatement.append("if(").append(BoolUtils.getNegatedExpressionText(condition)).append(") throw new java.lang.AssertionError(");
        PsiExpression description = assertStatement.getAssertDescription();
        if (description != null) {
            newStatement.append(description.getText());
        }
        newStatement.append(");");
        PsiReplacementUtil.replaceStatement((PsiStatement)assertStatement, newStatement.toString());
    }
}

