/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.siyeh.ig.controlflow.TrivialIfInspection;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class SimplifyIfElseIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiJavaToken)) {
                    return false;
                }
                PsiJavaToken token = (PsiJavaToken)element;
                PsiElement parent = token.getParent();
                if (!(parent instanceof PsiIfStatement)) {
                    return false;
                }
                return TrivialIfInspection.isTrivial((PsiIfStatement)parent);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/SimplifyIfElseIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/SimplifyIfElseIntention", "processIntention"));
        }
        TrivialIfInspection.simplify((PsiIfStatement)element.getParent());
    }
}

