/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.intellij.plugins.relaxNG.convert.AdvancedOptions;
import org.jetbrains.annotations.NonNls;

public class AdvancedDtdOptions
implements AdvancedOptions {
    @NonNls
    private static final String COLON_REPLACEMENT = "colon-replacement";
    @NonNls
    private static final String ELEMENT_DEFINE = "element-define";
    @NonNls
    private static final String ATTLIST_DEFINE = "attlist-define";
    @NonNls
    private static final String INLINE_ATTLIST = "inline-attlist";
    @NonNls
    private static final String ANY_NAME = "any-name";
    @NonNls
    private static final String STRICT_ANY = "strict-any";
    @NonNls
    private static final String ANNOTATION_PREFIX = "annotation-prefix";
    @NonNls
    private static final String GENERATE_START = "generate-start";
    @NonNls
    private static final String XMLNS = "xmlns";
    private JComponent myRoot;
    private JCheckBox myInlineAttlistCheckBox;
    private JTextField myColonReplacement;
    private JTextField myElementDefine;
    private JTextField myAttlistDefine;
    private JTextField myAnyName;
    private JCheckBox myStrictAnyCheckBox;
    private JTextField myAnnotationPrefix;
    private JCheckBox myGenerateStartCheckBox;
    private JTextField myDefaultNS;
    private JTable myNamespaceMap;
    private JPanel myToolbar;

    public AdvancedDtdOptions() {
        this.$$$setupUI$$$();
        this.myInlineAttlistCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AdvancedDtdOptions.this.myAttlistDefine.setEnabled(false);
                } else {
                    AdvancedDtdOptions.this.myAttlistDefine.setEnabled(true);
                }
            }
        });
        this.myNamespaceMap.setModel(new NamespaceMapModel());
        this.myNamespaceMap.getColumnModel().getColumn(0).setMaxWidth((int)((double)new JLabel((String)"Prefix").getPreferredSize().width * 1.2));
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(null, "Remove Entry", AllIcons.General.Remove){

            public void update(AnActionEvent e) {
                if (AdvancedDtdOptions.this.myNamespaceMap.getModel().getRowCount() == 0 || AdvancedDtdOptions.this.myNamespaceMap.getSelectedRow() == -1) {
                    e.getPresentation().setEnabled(false);
                } else {
                    e.getPresentation().setEnabled(true);
                }
            }

            public void actionPerformed(AnActionEvent e) {
                ((NamespaceMapModel)AdvancedDtdOptions.this.myNamespaceMap.getModel()).removeRow(AdvancedDtdOptions.this.myNamespaceMap.getSelectedRow());
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false);
        this.myToolbar.add(toolbar.getComponent());
    }

    @Override
    public JComponent getRoot() {
        return this.myRoot;
    }

    @Override
    public Map<String, ?> getOptions() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(INLINE_ATTLIST, this.myInlineAttlistCheckBox.isSelected());
        AdvancedDtdOptions.setText(map, COLON_REPLACEMENT, this.myColonReplacement);
        AdvancedDtdOptions.setText(map, ELEMENT_DEFINE, this.myElementDefine);
        AdvancedDtdOptions.setText(map, ATTLIST_DEFINE, this.myAttlistDefine);
        AdvancedDtdOptions.setText(map, ANY_NAME, this.myAnyName);
        if (this.myStrictAnyCheckBox.isSelected()) {
            map.put(STRICT_ANY, Boolean.TRUE);
        }
        AdvancedDtdOptions.setText(map, ANNOTATION_PREFIX, this.myAnnotationPrefix);
        map.put(GENERATE_START, this.myGenerateStartCheckBox.isSelected());
        if (this.myDefaultNS.getText().trim().length() > 0) {
            map.put(XMLNS, this.myDefaultNS.getText());
        }
        List<String[]> data = ((NamespaceMapModel)this.myNamespaceMap.getModel()).getData();
        for (String[] parts : data) {
            map.put("xmlns:" + parts[0], parts[1]);
        }
        return map;
    }

    private static void setText(HashMap<String, Object> map, String option, JTextField field) {
        String colonReplacement = field.getText();
        if (colonReplacement != null && colonReplacement.trim().length() > 0) {
            map.put(option, colonReplacement);
        }
    }

    @Override
    public void setOptions(Map<String, ?> inputOptions) {
        if (inputOptions.containsKey(COLON_REPLACEMENT)) {
            this.myColonReplacement.setText((String)inputOptions.get(COLON_REPLACEMENT));
        }
        this.myInlineAttlistCheckBox.setSelected(inputOptions.get(INLINE_ATTLIST) == Boolean.TRUE);
        if (inputOptions.containsKey(ELEMENT_DEFINE)) {
            this.myElementDefine.setText((String)inputOptions.get(ELEMENT_DEFINE));
        }
        if (inputOptions.containsKey(ATTLIST_DEFINE)) {
            this.myAttlistDefine.setText((String)inputOptions.get(ATTLIST_DEFINE));
        }
        if (inputOptions.containsKey(ANY_NAME)) {
            this.myAnyName.setText((String)inputOptions.get(ANY_NAME));
        }
        this.myStrictAnyCheckBox.setSelected(inputOptions.get(STRICT_ANY) == Boolean.TRUE);
        if (inputOptions.containsKey(ANNOTATION_PREFIX)) {
            this.myAnnotationPrefix.setText((String)inputOptions.get(ANNOTATION_PREFIX));
        }
        this.myGenerateStartCheckBox.setSelected(inputOptions.get(GENERATE_START) == Boolean.TRUE);
        if (inputOptions.containsKey(XMLNS)) {
            this.myDefaultNS.setText((String)inputOptions.get(XMLNS));
        }
        NamespaceMapModel model = (NamespaceMapModel)this.myNamespaceMap.getModel();
        Set<String> set = inputOptions.keySet();
        String prefix = "xmlns:";
        for (String s : set) {
            if (!s.startsWith("xmlns:")) continue;
            model.addMapping(s.substring("xmlns:".length()), (String)inputOptions.get(s));
        }
    }

    public static Map<String, ?> prepareNamespaceMap(Project project2, VirtualFile firstFile) {
        PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(firstFile);
        if (file2 == null) {
            return Collections.emptyMap();
        }
        final LinkedHashMap map = new LinkedHashMap();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                String[] parts;
                String s;
                if (element instanceof XmlElementDecl) {
                    String[] parts2;
                    String s2 = ((XmlElementDecl)element).getName();
                    if (s2 != null && (parts2 = s2.split(":")).length > 1) {
                        map.put("xmlns:" + parts2[0], null);
                    }
                } else if (element instanceof XmlAttributeDecl && (s = ((XmlAttributeDecl)element).getName()) != null && (parts = s.split(":")).length > 1) {
                    map.put("xmlns:" + parts[0], null);
                }
                super.visitElement(element);
            }
        });
        return map;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTable jTable;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JCheckBox jCheckBox3;
        JPanel jPanel2 = new JPanel();
        this.myRoot = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"DTD Input", (int)0, (int)0, null, null));
        this.myInlineAttlistCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText(INLINE_ATTLIST);
        jCheckBox3.setMnemonic('I');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jCheckBox3.setToolTipText("Specifies not to generate definitions for attribute list declarations and instead move attributes declared in attribute list declarations into the definitions generated for element declarations. This is the default behavior when the output module is xsd. Otherwise, the default behaviour is as described in the -i no-inline-attlist parameter.  ");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("colon-replacement:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jLabel.setToolTipText("Replaces colons in element names by chars when constructing the names of definitions used to represent the element declarations and attribute list declarations in the DTD. Trang generates a definition for each element declaration and attlist declaration in the DTD. The name of the definition is based on the name of the element. In RELAX NG, the names of definitions cannot contain colons. However, in the DTD, the element name may contain a colon. By default, Trang will first try to use the element names without prefixes. If this causes a conflict, it will instead replace the colon by a legal name character (it try first to use a period).  ");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myColonReplacement = jTextField6 = new JTextField();
        jPanel2.add((Component)jTextField6, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("element-define:");
        jLabel2.setDisplayedMnemonic('E');
        jLabel2.setDisplayedMnemonicIndex(0);
        jLabel2.setToolTipText("Specifies how to construct the name of the definition representing an element declaration from the name of the element. The name-pattern must contain exactly one percent character. This percent character is replaced by the name of element (after colon replacement) and the result is used as the name of the definition");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myElementDefine = jTextField5 = new JTextField();
        jPanel2.add((Component)jTextField5, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("attlist-define:");
        jLabel3.setDisplayedMnemonic('A');
        jLabel3.setDisplayedMnemonicIndex(0);
        jLabel3.setToolTipText("This specifies how to construct the name of the definition representing an attribute list declaration from the name of the element. The name-pattern must contain exactly one percent character. This percent character is replaced by the name of element (after colon replacement) and the result is used as the name of the definition.  ");
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myAttlistDefine = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("any-name:");
        jLabel4.setDisplayedMnemonic('N');
        jLabel4.setDisplayedMnemonicIndex(1);
        jLabel4.setToolTipText("Specifies the name of the definition generated for the content of elements declared in the DTD as having a content model of ANY.");
        jPanel2.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAnyName = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myStrictAnyCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText(STRICT_ANY);
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jCheckBox2.setToolTipText("Preserves the exact semantics of ANY content models by using an explicit choice of references to all declared elements. By default, Trang uses a wildcard that allows any element.  ");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("annotation-prefix:");
        jLabel5.setDisplayedMnemonic('O');
        jLabel5.setDisplayedMnemonicIndex(3);
        jLabel5.setToolTipText("Default values are represented using an annotation attribute prefix:defaultValue where prefix is bound to http://relaxng.org/ns/compatibility/annotations/1.0 as defined by the RELAX NG DTD Compatibility Committee Specification. By default, Trang will use a for prefix unless that conflicts with a prefix used in the DTD.  ");
        jPanel2.add((Component)jLabel5, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAnnotationPrefix = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myGenerateStartCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText(GENERATE_START);
        jCheckBox.setMnemonic('G');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setToolTipText("Specifies whether Trang should generate a start element. DTDs do not indicate what elements are allowed as document elements. Trang assumes that all elements that are defined but never referenced are allowed as document elements.  ");
        jPanel2.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Namespace Settings", (int)0, (int)0, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Default:");
        jLabel6.setDisplayedMnemonic('D');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDefaultNS = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myNamespaceMap = jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(250, 70));
        jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        jScrollPane.setViewportView(jTable);
        this.myToolbar = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 2, 1, 1, 8, 2, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField6);
        jLabel2.setLabelFor(jTextField5);
        jLabel3.setLabelFor(jTextField4);
        jLabel4.setLabelFor(jTextField3);
        jLabel5.setLabelFor(jTextField2);
        jLabel6.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static class NamespaceMapModel
    extends AbstractTableModel {
        private final List<String[]> myList = new ArrayList<String[]>();

        private NamespaceMapModel() {
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Prefix" : "URI";
        }

        @Override
        public int getRowCount() {
            return this.myList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.myList.get((int)rowIndex)[columnIndex] = (String)aValue;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myList.get(rowIndex)[columnIndex];
        }

        public void addMapping(String prefix, String uri) {
            this.myList.add(new String[]{prefix, uri});
            this.fireTableRowsInserted(this.myList.size() - 1, this.myList.size() - 1);
        }

        public void removeRow(int row) {
            this.myList.remove(row);
            this.fireTableRowsDeleted(row - 1, row - 1);
        }

        public List<String[]> getData() {
            return this.myList;
        }
    }
}

