/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.relaxNG.references.AddValueCondition;
import org.intellij.plugins.relaxNG.references.AttributeValueCondition;
import org.intellij.plugins.relaxNG.references.AttributeValueFunction;
import org.intellij.plugins.relaxNG.references.ResolvingVisitor;
import org.jetbrains.annotations.NotNull;

public class IdRefProvider
extends PsiReferenceProvider {
    public static final HasIdRefTypeCondition HAS_ID_REF_TYPE = new HasIdRefTypeCondition();
    public static final HasIdTypeCondition HAS_ID_TYPE = new HasIdTypeCondition();

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/references/IdRefProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/relaxNG/references/IdRefProvider", "getReferencesByElement"));
        }
        XmlAttributeValue value = (XmlAttributeValue)element;
        if (IdRefProvider.hasIdRefType(value)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new IdReference(value)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/IdRefProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (IdRefProvider.hasIdType(value)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new AttributeValueSelfReference(element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/IdRefProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/IdRefProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean hasIdType(XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor = ((XmlAttribute)xmlAttributeValue.getParent()).getDescriptor();
        return descriptor != null && descriptor.hasIdType();
    }

    private static boolean hasIdRefType(XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor = ((XmlAttribute)xmlAttributeValue.getParent()).getDescriptor();
        return descriptor != null && descriptor.hasIdRefType();
    }

    static class HasIdRefTypeCondition
    extends PatternCondition<XmlAttributeValue> {
        public HasIdRefTypeCondition() {
            super("IdRef");
        }

        public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
            if (xmlAttributeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/intellij/plugins/relaxNG/references/IdRefProvider$HasIdRefTypeCondition", "accepts"));
            }
            return IdRefProvider.hasIdRefType(xmlAttributeValue);
        }
    }

    static class HasIdTypeCondition
    extends PatternCondition<XmlAttributeValue> {
        public HasIdTypeCondition() {
            super("IdType");
        }

        public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
            if (xmlAttributeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/intellij/plugins/relaxNG/references/IdRefProvider$HasIdTypeCondition", "accepts"));
            }
            return IdRefProvider.hasIdType(xmlAttributeValue);
        }
    }

    private static class IdReference
    extends PsiReferenceBase<XmlAttributeValue> {
        private static final Key<XmlAttributeValue> TARGET = Key.create((String)"target");
        private static final Key<Set<XmlAttributeValue>> VARIANTS = Key.create((String)"variants");
        private static final XmlAttributeValuePattern PATTERN = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute())).with((PatternCondition)HAS_ID_TYPE);
        private final AttributeValueCondition myCondition;

        public IdReference(XmlAttributeValue element) {
            super((PsiElement)element, TextRange.from((int)1, (int)(element.getTextLength() - 2)), true);
            this.myCondition = new AttributeValueCondition(element.getValue());
        }

        public PsiElement resolve() {
            final ProcessingContext context = new ProcessingContext();
            ResolvingVisitor visitor = new ResolvingVisitor((XmlAttributeValuePattern)((XmlAttributeValuePattern)PATTERN.with((PatternCondition)this.myCondition)).save(TARGET), context){

                @Override
                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    if (this.shouldContinue()) {
                        this.visitSubTags(tag);
                    }
                }

                @Override
                protected boolean shouldContinue() {
                    return context.get(TARGET) == null;
                }
            };
            this.process(visitor);
            return (PsiElement)context.get(TARGET);
        }

        private void process(ResolvingVisitor visitor) {
            XmlDocument document2 = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlDocument.class);
            if (document2 != null) {
                visitor.execute((PsiElement)document2);
            }
        }

        @NotNull
        public Object[] getVariants() {
            ProcessingContext context = new ProcessingContext();
            context.put(VARIANTS, new HashSet());
            ResolvingVisitor visitor = new ResolvingVisitor((XmlAttributeValuePattern)PATTERN.with(AddValueCondition.create(VARIANTS)), context){

                @Override
                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    this.visitSubTags(tag);
                }
            };
            this.process(visitor);
            Object[] objectArray = AttributeValueFunction.toStrings((Set)context.get(VARIANTS));
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/IdRefProvider$IdReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

