/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"getSpecifiedProperties", "Lorg/jetbrains/concurrency/Promise;", "", "Lorg/jetbrains/debugger/Variable;", "variables", "names", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "script-debugger-backend"})
public final class ObjectValueBaseKt {
    @NotNull
    public static final Promise<List<Variable>> getSpecifiedProperties(@NotNull List<? extends Variable> variables, @NotNull List<String> names, @NotNull EvaluateContext evaluateContext2) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
        SmartList properties = new SmartList();
        int getterCount = 0;
        for (Variable variable : variables) {
            if (!variable.isReadable() || !names.contains(variable.getName())) continue;
            if (!properties.isEmpty()) {
                Collections.sort((List)properties, (Comparator)new Comparator<Variable>(names){
                    final /* synthetic */ List $names;

                    public int compare(@NotNull Variable o1, @NotNull Variable o2) {
                        Intrinsics.checkParameterIsNotNull((Object)o1, (String)"o1");
                        Intrinsics.checkParameterIsNotNull((Object)o2, (String)"o2");
                        return this.$names.indexOf(o1.getName()) - this.$names.indexOf(o2.getName());
                    }
                    {
                        this.$names = $captured_local_variable$0;
                    }
                });
            }
            properties.add((Object)variable);
            if (variable.getValue() != null) continue;
            ++getterCount;
        }
        if (getterCount == 0) {
            Promise promise2 = Promise.resolve((Object)properties);
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.resolve(properties)");
            return promise2;
        }
        SmartList smartList = new SmartList();
        for (Variable variable : properties) {
            if (variable.getValue() != null) continue;
            ValueModifier valueModifier = variable.getValueModifier();
            boolean bl = valueModifier != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ValueModifier valueModifier2 = valueModifier;
            if (valueModifier2 == null) {
                Intrinsics.throwNpe();
            }
            Variable variable2 = variable;
            Intrinsics.checkExpressionValueIsNotNull((Object)variable2, (String)"variable");
            smartList.add(valueModifier2.evaluateGet(variable2, evaluateContext2));
        }
        Promise promise3 = Promise.all((Collection)((Collection)smartList), (Object)properties);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"Promise.all<List<Variable>>(promises, properties)");
        return promise3;
    }
}

