/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public abstract class AbstractVerb<T extends AbstractVerb<T>> {
    private final FailureStrategy failureStrategy;

    public AbstractVerb(FailureStrategy failureStrategy) {
        this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
    }

    protected FailureStrategy getFailureStrategy() {
        return this.hasFailureMessage() ? new MessagePrependingFailureStrategy(this.failureStrategy, this) : this.failureStrategy;
    }

    public void fail() {
        this.getFailureStrategy().fail("");
    }

    public void fail(@Nullable String format, Object ... args) {
        this.getFailureStrategy().fail(StringUtil.format(format, args));
    }

    @CheckReturnValue
    public abstract T withFailureMessage(@Nullable String var1);

    @Nullable
    protected abstract String getFailureMessage();

    protected boolean hasFailureMessage() {
        return false;
    }

    public <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> DelegatedVerb<S, T> about(SF factory) {
        return new DelegatedVerb(this.getFailureStrategy(), factory);
    }

    protected static class MessagePrependingFailureStrategy
    extends FailureStrategy {
        private final FailureStrategy delegate;
        private final AbstractVerb<?> verb;

        protected MessagePrependingFailureStrategy(FailureStrategy delegate, AbstractVerb<?> verb) {
            this.delegate = (FailureStrategy)Preconditions.checkNotNull((Object)delegate);
            this.verb = (AbstractVerb)Preconditions.checkNotNull(verb);
        }

        @Override
        public void fail(String message) {
            String string = this.verb.getFailureMessage();
            this.delegate.fail(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(message).length()).append(string).append(": ").append(message).toString());
        }

        @Override
        public void fail(String message, Throwable cause) {
            String string = this.verb.getFailureMessage();
            this.delegate.fail(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(message).length()).append(string).append(": ").append(message).toString(), cause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            String string = this.verb.getFailureMessage();
            String string2 = StringUtil.messageFor(message, expected, actual);
            this.delegate.fail(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString());
        }
    }

    public static class DelegatedVerb<S extends Subject<S, T>, T> {
        private final SubjectFactory<S, T> factory;
        private final FailureStrategy failureStrategy;

        public DelegatedVerb(FailureStrategy failureStrategy, SubjectFactory<S, T> factory) {
            this.factory = (SubjectFactory)Preconditions.checkNotNull(factory);
            this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
        }

        @CheckReturnValue
        public S that(T target) {
            return this.factory.getSubject(this.failureStrategy, target);
        }
    }
}

