/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.intellij.lang.xpath.completion.ElementProvider;
import org.intellij.lang.xpath.completion.FunctionLookup;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.impl.XsltLanguage;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.transform.JDOMSource;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltDocumentationProvider
implements DocumentationProvider {
    private java.lang.ref.SoftReference<Templates> myTemplates;
    private java.lang.ref.SoftReference<Document> myDocument;
    private static final Pattern check = Pattern.compile("x:found=\"(true|false)\"");

    @Nullable
    public List<String> getUrlFor(PsiElement psiElement, PsiElement psiElement1) {
        String category;
        String name;
        if (psiElement instanceof XsltElement) {
            return null;
        }
        String tagName = XsltDocumentationProvider.getTagName(psiElement);
        if (tagName != null) {
            name = tagName;
            category = "element";
        } else if (psiElement instanceof XPathFunction) {
            name = ((XPathFunction)psiElement).getName();
            category = "function";
        } else if (psiElement instanceof DocElement) {
            name = ((DocElement)psiElement).getName();
            category = ((DocElement)psiElement).getCategory();
        } else {
            return null;
        }
        try {
            Document document = this.getDocumentationDocument();
            XPath xPath = XPath.newInstance((String)("//x:" + category + "[@name = '" + name + "']"));
            xPath.addNamespace("x", document.getRootElement().getNamespaceURI());
            Element e = (Element)xPath.selectSingleNode((Object)document);
            if (e != null) {
                return Collections.singletonList(e.getParentElement().getAttributeValue("base") + e.getAttributeValue("href"));
            }
        }
        catch (Exception e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement psiElement, PsiElement psiElement1) {
        if (psiElement instanceof DocElement) {
            DocElement element = (DocElement)psiElement;
            return this.getDocumentation(element.getName(), element.getCategory());
        }
        if (psiElement instanceof XsltElement) {
            XmlTag t = ((XsltElement)psiElement).getTag();
            PsiElement p = t.getPrevSibling();
            while (p instanceof PsiWhiteSpace || p instanceof XmlText) {
                p = p.getPrevSibling();
            }
            if (p instanceof XmlComment) {
                String commentText = XmlUtil.getCommentText((XmlComment)((XmlComment)p));
                return commentText != null ? commentText.replaceAll("&", "&amp;").replaceAll("<", "&lt;") : null;
            }
            return null;
        }
        String name = XsltDocumentationProvider.getTagName(psiElement);
        if (name != null) {
            return this.getDocumentation(name, "element");
        }
        if (psiElement instanceof XPathFunction) {
            return this.getDocumentation(((XPathFunction)psiElement).getName(), "function");
        }
        return null;
    }

    @Nullable
    private String getDocumentation(String name, String type) {
        try {
            Transformer transformer = this.getTemplate().newTransformer();
            transformer.setParameter("element", name);
            transformer.setParameter("type", type);
            StringWriter writer = new StringWriter();
            transformer.transform((Source)new JDOMSource(this.getDocumentationDocument()), new StreamResult(writer));
            String s = writer.toString();
            Matcher matcher = check.matcher(s);
            if (matcher.find() && matcher.group(1).equals("true")) {
                return s.replaceFirst("<META.+?>", "");
            }
        }
        catch (Exception e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
        return null;
    }

    @Nullable
    private static String getTagName(@Nullable PsiElement psiElement1) {
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement1, XmlTag.class, (boolean)false);
        if (xmlTag != null) {
            XmlTag tag;
            PsiFile file;
            if (XsltSupport.isXsltTag(xmlTag)) {
                return xmlTag.getLocalName();
            }
            if (XmlUtil.ourSchemaUrisList.contains(xmlTag.getNamespace()) && (file = xmlTag.getContainingFile()) instanceof XmlFile && (tag = ((XmlFile)file).getRootTag()) != null && "http://www.w3.org/1999/XSL/Transform".equals(tag.getAttributeValue("targetNamespace"))) {
                return xmlTag.getAttributeValue("name");
            }
        }
        return null;
    }

    private Document getDocumentationDocument() throws IOException, JDOMException {
        Document d = (Document)SoftReference.dereference(this.myDocument);
        if (d == null) {
            d = new SAXBuilder().build(XsltSupport.class.getResource("resources/documentation.xml"));
            this.myDocument = new java.lang.ref.SoftReference<Document>(d);
        }
        return d;
    }

    private Templates getTemplate() throws TransformerConfigurationException, IOException {
        Templates t = (Templates)SoftReference.dereference(this.myTemplates);
        if (t == null) {
            t = TransformerFactory.newInstance().newTemplates(XsltDocumentationProvider.makeSource("resources/documentation.xsl"));
            this.myTemplates = new java.lang.ref.SoftReference<Templates>(t);
        }
        return t;
    }

    private static StreamSource makeSource(String name) throws IOException {
        URL resource = XsltSupport.class.getResource(name);
        return new StreamSource(resource.openStream(), resource.toExternalForm());
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager mgr, Object object, PsiElement psiElement) {
        XmlTag tag;
        if (object instanceof String && psiElement instanceof XmlElement && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class)) != null && "http://www.w3.org/1999/XSL/Transform".equals(tag.getNamespace())) {
            String prefix = tag.getNamespacePrefix();
            if (prefix.length() == 0) {
                return new DocElement(mgr, psiElement, "element", (String)object);
            }
            if (StringUtil.startsWithConcatenation((String)((String)object), (String[])new String[]{prefix, ":"})) {
                return new DocElement(mgr, psiElement, "element", ((String)object).substring(prefix.length() + 1));
            }
        }
        if (object instanceof FunctionLookup) {
            FunctionLookup lookup = (FunctionLookup)object;
            return new DocElement(mgr, psiElement, "function", lookup.getName());
        }
        if (object instanceof ElementProvider) {
            return ((ElementProvider)object).getElement();
        }
        if (object instanceof XsltElement) {
            return (PsiElement)object;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager mgr, String string, PsiElement psiElement) {
        String[] strings = string.split("\\$");
        if (strings.length == 2) {
            return new DocElement(mgr, psiElement, strings[0], strings[1]);
        }
        return null;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    static class DocElement
    extends LightElement
    implements PsiNamedElement {
        private final PsiElement myElement;
        private final String myCategory;
        private final String myName;

        public DocElement(PsiManager mgr, PsiElement element, String category, String name) {
            super(mgr, (Language)XsltLanguage.INSTANCE);
            this.myElement = element;
            this.myCategory = category;
            this.myName = name;
        }

        public String getCategory() {
            return this.myCategory;
        }

        public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/intellij/lang/xpath/xslt/impl/XsltDocumentationProvider$DocElement", "setName"));
            }
            throw new IncorrectOperationException("Unsupported");
        }

        public String getName() {
            return this.myName;
        }

        public String toString() {
            return "DocElement";
        }

        public PsiElement copy() {
            return this;
        }

        public boolean isValid() {
            return this.myElement != null && this.myElement.isValid();
        }

        @Nullable
        public PsiFile getContainingFile() {
            PsiFile f;
            if (!this.isValid()) {
                return null;
            }
            PsiFile file = this.myElement.getContainingFile();
            PsiElement context = this.myElement.getContext();
            if (file == null && context != null) {
                file = context.getContainingFile();
            }
            if ((f = (PsiFile)PsiTreeUtil.getContextOfType((PsiElement)file, PsiFile.class, (boolean)true)) instanceof XmlFile) {
                return f;
            }
            return file;
        }
    }
}

