/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.support.jaxen;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Collections;
import java.util.Iterator;
import org.intellij.plugins.xpathView.support.jaxen.AttributeIterator;
import org.intellij.plugins.xpathView.support.jaxen.NodeIterator;
import org.intellij.plugins.xpathView.support.jaxen.PsiChildAxisIterator;
import org.intellij.plugins.xpathView.support.jaxen.PsiXPath;
import org.intellij.plugins.xpathView.util.MyPsiUtil;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.jetbrains.annotations.NotNull;

public class PsiDocumentNavigator
extends DefaultNavigator {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.xpathView.support.jaxen.PsiDocumentNavigator");
    private final XmlFile file;

    public PsiDocumentNavigator(XmlFile file) {
        this.file = file;
    }

    public Iterator getChildAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getChildAxisIterator " + contextNode);
        }
        if (!(contextNode instanceof XmlElement)) {
            return Collections.emptyList().iterator();
        }
        return new PsiChildAxisIterator(contextNode);
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getParentAxisIterator " + contextNode);
        }
        if (!(contextNode instanceof XmlElement)) {
            return Collections.emptyList().iterator();
        }
        return new NodeIterator((PsiElement)((XmlElement)contextNode)){

            @Override
            protected PsiElement getFirstNode(PsiElement n) {
                while (n != null) {
                    if (!((n = n.getParent()) instanceof XmlTag)) continue;
                    return n;
                }
                return null;
            }

            @Override
            protected PsiElement getNextNode(PsiElement n) {
                return null;
            }
        };
    }

    public Iterator getNamespaceAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getNamespaceAxisIterator()");
        }
        return super.getNamespaceAxisIterator(contextNode);
    }

    public Object getDocumentNode(Object contextNode) {
        LOG.debug("enter: getDocumentNode");
        if (contextNode instanceof XmlDocument) {
            return contextNode;
        }
        while (contextNode instanceof PsiElement) {
            if (contextNode instanceof XmlDocument) {
                return contextNode;
            }
            contextNode = ((PsiElement)contextNode).getParent();
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String prefix, Object element) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: translateNamespacePrefixToUri()");
        }
        if (this.isElement(element)) {
            return ((XmlTag)element).getNamespaceByPrefix(prefix);
        }
        return super.translateNamespacePrefixToUri(prefix, element);
    }

    public String getProcessingInstructionTarget(Object obj) {
        LOG.debug("enter: getProcessingInstructionTarget");
        LOG.assertTrue(obj instanceof XmlProcessingInstruction);
        XmlProcessingInstruction pi = (XmlProcessingInstruction)obj;
        return PsiDocumentNavigator.getProcessingInstructionTarget(pi);
    }

    public static String getProcessingInstructionTarget(XmlProcessingInstruction pi) {
        int i;
        PsiElement[] children = pi.getChildren();
        LOG.assertTrue(children[1] instanceof XmlToken && ((XmlToken)children[1]).getTokenType() == XmlTokenType.XML_NAME, (Object)"Unknown PI structure");
        String text = children[1].getText();
        for (i = 0; i < text.length() && text.charAt(i) == ' '; ++i) {
        }
        int pos = text.indexOf(32, i);
        text = pos != -1 ? text.substring(i, pos) : text.substring(i);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target: " + text);
        }
        return text;
    }

    @NotNull
    public String getProcessingInstructionData(Object obj) {
        LOG.debug("enter: getProcessingInstructionData");
        LOG.assertTrue(obj instanceof XmlProcessingInstruction);
        XmlProcessingInstruction pi = (XmlProcessingInstruction)obj;
        int targetLength = this.getProcessingInstructionTarget(obj).length();
        int piLength = pi.getText().length();
        String s = pi.getText().substring(2 + targetLength, piLength - 2).trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data: " + s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator", "getProcessingInstructionData"));
        }
        return string;
    }

    public Object getParentNode(Object contextNode) throws UnsupportedAxisException {
        return ((PsiElement)contextNode).getParent();
    }

    public Object getDocument(String url) throws FunctionCallException {
        LOG.debug("enter: getDocument: " + url);
        VirtualFile virtualFile = VfsUtil.findRelativeFile((String)url, (VirtualFile)this.file.getVirtualFile());
        if (virtualFile != null) {
            LOG.debug("document() -> VirtualFile = " + virtualFile.getPath());
            PsiFile file = this.file.getManager().findFile(virtualFile);
            if (file instanceof XmlFile) {
                return ((XmlFile)file).getDocument();
            }
        }
        return null;
    }

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (this.isElement(contextNode)) {
            return new AttributeIterator((XmlElement)contextNode);
        }
        return Collections.emptyList().iterator();
    }

    public String getElementNamespaceUri(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        XmlTag context = (XmlTag)element;
        String namespaceUri = context.getNamespace();
        if (!MyPsiUtil.isInDeclaredNamespace(context, namespaceUri, context.getNamespacePrefix())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getElementNamespaceUri: not returning implicit namespace uri: " + namespaceUri);
            }
            return "";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getElementNamespaceUri: " + namespaceUri);
        }
        return namespaceUri;
    }

    public String getElementName(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        String name = ((XmlTag)element).getLocalName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getElementName: " + name);
        }
        return name;
    }

    public String getElementQName(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getElementQName: " + ((XmlTag)element).getName());
        }
        return ((XmlTag)element).getName();
    }

    public String getAttributeNamespaceUri(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        XmlAttribute attribute = (XmlAttribute)attr;
        String name = attribute.getName();
        if (name.indexOf(58) == -1) {
            return "";
        }
        String uri = attribute.getNamespace();
        if (!MyPsiUtil.isInDeclaredNamespace(attribute.getParent(), uri, MyPsiUtil.getAttributePrefix(attribute))) {
            LOG.info("getElementNamespaceUri: not returning implicit attribute-namespace uri: " + uri);
            return "";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAttributeNamespaceUri: " + uri);
        }
        return uri;
    }

    public String getAttributeName(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        String name = ((XmlAttribute)attr).getLocalName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAttributeName: " + name);
        }
        return name;
    }

    public String getAttributeQName(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getAttributeQName");
        }
        return ((XmlAttribute)attr).getName();
    }

    public boolean isDocument(Object object) {
        boolean b = object instanceof XmlDocument;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: isDocument(): " + object + " = " + b);
        }
        return b;
    }

    public boolean isElement(Object object) {
        boolean b = object instanceof XmlTag;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: isElement(): " + object + " = " + b);
        }
        return b && PsiDocumentNavigator.isSupportedElement((XmlTag)object);
    }

    private static boolean isSupportedElement(XmlTag object) {
        return object.getLanguage() == XMLLanguage.INSTANCE || MyPsiUtil.findNameElement(object) != null;
    }

    public boolean isAttribute(Object object) {
        boolean b = object instanceof XmlAttribute;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: isAttribute(): " + object + " = " + b);
        }
        return b;
    }

    public boolean isNamespace(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: isNamespace(): " + object);
        }
        return false;
    }

    public boolean isComment(Object object) {
        boolean b = object instanceof XmlComment;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: isComment():" + object + " = " + b);
        }
        return b;
    }

    public boolean isText(Object object) {
        boolean b = object instanceof PsiWhiteSpace ? ((PsiWhiteSpace)object).getParent() instanceof XmlText : object instanceof XmlText;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: isText():" + object + " = " + b);
        }
        return b;
    }

    public boolean isProcessingInstruction(Object object) {
        boolean b = object instanceof XmlProcessingInstruction;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: isProcessingInstruction(): " + object + " = " + b);
        }
        return b;
    }

    @NotNull
    public String getCommentStringValue(Object comment) {
        PsiElement[] children;
        LOG.assertTrue(comment instanceof XmlComment);
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getCommentStringValue()");
        }
        PsiElement c = (PsiElement)comment;
        for (PsiElement child : children = c.getChildren()) {
            if (!(child instanceof XmlToken) || ((XmlToken)child).getTokenType() != XmlTokenType.XML_COMMENT_CHARACTERS) continue;
            String string = child.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator", "getCommentStringValue"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator", "getCommentStringValue"));
        }
        return "";
    }

    @NotNull
    public String getElementStringValue(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getElementStringValue()");
        }
        TextCollector collector = new TextCollector();
        ((XmlTag)element).accept((PsiElementVisitor)collector);
        String string = collector.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator", "getElementStringValue"));
        }
        return string;
    }

    @NotNull
    public String getAttributeStringValue(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        String string = StringUtil.notNullize((String)((XmlAttribute)attr).getValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator", "getAttributeStringValue"));
        }
        return string;
    }

    public String getNamespaceStringValue(Object ns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getNamespaceStringValue");
            LOG.debug("ns = " + ns);
        }
        return null;
    }

    public String getNamespacePrefix(Object ns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getNamespacePrefix");
            LOG.debug("ns = " + ns);
        }
        return null;
    }

    @NotNull
    public String getTextStringValue(Object txt) {
        LOG.debug("enter: getTextStringValue");
        if (txt instanceof XmlText) {
            String string = ((XmlText)txt).getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator", "getTextStringValue"));
            }
            return string;
        }
        String string = txt instanceof PsiElement ? ((PsiElement)txt).getText() : txt.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator", "getTextStringValue"));
        }
        return string;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new PsiXPath(this.file, xpath);
    }

    public Object getElementById(Object object, final String elementId) {
        XmlTag rootTag;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: getElementById: " + object + " -- " + elementId);
        }
        if ((rootTag = ((XmlFile)((XmlElement)object).getContainingFile()).getRootTag()) == null) {
            return null;
        }
        final Ref ref = new Ref();
        rootTag.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (ref.get() == null) {
                    super.visitElement(element);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                String value = attribute.getValue();
                if (value != null && descriptor != null && descriptor.hasIdType() && elementId.equals(value)) {
                    ref.set((Object)attribute.getParent());
                }
            }
        });
        return ref.get();
    }

    static class TextCollector
    extends XmlRecursiveElementVisitor {
        private final StringBuffer builder = new StringBuffer();

        TextCollector() {
        }

        public void visitXmlText(XmlText text) {
            this.builder.append(text.getValue());
        }

        public String getText() {
            return this.builder.toString();
        }
    }
}

