/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ui.UIUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibraryKt;
import org.jetbrains.settingsRepository.CredentialsStoreKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.UtilKt;
import org.jetbrains.settingsRepository.git.GitCredentialKt;
import org.jetbrains.settingsRepository.git.JGitCredentialsProviderKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J*\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0016\"\u00020\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0016J!\u0010\u001b\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0016\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsStore", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "(Lcom/intellij/openapi/util/NotNullLazyValue;Lorg/eclipse/jgit/lib/Repository;)V", "credentialsFromGit", "Lorg/jetbrains/keychain/Credentials;", "doGet", "", "uri", "Lorg/eclipse/jgit/transport/URIish;", "userNameItem", "Lorg/eclipse/jgit/transport/CredentialItem$Username;", "passwordItem", "Lorg/eclipse/jgit/transport/CredentialItem;", "sshKeyFile", "", "get", "items", "", "(Lorg/eclipse/jgit/transport/URIish;[Lorg/eclipse/jgit/transport/CredentialItem;)Z", "isInteractive", "reset", "", "supports", "([Lorg/eclipse/jgit/transport/CredentialItem;)Z", "settings-repository"})
public final class JGitCredentialsProvider
extends CredentialsProvider {
    private Credentials credentialsFromGit;
    private final NotNullLazyValue<CredentialsStore> credentialsStore;
    private final Repository repository;

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        for (int i = 0; i < items.length; ++i) {
            CredentialItem item = items[i];
            if (item instanceof CredentialItem.Password || item instanceof CredentialItem.Username || item instanceof CredentialItem.StringType || item instanceof CredentialItem.YesNoType) continue;
            return false;
        }
        return true;
    }

    public boolean get(@NotNull URIish uri, CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        CredentialItem.Username userNameItem = null;
        CredentialItem passwordItem = null;
        String sshKeyFile = null;
        for (int i = 0; i < items.length; ++i) {
            CredentialItem item = items[i];
            if (item instanceof CredentialItem.Username) {
                userNameItem = (CredentialItem.Username)item;
                continue;
            }
            if (item instanceof CredentialItem.Password) {
                passwordItem = item;
                continue;
            }
            if (item instanceof CredentialItem.StringType) {
                String marker;
                String promptText = ((CredentialItem.StringType)item).getPromptText();
                if (promptText == null || !StringsKt.startsWith$default((String)promptText, (String)(marker = "Passphrase for "), (boolean)false, (int)2, null)) continue;
                String string = promptText;
                int n = marker.length();
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                passwordItem = item;
                continue;
            }
            if (!(item instanceof CredentialItem.YesNoType)) continue;
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(item){
                final /* synthetic */ CredentialItem $item;

                public final void run() {
                    CredentialItem.YesNoType yesNoType = (CredentialItem.YesNoType)this.$item;
                    String string = ((CredentialItem.YesNoType)this.$item).getPromptText();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    yesNoType.setValue(MessageDialogBuilder.yesNo((String)"", (String)string).show() == 0);
                }
                {
                    this.$item = credentialItem;
                }
            });
            return true;
        }
        if (userNameItem == null && passwordItem == null) {
            return false;
        }
        return this.doGet(uri, userNameItem, passwordItem, sshKeyFile);
    }

    private final boolean doGet(URIish uri, CredentialItem.Username userNameItem, CredentialItem passwordItem, String sshKeyFile) {
        Credentials credentials;
        String userFromUri = sshKeyFile == null ? UtilKt.nullize(uri.getUser()) : (String)null;
        String passwordFromUri = UtilKt.nullize(uri.getPass());
        boolean saveCredentialsToStore = false;
        if (userFromUri != null && passwordFromUri != null) {
            credentials = new Credentials(userFromUri, passwordFromUri);
        } else {
            if (sshKeyFile == null || !OSXKeychainLibraryKt.isOSXCredentialsStoreSupported()) {
                if (this.credentialsFromGit == null) {
                    this.credentialsFromGit = GitCredentialKt.getCredentialsUsingGit(uri, this.repository);
                }
                credentials = this.credentialsFromGit;
            } else {
                credentials = null;
            }
            if (credentials == null) {
                try {
                    credentials = ((CredentialsStore)this.credentialsStore.getValue()).get(uri.getHost(), sshKeyFile);
                }
                catch (Throwable e) {
                    IcsManagerKt.getLOG().error(e);
                }
                saveCredentialsToStore = true;
                if (userFromUri != null) {
                    Credentials credentials2 = credentials;
                    if (Intrinsics.areEqual((Object)userFromUri, (Object)(credentials2 != null ? credentials2.getId() : null)) ^ true) {
                        credentials = new Credentials(userFromUri, passwordFromUri);
                    } else if (passwordFromUri != null) {
                        Credentials credentials3 = credentials;
                        if (Intrinsics.areEqual((Object)passwordFromUri, (Object)(credentials3 != null ? credentials3.getToken() : null)) ^ true) {
                            credentials = new Credentials(userFromUri, passwordFromUri);
                        }
                    }
                }
            }
        }
        if (!org.jetbrains.keychain.CredentialsStoreKt.isFulfilled(credentials)) {
            credentials = CredentialsStoreKt.showAuthenticationForm(credentials, JGitCredentialsProviderKt.toStringWithoutCredentials(uri), uri.getHost(), uri.getPath(), sshKeyFile);
        }
        if (saveCredentialsToStore && org.jetbrains.keychain.CredentialsStoreKt.isFulfilled(credentials)) {
            CredentialsStore credentialsStore2 = (CredentialsStore)this.credentialsStore.getValue();
            String string = uri.getHost();
            Credentials credentials4 = credentials;
            if (credentials4 == null) {
                Intrinsics.throwNpe();
            }
            credentialsStore2.save(string, credentials4, sshKeyFile);
        }
        CredentialItem.Username username = userNameItem;
        if (username != null) {
            Credentials credentials5 = credentials;
            username.setValue(credentials5 != null ? credentials5.getId() : null);
        }
        if (passwordItem != null) {
            if (passwordItem instanceof CredentialItem.Password) {
                char[] cArray;
                CredentialItem.Password password = (CredentialItem.Password)passwordItem;
                Object object = credentials;
                if (object != null && (object = ((Credentials)object).getToken()) != null) {
                    Object object2 = object;
                    CredentialItem.Password password2 = password;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray2 = ((String)object3).toCharArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
                    char[] cArray3 = cArray2;
                    password = password2;
                    cArray = cArray3;
                } else {
                    cArray = null;
                }
                password.setValue(cArray);
            } else {
                CredentialItem credentialItem = passwordItem;
                if (credentialItem == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jgit.transport.CredentialItem.StringType");
                }
                Credentials credentials6 = credentials;
                ((CredentialItem.StringType)credentialItem).setValue(credentials6 != null ? credentials6.getToken() : null);
            }
        }
        return credentials != null;
    }

    public void reset(@NotNull URIish uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.credentialsFromGit = null;
        CredentialsStore credentialsStore2 = (CredentialsStore)this.credentialsStore.getValue();
        String string = uri.getHost();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        credentialsStore2.reset(string);
    }

    public JGitCredentialsProvider(@NotNull NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        this.credentialsStore = credentialsStore2;
        this.repository = repository2;
    }
}

