/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.BaseOutputReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;

public class WinTerminalProcessHandler
extends TerminalProcessHandler {
    private static final String NON_CSI_ESCAPE_CODE = "\u001b.[@-_]";
    private static final String CSI_ESCAPE_CODE = "\u001b\\[(.*?)[@-~]";

    public WinTerminalProcessHandler(@NotNull Process process, @NotNull String commandLine, boolean forceUtf8, boolean forceBinary) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "<init>"));
        }
        super(process, commandLine, forceUtf8, forceBinary);
    }

    @Override
    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.NON_BLOCKING;
        if (options == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "readerOptions"));
        }
        return options;
    }

    @Override
    @NotNull
    protected String filterCombinedText(@NotNull String currentLine) {
        if (currentLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentLine", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "filterCombinedText"));
        }
        String string = WinTerminalProcessHandler.removeAllBeforeCaretReturn(currentLine);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "filterCombinedText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String filterText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "filterText"));
        }
        text = text.replaceAll(CSI_ESCAPE_CODE, "").replaceAll(NON_CSI_ESCAPE_CODE, "");
        String string = text = StringUtil.trimLeading((String)text, (char)'\r');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "filterText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected Key resolveOutputType(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "resolveOutputType"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "resolveOutputType"));
        }
        Key key = outputType;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "resolveOutputType"));
        }
        return key;
    }

    @NotNull
    private static String removeAllBeforeCaretReturn(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "removeAllBeforeCaretReturn"));
        }
        int caretReturn = line.lastIndexOf("\r");
        while (caretReturn >= 0) {
            if (caretReturn + 1 < line.length() && line.charAt(caretReturn + 1) != '\n') {
                line = line.substring(caretReturn + 1);
                break;
            }
            caretReturn = line.lastIndexOf("\r", caretReturn - 1);
        }
        String string = line;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler", "removeAllBeforeCaretReturn"));
        }
        return string;
    }
}

