/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.Where;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class MergeInitChecksTask
extends BaseMergeTask {
    public MergeInitChecksTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/MergeInitChecksTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/MergeInitChecksTask", "<init>"));
        }
        super(mergeContext, interaction, "initial checks", Where.AWT);
    }

    public void run(ContinuationContext context) {
        SVNURL url = this.parseSourceUrl(context);
        if (url != null) {
            if (MergeInitChecksTask.areInSameHierarchy(url, this.myMergeContext.getWcInfo().getUrl())) {
                this.finishWithError(context, "Cannot merge from self", true);
            } else if (this.hasSwitchedRoots() && !this.myInteraction.shouldContinueSwitchedRootFound()) {
                context.cancelEverything();
            }
        }
    }

    private boolean hasSwitchedRoots() {
        final File currentRoot = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        return ContainerUtil.or(this.myMergeContext.getVcs().getAllWcInfos(), (Condition)new Condition<WCInfo>(){

            public boolean value(WCInfo info) {
                return NestedCopyType.switched.equals((Object)info.getType()) && FileUtil.isAncestor((File)currentRoot, (File)info.getRootInfo().getIoFile(), (boolean)true);
            }
        });
    }

    private static boolean areInSameHierarchy(@NotNull SVNURL url1, @NotNull SVNURL url2) {
        if (url1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url1", "org/jetbrains/idea/svn/integrate/MergeInitChecksTask", "areInSameHierarchy"));
        }
        if (url2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url2", "org/jetbrains/idea/svn/integrate/MergeInitChecksTask", "areInSameHierarchy"));
        }
        return SVNURLUtil.isAncestor((SVNURL)url1, (SVNURL)url2) || SVNURLUtil.isAncestor((SVNURL)url2, (SVNURL)url1);
    }
}

