/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.jpeg;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.TruncatedFileException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class JPEGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] sigJPEG = new byte[]{-1, -40, -1};
    static final String[] exts = new String[]{"jpeg", "jpg"};
    static final String[] mimeTypes = new String[]{"image/jpeg", "image/jpg"};
    static final MagicNumberRegistryEntry.MagicNumber[] magicNumbers = new MagicNumberRegistryEntry.MagicNumber[]{new MagicNumberRegistryEntry.MagicNumber(0, sigJPEG)};

    public JPEGRegistryEntry() {
        super("JPEG", exts, mimeTypes, magicNumbers);
    }

    @Override
    public Filter handleStream(InputStream inputStream, ParsedURL parsedURL, boolean bl) {
        Object[] objectArray;
        String string;
        final DeferRable deferRable = new DeferRable();
        final InputStream inputStream2 = inputStream;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{"JPEG", parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{"JPEG"};
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                Filter filter;
                try {
                    BufferedImage bufferedImage;
                    block6: {
                        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream2);
                        try {
                            bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                        }
                        catch (TruncatedFileException truncatedFileException) {
                            bufferedImage = truncatedFileException.getBufferedImage();
                            if (bufferedImage != null) break block6;
                            throw new IOException("JPEG File was truncated");
                        }
                    }
                    deferRable.setBounds(new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                    CachableRed cachableRed = GraphicsUtil.wrap(bufferedImage);
                    cachableRed = new Any2sRGBRed(cachableRed);
                    cachableRed = new FormatRed(cachableRed, GraphicsUtil.sRGB_Unpre);
                    WritableRaster writableRaster = (WritableRaster)cachableRed.getData();
                    ColorModel colorModel = cachableRed.getColorModel();
                    bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                    cachableRed = GraphicsUtil.wrap(bufferedImage);
                    filter = new RedRable(cachableRed);
                }
                catch (IOException iOException) {
                    filter = ImageTagRegistry.getBrokenLinkImage(JPEGRegistryEntry.this, string, objectArray);
                }
                catch (ThreadDeath threadDeath) {
                    Filter filter2 = ImageTagRegistry.getBrokenLinkImage(JPEGRegistryEntry.this, string, objectArray);
                    deferRable.setSource(filter2);
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    filter = ImageTagRegistry.getBrokenLinkImage(JPEGRegistryEntry.this, string, objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }
}

