/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.model.impl;

import com.intellij.openapi.util.JDOMExternalizerUtil;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkProperties;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkType;
import org.jetbrains.jps.devkit.model.JpsPluginModuleProperties;
import org.jetbrains.jps.devkit.model.JpsPluginModuleType;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;

public class JpsDevKitModelSerializerExtension
extends JpsModelSerializerExtension {
    @NotNull
    public List<? extends JpsModulePropertiesSerializer<?>> getModulePropertiesSerializers() {
        List<JpsPluginModulePropertiesSerializer> list = Arrays.asList(new JpsPluginModulePropertiesSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension", "getModulePropertiesSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        List<JpsIdeaSdkPropertiesSerializer> list = Arrays.asList(new JpsIdeaSdkPropertiesSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension", "getSdkPropertiesSerializers"));
        }
        return list;
    }

    private static class JpsPluginModulePropertiesSerializer
    extends JpsModulePropertiesSerializer<JpsSimpleElement<JpsPluginModuleProperties>> {
        private static final String URL_ATTRIBUTE = "url";
        private static final String MANIFEST_ATTRIBUTE = "manifest";

        private JpsPluginModulePropertiesSerializer() {
            super((JpsModuleType)JpsPluginModuleType.INSTANCE, "PLUGIN_MODULE", "DevKit.ModuleBuildProperties");
        }

        public JpsSimpleElement<JpsPluginModuleProperties> loadProperties(@Nullable Element componentElement) {
            String pluginXmlUrl = componentElement != null ? componentElement.getAttributeValue(URL_ATTRIBUTE) : null;
            String manifestFileUrl = componentElement != null ? componentElement.getAttributeValue(MANIFEST_ATTRIBUTE) : null;
            return JpsElementFactory.getInstance().createSimpleElement((Object)new JpsPluginModuleProperties(pluginXmlUrl, manifestFileUrl));
        }

        public void saveProperties(@NotNull JpsSimpleElement<JpsPluginModuleProperties> element, @NotNull Element componentElement) {
            String manifestFileUrl;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsPluginModulePropertiesSerializer", "saveProperties"));
            }
            if (componentElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentElement", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsPluginModulePropertiesSerializer", "saveProperties"));
            }
            String pluginXmlUrl = ((JpsPluginModuleProperties)element.getData()).getPluginXmlUrl();
            if (pluginXmlUrl != null) {
                componentElement.setAttribute(URL_ATTRIBUTE, pluginXmlUrl);
            }
            if ((manifestFileUrl = ((JpsPluginModuleProperties)element.getData()).getManifestFileUrl()) != null) {
                componentElement.setAttribute(MANIFEST_ATTRIBUTE, manifestFileUrl);
            }
        }
    }

    private static class JpsIdeaSdkPropertiesSerializer
    extends JpsSdkPropertiesSerializer<JpsSimpleElement<JpsIdeaSdkProperties>> {
        private static final String SANDBOX_HOME_FIELD = "mySandboxHome";
        private static final String JDK_NAME_ATTRIBUTE = "sdk";

        public JpsIdeaSdkPropertiesSerializer() {
            super("IDEA JDK", (JpsSdkType)JpsIdeaSdkType.INSTANCE);
        }

        @NotNull
        public JpsSimpleElement<JpsIdeaSdkProperties> loadProperties(@Nullable Element propertiesElement) {
            String sandboxHome = null;
            String jdkName = null;
            if (propertiesElement != null) {
                sandboxHome = JDOMExternalizerUtil.readField((Element)propertiesElement, (String)SANDBOX_HOME_FIELD);
                jdkName = propertiesElement.getAttributeValue(JDK_NAME_ATTRIBUTE);
            }
            JpsSimpleElement jpsSimpleElement = JpsElementFactory.getInstance().createSimpleElement((Object)new JpsIdeaSdkProperties(sandboxHome, jdkName));
            if (jpsSimpleElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsIdeaSdkPropertiesSerializer", "loadProperties"));
            }
            return jpsSimpleElement;
        }

        public void saveProperties(@NotNull JpsSimpleElement<JpsIdeaSdkProperties> properties, @NotNull Element element) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsIdeaSdkPropertiesSerializer", "saveProperties"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsIdeaSdkPropertiesSerializer", "saveProperties"));
            }
            JDOMExternalizerUtil.writeField((Element)element, (String)SANDBOX_HOME_FIELD, (String)((JpsIdeaSdkProperties)properties.getData()).getSandboxHome());
            element.setAttribute(JDK_NAME_ATTRIBUTE, ((JpsIdeaSdkProperties)properties.getData()).getJdkName());
        }
    }
}

