/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.emulator.charset.CharacterSets;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.emulator.mouse.TerminalMouseListener;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalCoordinates;
import com.jediterm.terminal.ui.TerminalPanelListener;
import com.jediterm.terminal.ui.UIUtil;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.terminal.util.CharUtils;
import com.jediterm.terminal.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalPanel
extends JComponent
implements TerminalDisplay,
ClipboardOwner,
TerminalActionProvider {
    private static final Logger LOG = Logger.getLogger(TerminalPanel.class);
    private static final long serialVersionUID = -1048763516632093014L;
    public static final double SCROLL_SPEED = 0.05;
    private Font myNormalFont;
    private Font myItalicFont;
    private Font myBoldFont;
    private Font myBoldItalicFont;
    private int myDescent = 0;
    protected Dimension myCharSize = new Dimension();
    private boolean myMonospaced;
    protected Dimension myTermSize = new Dimension(80, 24);
    private TerminalStarter myTerminalStarter = null;
    private MouseMode myMouseMode = MouseMode.MOUSE_REPORTING_NONE;
    private Point mySelectionStartPoint = null;
    private TerminalSelection mySelection = null;
    private Clipboard myClipboard;
    private TerminalPanelListener myTerminalPanelListener;
    private SettingsProvider mySettingsProvider;
    private final TerminalTextBuffer myTerminalTextBuffer;
    private final StyleState myStyleState;
    private final TerminalCursor myCursor = new TerminalCursor();
    private final BoundedRangeModel myBoundedRangeModel = new DefaultBoundedRangeModel(0, 80, 0, 80);
    private boolean myScrollingEnabled = true;
    protected int myClientScrollOrigin;
    protected KeyListener myKeyListener;
    private String myWindowTitle = "Terminal";
    private TerminalActionProvider myNextActionProvider;
    private String myInputMethodUncommitedChars;
    private Timer myRepaintTimer;
    private AtomicBoolean needScrollUpdate = new AtomicBoolean(true);
    private AtomicBoolean needRepaint = new AtomicBoolean(true);
    private int myMaxFPS = 50;
    private int myBlinkingPeriod = 500;
    private TerminalCoordinates myCoordsAccessor;
    private String myCurrentPath;
    private SubstringFinder.FindResult myFindResult;

    public TerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull TerminalTextBuffer terminalTextBuffer, @NotNull StyleState styleState) {
        this.mySettingsProvider = settingsProvider;
        this.myTerminalTextBuffer = terminalTextBuffer;
        this.myStyleState = styleState;
        this.myTermSize.width = terminalTextBuffer.getWidth();
        this.myTermSize.height = terminalTextBuffer.getHeight();
        this.myMaxFPS = this.mySettingsProvider.maxRefreshRate();
        this.updateScrolling();
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        terminalTextBuffer.addModelListener(new TerminalModelListener(){

            public void modelChanged() {
                TerminalPanel.this.repaint();
            }
        });
    }

    @Override
    public void repaint() {
        this.needRepaint.set(true);
    }

    private void doRepaint() {
        super.repaint();
    }

    @Deprecated
    protected void reinitFontAndResize() {
        this.initFont();
        this.sizeTerminalFromComponent();
    }

    protected void initFont() {
        this.myNormalFont = this.createFont();
        this.myBoldFont = this.myNormalFont.deriveFont(1);
        this.myItalicFont = this.myNormalFont.deriveFont(2);
        this.myBoldItalicFont = this.myBoldFont.deriveFont(2);
        this.establishFontMetrics();
    }

    public void init() {
        this.initFont();
        this.setUpClipboard();
        this.setPreferredSize(new Dimension(this.getPixelWidth(), this.getPixelHeight()));
        this.setFocusable(true);
        this.enableInputMethods(true);
        this.setDoubleBuffered(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (!TerminalPanel.this.isLocalMouseAction(e)) {
                    return;
                }
                Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                if (TerminalPanel.this.mySelection == null) {
                    if (TerminalPanel.this.mySelectionStartPoint == null) {
                        TerminalPanel.this.mySelectionStartPoint = charCoords;
                    }
                    TerminalPanel.this.mySelection = new TerminalSelection(new Point(TerminalPanel.this.mySelectionStartPoint));
                }
                TerminalPanel.this.repaint();
                TerminalPanel.this.mySelection.updateEnd(charCoords);
                if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                    TerminalPanel.this.handleCopy(false);
                }
                if (e.getPoint().y < 0) {
                    TerminalPanel.this.moveScrollBar((int)((double)e.getPoint().y * 0.05));
                }
                if (e.getPoint().y > TerminalPanel.this.getPixelHeight()) {
                    TerminalPanel.this.moveScrollBar((int)((double)(e.getPoint().y - TerminalPanel.this.getPixelHeight()) * 0.05));
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (TerminalPanel.this.isLocalMouseAction(e)) {
                    int notches = e.getWheelRotation();
                    TerminalPanel.this.moveScrollBar(notches);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1) {
                    TerminalPanel.this.mySelectionStartPoint = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    TerminalPanel.this.mySelection = null;
                    TerminalPanel.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                TerminalPanel.this.requestFocusInWindow();
                TerminalPanel.this.repaint();
            }

            public void mouseClicked(MouseEvent e) {
                TerminalPanel.this.requestFocusInWindow();
                if (e.getButton() == 1 && TerminalPanel.this.isLocalMouseAction(e)) {
                    int count = e.getClickCount();
                    if (count != 1) {
                        if (count == 2) {
                            Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                            Point start = SelectionUtil.getPreviousSeparator(charCoords, TerminalPanel.this.myTerminalTextBuffer);
                            Point stop = SelectionUtil.getNextSeparator(charCoords, TerminalPanel.this.myTerminalTextBuffer);
                            TerminalPanel.this.mySelection = new TerminalSelection(start);
                            TerminalPanel.this.mySelection.updateEnd(stop);
                            if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                                TerminalPanel.this.handleCopy(false);
                            }
                        } else if (count == 3) {
                            int endLine;
                            int startLine;
                            Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                            for (startLine = charCoords.y; startLine > -TerminalPanel.this.getScrollBuffer().getLineCount() && TerminalPanel.this.myTerminalTextBuffer.getLine(startLine - 1).isWrapped(); --startLine) {
                            }
                            for (endLine = charCoords.y; endLine < TerminalPanel.this.myTerminalTextBuffer.getHeight() && TerminalPanel.this.myTerminalTextBuffer.getLine(endLine).isWrapped(); ++endLine) {
                            }
                            TerminalPanel.this.mySelection = new TerminalSelection(new Point(0, startLine));
                            TerminalPanel.this.mySelection.updateEnd(new Point(TerminalPanel.this.myTermSize.width, endLine));
                            if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                                TerminalPanel.this.handleCopy(false);
                            }
                        }
                    }
                } else if (e.getButton() == 2 && TerminalPanel.this.mySettingsProvider.pasteOnMiddleMouseClick() && TerminalPanel.this.isLocalMouseAction(e)) {
                    TerminalPanel.this.handlePaste();
                } else if (e.getButton() == 3) {
                    JPopupMenu popup = TerminalPanel.this.createPopupMenu();
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
                TerminalPanel.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                TerminalPanel.this.sizeTerminalFromComponent();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TerminalPanel.this.myCursor.cursorChanged();
            }

            public void focusLost(FocusEvent e) {
                TerminalPanel.this.myCursor.cursorChanged();
            }
        });
        this.myBoundedRangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TerminalPanel.this.myClientScrollOrigin = TerminalPanel.this.myBoundedRangeModel.getValue();
                TerminalPanel.this.repaint();
            }
        });
        this.createRepaintTimer();
    }

    private void createRepaintTimer() {
        if (this.myRepaintTimer != null) {
            this.myRepaintTimer.stop();
        }
        this.myRepaintTimer = new Timer(1000 / this.myMaxFPS, new WeakRedrawTimer(this));
        this.myRepaintTimer.start();
    }

    public boolean isLocalMouseAction(MouseEvent e) {
        return this.mySettingsProvider.forceActionOnMouseReporting() || this.isMouseReporting() == e.isShiftDown();
    }

    public boolean isRemoteMouseAction(MouseEvent e) {
        return this.isMouseReporting() && !e.isShiftDown();
    }

    protected boolean isRetina() {
        return UIUtil.isRetina();
    }

    public void setBlinkingPeriod(int blinkingPeriod) {
        this.myBlinkingPeriod = blinkingPeriod;
    }

    public void setCoordAccessor(TerminalCoordinates coordAccessor) {
        this.myCoordsAccessor = coordAccessor;
    }

    public void setFindResult(SubstringFinder.FindResult findResult) {
        this.myFindResult = findResult;
        this.repaint();
    }

    public SubstringFinder.FindResult getFindResult() {
        return this.myFindResult;
    }

    public SubstringFinder.FindResult.FindItem selectPrevFindResultItem() {
        return this.selectPrevOrNextFindResultItem(false);
    }

    public SubstringFinder.FindResult.FindItem selectNextFindResultItem() {
        return this.selectPrevOrNextFindResultItem(true);
    }

    protected SubstringFinder.FindResult.FindItem selectPrevOrNextFindResultItem(boolean next) {
        if (this.myFindResult != null) {
            SubstringFinder.FindResult.FindItem item;
            SubstringFinder.FindResult.FindItem findItem = item = next ? this.myFindResult.nextFindItem() : this.myFindResult.prevFindItem();
            if (item != null) {
                this.mySelection = new TerminalSelection(new Point(item.getStart().x, item.getStart().y - this.myTerminalTextBuffer.getHistoryLinesCount()), new Point(item.getEnd().x, item.getEnd().y - this.myTerminalTextBuffer.getHistoryLinesCount()));
                if (this.mySelection.getStart().y < this.getTerminalTextBuffer().getHeight() / 2) {
                    this.myBoundedRangeModel.setValue(this.mySelection.getStart().y - this.getTerminalTextBuffer().getHeight() / 2);
                } else {
                    this.myBoundedRangeModel.setValue(0);
                }
                this.repaint();
                return item;
            }
        }
        return null;
    }

    @Override
    public void terminalMouseModeSet(MouseMode mode) {
        this.myMouseMode = mode;
    }

    private boolean isMouseReporting() {
        return this.myMouseMode != MouseMode.MOUSE_REPORTING_NONE;
    }

    private void scrollToBottom() {
        this.myBoundedRangeModel.setValue(this.myTermSize.height);
    }

    private void moveScrollBar(int k) {
        this.myBoundedRangeModel.setValue(this.myBoundedRangeModel.getValue() + k);
    }

    protected Font createFont() {
        return this.mySettingsProvider.getTerminalFont();
    }

    protected Point panelToCharCoords(Point p) {
        int x = Math.min(p.x / this.myCharSize.width, this.getColumnCount() - 1);
        x = Math.max(0, x);
        int y = Math.min(p.y / this.myCharSize.height, this.getRowCount() - 1) + this.myClientScrollOrigin;
        return new Point(x, y);
    }

    protected Point charToPanelCoords(Point p) {
        return new Point(p.x * this.myCharSize.width, (p.y - this.myClientScrollOrigin) * this.myCharSize.height);
    }

    void setUpClipboard() {
        this.myClipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (this.myClipboard == null) {
            this.myClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    protected void copySelection(Point selectionStart, Point selectionEnd) {
        if (selectionStart == null || selectionEnd == null) {
            return;
        }
        String selectionText = SelectionUtil.getSelectionText(selectionStart, selectionEnd, this.myTerminalTextBuffer);
        if (selectionText.length() != 0) {
            try {
                this.setCopyContents(new StringSelection(selectionText));
            }
            catch (IllegalStateException e) {
                LOG.error((Object)"Could not set clipboard:", (Throwable)e);
            }
        }
    }

    protected void setCopyContents(StringSelection selection) {
        this.myClipboard.setContents(selection, this);
    }

    protected void pasteSelection() {
        String selection = this.getClipboardString();
        if (selection == null) {
            return;
        }
        try {
            if (!UIUtil.isWindows) {
                selection = selection.replace("\r\n", "\n");
            }
            selection = selection.replace('\n', '\r');
            this.myTerminalStarter.sendString(selection);
        }
        catch (RuntimeException e) {
            LOG.info((Object)e);
        }
    }

    private String getClipboardString() {
        try {
            return this.getClipboardContent();
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return null;
        }
    }

    protected String getClipboardContent() throws IOException, UnsupportedFlavorException {
        try {
            return (String)this.myClipboard.getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return null;
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected void drawImage(Graphics2D gfx, BufferedImage image, int x, int y, ImageObserver observer) {
        gfx.drawImage(image, x, y, image.getWidth(), image.getHeight(), observer);
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    private void sizeTerminalFromComponent() {
        if (this.myTerminalStarter != null) {
            int newWidth = this.getWidth() / this.myCharSize.width;
            int newHeight = this.getHeight() / this.myCharSize.height;
            if (newHeight > 0 && newWidth > 0) {
                Dimension newSize = new Dimension(newWidth, newHeight);
                this.myTerminalStarter.postResize(newSize, RequestOrigin.User);
            }
        }
    }

    public void setTerminalStarter(TerminalStarter terminalStarter) {
        this.myTerminalStarter = terminalStarter;
        this.sizeTerminalFromComponent();
    }

    public void setKeyListener(KeyListener keyListener) {
        this.myKeyListener = keyListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension requestResize(Dimension newSize, RequestOrigin origin, int cursorY, JediTerminal.ResizeHandler resizeHandler) {
        if (!newSize.equals(this.myTermSize)) {
            this.myTerminalTextBuffer.lock();
            try {
                this.myTerminalTextBuffer.resize(newSize, origin, cursorY, resizeHandler, this.mySelection);
                this.myTermSize = (Dimension)newSize.clone();
                Dimension pixelDimension = new Dimension(this.getPixelWidth(), this.getPixelHeight());
                this.setPreferredSize(pixelDimension);
                if (this.myTerminalPanelListener != null) {
                    this.myTerminalPanelListener.onPanelResize(pixelDimension, origin);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TerminalPanel.this.updateScrolling();
                    }
                });
            }
            finally {
                this.myTerminalTextBuffer.unlock();
            }
        }
        return new Dimension(this.getPixelWidth(), this.getPixelHeight());
    }

    public void setTerminalPanelListener(TerminalPanelListener resizeDelegate) {
        this.myTerminalPanelListener = resizeDelegate;
    }

    private void establishFontMetrics() {
        BufferedImage img = this.createBufferedImage(1, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setFont(this.myNormalFont);
        float lineSpace = this.mySettingsProvider.getLineSpace();
        FontMetrics fo = graphics.getFontMetrics();
        this.myDescent = fo.getDescent();
        this.myCharSize.width = fo.charWidth('W');
        this.myCharSize.height = fo.getHeight() + (int)(lineSpace * 2.0f);
        this.myDescent = (int)((float)this.myDescent + lineSpace);
        this.myMonospaced = TerminalPanel.isMonospaced(fo);
        if (!this.myMonospaced) {
            LOG.info((Object)("WARNING: Font " + this.myNormalFont.getName() + " is non-monospaced"));
        }
        img.flush();
        graphics.dispose();
    }

    private static boolean isMonospaced(FontMetrics fontMetrics) {
        boolean isMonospaced = true;
        int charWidth = -1;
        for (int codePoint = 0; codePoint < 128; ++codePoint) {
            char character;
            if (!Character.isValidCodePoint(codePoint) || !TerminalPanel.isWordCharacter(character = (char)codePoint)) continue;
            int w = fontMetrics.charWidth(character);
            if (charWidth != -1) {
                if (w == charWidth) continue;
                isMonospaced = false;
                break;
            }
            charWidth = w;
        }
        return isMonospaced;
    }

    private static boolean isWordCharacter(char character) {
        return Character.isLetterOrDigit(character);
    }

    protected void setupAntialiasing(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D myGfx = (Graphics2D)graphics;
            Object mode = this.mySettingsProvider.useAntialiasing() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, mode);
            myGfx.setRenderingHints(hints);
        }
    }

    @Override
    public Color getBackground() {
        return this.getPalette().getColor(this.myStyleState.getBackground());
    }

    @Override
    public Color getForeground() {
        return this.getPalette().getColor(this.myStyleState.getForeground());
    }

    @Override
    public void paintComponent(Graphics g) {
        final Graphics2D gfx = (Graphics2D)g;
        this.setupAntialiasing(gfx);
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.myTerminalTextBuffer.processHistoryAndScreenLines(this.myClientScrollOrigin, this.myTermSize.height, new StyledTextConsumer(){
            final int columnCount;
            {
                this.columnCount = TerminalPanel.this.getColumnCount();
            }

            public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                Pair<Integer, Integer> interval;
                List<Pair<Integer, Integer>> ranges;
                int row = y - startRow;
                TerminalPanel.this.drawCharacters(x, row, style, characters, gfx);
                if (TerminalPanel.this.myFindResult != null && (ranges = TerminalPanel.this.myFindResult.getRanges(characters)) != null) {
                    for (Pair<Integer, Integer> range : ranges) {
                        TextStyle foundPatternStyle = TerminalPanel.this.getFoundPattern(style);
                        CharBuffer foundPatternChars = characters.subBuffer(range);
                        TerminalPanel.this.drawCharacters(x + (Integer)range.first, row, foundPatternStyle, foundPatternChars, gfx);
                    }
                }
                if (TerminalPanel.this.mySelection != null && (interval = TerminalPanel.this.mySelection.intersect(x, row + TerminalPanel.this.myClientScrollOrigin, characters.length())) != null) {
                    TextStyle selectionStyle = TerminalPanel.this.getSelectionStyle(style);
                    CharBuffer selectionChars = characters.subBuffer((Integer)interval.first - x, (Integer)interval.second);
                    TerminalPanel.this.drawCharacters((Integer)interval.first, row, selectionStyle, selectionChars, gfx);
                }
            }

            public void consumeNul(int x, int y, int nulIndex, TextStyle style, CharBuffer characters, int startRow) {
                Pair<Integer, Integer> interval;
                int row = y - startRow;
                if (TerminalPanel.this.mySelection != null && (interval = TerminalPanel.this.mySelection.intersect(nulIndex, row + TerminalPanel.this.myClientScrollOrigin, this.columnCount - nulIndex)) != null) {
                    TextStyle selectionStyle = TerminalPanel.this.getSelectionStyle(style);
                    TerminalPanel.this.drawCharacters(x, row, selectionStyle, characters, gfx);
                    return;
                }
                TerminalPanel.this.drawCharacters(x, row, style, characters, gfx);
            }

            public void consumeQueue(int x, int y, int nulIndex, int startRow) {
                if (x < this.columnCount) {
                    this.consumeNul(x, y, nulIndex, TextStyle.EMPTY, new CharBuffer(' ', this.columnCount - x), startRow);
                }
            }
        });
        int cursorY = this.myCursor.getCoordY();
        if (this.myClientScrollOrigin + this.getRowCount() > cursorY) {
            int cursorX = this.myCursor.getCoordX();
            Pair<Character, TextStyle> sc = this.myTerminalTextBuffer.getStyledCharAt(cursorX, cursorY);
            TextStyle normalStyle = sc.second != null ? (TextStyle)sc.second : this.myStyleState.getCurrent();
            TextStyle selectionStyle = this.getSelectionStyle(normalStyle);
            boolean inSelection = this.inSelection(cursorX, cursorY);
            this.myCursor.drawCursor(((Character)sc.first).charValue(), gfx, inSelection ? selectionStyle : normalStyle);
        }
        this.drawInputMethodUncommitedChars(gfx);
        this.drawMargins(gfx, this.getWidth(), this.getHeight());
    }

    private TextStyle getSelectionStyle(TextStyle style) {
        TextStyle selectionStyle = style.clone();
        if (this.mySettingsProvider.useInverseSelectionColor()) {
            selectionStyle = this.getInversedStyle(style);
        } else {
            TextStyle mySelectionStyle = this.mySettingsProvider.getSelectionColor();
            selectionStyle.setBackground(mySelectionStyle.getBackground());
            selectionStyle.setForeground(mySelectionStyle.getForeground());
        }
        return selectionStyle;
    }

    private TextStyle getFoundPattern(TextStyle style) {
        TextStyle foundPatternStyle = style.clone();
        TextStyle myFoundPattern = this.mySettingsProvider.getFoundPatternColor();
        foundPatternStyle.setBackground(myFoundPattern.getBackground());
        foundPatternStyle.setForeground(myFoundPattern.getForeground());
        return foundPatternStyle;
    }

    private void drawInputMethodUncommitedChars(Graphics2D gfx) {
        if (this.myInputMethodUncommitedChars != null && this.myInputMethodUncommitedChars.length() > 0) {
            int x = this.myCursor.getCoordX() * this.myCharSize.width;
            int y = this.myCursor.getCoordY() * this.myCharSize.height - 2;
            int len = this.myInputMethodUncommitedChars.length() * this.myCharSize.width;
            gfx.setColor(this.getBackground());
            gfx.fillRect(x, (this.myCursor.getCoordY() - 1) * this.myCharSize.height, len, this.myCharSize.height);
            gfx.setColor(this.getForeground());
            gfx.setFont(this.myNormalFont);
            gfx.drawString(this.myInputMethodUncommitedChars, x, y);
            Stroke saved = gfx.getStroke();
            BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
            gfx.setStroke(dotted);
            gfx.drawLine(x, y, x + len, y);
            gfx.setStroke(saved);
        }
    }

    private boolean inSelection(int x, int y) {
        return this.mySelection != null && this.mySelection.contains(new Point(x, y));
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        this.handleKeyEvent(e);
        e.consume();
    }

    public void handleKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            this.myKeyListener.keyPressed(e);
        } else if (id != 402 && id == 400) {
            this.myKeyListener.keyTyped(e);
        }
    }

    public int getPixelWidth() {
        return this.myCharSize.width * this.myTermSize.width;
    }

    public int getPixelHeight() {
        return this.myCharSize.height * this.myTermSize.height;
    }

    @Override
    public int getColumnCount() {
        return this.myTermSize.width;
    }

    @Override
    public int getRowCount() {
        return this.myTermSize.height;
    }

    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    public void addTerminalMouseListener(final TerminalMouseListener listener) {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mousePressed(p.x, p.y, e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseReleased(p.x, p.y, e);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    TerminalPanel.this.mySelection = null;
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseWheelMoved(p.x, p.y, e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseMoved(p.x, p.y, e);
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseDragged(p.x, p.y, e);
                }
            }
        });
    }

    public void initKeyHandler() {
        this.setKeyListener(new TerminalKeyHandler());
    }

    private int getBlinkingPeriod() {
        if (this.myBlinkingPeriod != this.mySettingsProvider.caretBlinkingMs()) {
            this.setBlinkingPeriod(this.mySettingsProvider.caretBlinkingMs());
        }
        return this.myBlinkingPeriod;
    }

    protected void drawImage(Graphics2D g, BufferedImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    private TextStyle getInversedStyle(TextStyle style) {
        TextStyle selectionStyle;
        selectionStyle.setOption(TextStyle.Option.INVERSE, !(selectionStyle = style.clone()).hasOption(TextStyle.Option.INVERSE));
        if (selectionStyle.getForeground() == null) {
            selectionStyle.setForeground(this.myStyleState.getForeground());
        }
        if (selectionStyle.getBackground() == null) {
            selectionStyle.setBackground(this.myStyleState.getBackground());
        }
        return selectionStyle;
    }

    private void drawCharacters(int x, int y, TextStyle style, CharBuffer buf, Graphics2D gfx) {
        int xCoord = x * this.myCharSize.width;
        int yCoord = y * this.myCharSize.height;
        if (xCoord < 0 || xCoord > this.getWidth() || yCoord < 0 || yCoord > this.getHeight()) {
            return;
        }
        gfx.setColor(this.getPalette().getColor(this.myStyleState.getBackground(style.getBackgroundForRun())));
        int textLength = CharUtils.getTextLengthDoubleWidthAware(buf.getBuf(), buf.getStart(), buf.length(), this.mySettingsProvider.ambiguousCharsAreDoubleWidth());
        gfx.fillRect(xCoord, yCoord, Math.min(textLength * this.myCharSize.width, this.getWidth() - xCoord), Math.min(this.myCharSize.height, this.getHeight() - yCoord));
        if (buf.isNul()) {
            return;
        }
        this.drawChars(x, y, buf, style, gfx);
        gfx.setColor(this.getPalette().getColor(this.myStyleState.getForeground(style.getForegroundForRun())));
        int baseLine = (y + 1) * this.myCharSize.height - this.myDescent;
        if (style.hasOption(TextStyle.Option.UNDERLINED)) {
            gfx.drawLine(xCoord, baseLine + 1, (x + textLength) * this.myCharSize.width, baseLine + 1);
        }
    }

    private void drawChars(int x, int y, CharBuffer buf, TextStyle style, Graphics2D gfx) {
        boolean blockLen = true;
        int offset = 0;
        int drawCharsOffset = 0;
        CharBuffer renderingBuffer = this.mySettingsProvider.DECCompatibilityMode() && style.hasOption(TextStyle.Option.BOLD) ? CharUtils.heavyDecCompatibleBuffer(buf) : buf;
        while (offset + 1 <= buf.length()) {
            if (renderingBuffer.getBuf()[buf.getStart() + offset] == '\ue000') {
                ++offset;
                ++drawCharsOffset;
                continue;
            }
            Font font = this.getFontToDisplay(buf.charAt(offset + 1 - 1), style);
            gfx.setFont(font);
            int descent = gfx.getFontMetrics(font).getDescent();
            int baseLine = (y + 1) * this.myCharSize.height - descent;
            int xCoord = (x + drawCharsOffset) * this.myCharSize.width;
            int textLength = CharUtils.getTextLengthDoubleWidthAware(buf.getBuf(), buf.getStart() + offset, 1, this.mySettingsProvider.ambiguousCharsAreDoubleWidth());
            int yCoord = y * this.myCharSize.height;
            gfx.setClip(xCoord, yCoord, Math.min(textLength * this.myCharSize.width, this.getWidth() - xCoord), Math.min(this.myCharSize.height, this.getHeight() - yCoord));
            gfx.setColor(this.getPalette().getColor(this.myStyleState.getForeground(style.getForegroundForRun())));
            gfx.drawChars(renderingBuffer.getBuf(), buf.getStart() + offset, 1, xCoord, baseLine);
            ++drawCharsOffset;
            ++offset;
        }
        gfx.setClip(null);
    }

    protected Font getFontToDisplay(char c, TextStyle style) {
        boolean bold = style.hasOption(TextStyle.Option.BOLD);
        boolean italic = style.hasOption(TextStyle.Option.ITALIC);
        if (bold && this.mySettingsProvider.DECCompatibilityMode() && CharacterSets.isDecBoxChar(c)) {
            return this.myNormalFont;
        }
        return bold ? (italic ? this.myBoldItalicFont : this.myBoldFont) : (italic ? this.myItalicFont : this.myNormalFont);
    }

    private ColorPalette getPalette() {
        return this.mySettingsProvider.getTerminalColorPalette();
    }

    private void drawMargins(Graphics2D gfx, int width, int height) {
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, height, this.getWidth(), this.getHeight() - height);
        gfx.fillRect(width, 0, this.getWidth() - width, this.getHeight());
    }

    @Override
    public void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
        if (dy < 0) {
            this.needScrollUpdate.set(true);
        }
        this.mySelection = null;
    }

    private void updateScrolling() {
        if (this.myScrollingEnabled) {
            this.myBoundedRangeModel.setRangeProperties(0, this.myTermSize.height, -this.myTerminalTextBuffer.getHistoryBuffer().getLineCount(), this.myTermSize.height, false);
        } else {
            this.myBoundedRangeModel.setRangeProperties(0, this.myTermSize.height, 0, this.myTermSize.height, false);
        }
    }

    @Override
    public void setCursor(int x, int y) {
        this.myCursor.setX(x);
        this.myCursor.setY(y);
    }

    @Override
    public void beep() {
        if (this.mySettingsProvider.audibleBell()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.myBoundedRangeModel;
    }

    public TerminalTextBuffer getTerminalTextBuffer() {
        return this.myTerminalTextBuffer;
    }

    @Override
    public TerminalSelection getSelection() {
        return this.mySelection;
    }

    @Override
    public boolean ambiguousCharsAreDoubleWidth() {
        return this.mySettingsProvider.ambiguousCharsAreDoubleWidth();
    }

    public LinesBuffer getScrollBuffer() {
        return this.myTerminalTextBuffer.getHistoryBuffer();
    }

    @Override
    public void setCursorVisible(boolean shouldDrawCursor) {
        this.myCursor.setShouldDrawCursor(shouldDrawCursor);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        TerminalAction.addToMenu(popup, this);
        return popup;
    }

    @Override
    public void setScrollingEnabled(boolean scrollingEnabled) {
        this.myScrollingEnabled = scrollingEnabled;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TerminalPanel.this.updateScrolling();
            }
        });
    }

    @Override
    public void setBlinkingCursor(boolean enabled) {
        this.myCursor.setBlinking(enabled);
    }

    public TerminalCursor getTerminalCursor() {
        return this.myCursor;
    }

    public TerminalOutputStream getTerminalOutputStream() {
        return this.myTerminalStarter;
    }

    @Override
    public void setWindowTitle(String name) {
        this.myWindowTitle = name;
        if (this.myTerminalPanelListener != null) {
            this.myTerminalPanelListener.onTitleChanged(this.myWindowTitle);
        }
    }

    @Override
    public void setCurrentPath(String path) {
        this.myCurrentPath = path;
    }

    @Override
    public List<TerminalAction> getActions() {
        return Lists.newArrayList((Object[])new TerminalAction[]{new TerminalAction("Copy", this.mySettingsProvider.getCopyKeyStrokes(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                return TerminalPanel.this.handleCopy(true);
            }
        }).withMnemonicKey(67).withEnabledSupplier(new Supplier<Boolean>(){

            public Boolean get() {
                return TerminalPanel.this.mySelection != null;
            }
        }), new TerminalAction("Paste", this.mySettingsProvider.getPasteKeyStrokes(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                TerminalPanel.this.handlePaste();
                return true;
            }
        }).withMnemonicKey(80).withEnabledSupplier(new Supplier<Boolean>(){

            public Boolean get() {
                return TerminalPanel.this.getClipboardString() != null;
            }
        }), new TerminalAction("Clear Buffer", this.mySettingsProvider.getClearBufferKeyStrokes(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                TerminalPanel.this.clearBuffer();
                return true;
            }
        }).withMnemonicKey(75).withEnabledSupplier(new Supplier<Boolean>(){

            public Boolean get() {
                return !TerminalPanel.this.myTerminalTextBuffer.isUsingAlternateBuffer();
            }
        }).separatorBefore(true)});
    }

    private void clearBuffer() {
        if (!this.myTerminalTextBuffer.isUsingAlternateBuffer()) {
            this.myTerminalTextBuffer.clearHistory();
            if (this.myCoordsAccessor != null && this.myCoordsAccessor.getY() > 0) {
                TerminalLine line = this.myTerminalTextBuffer.getLine(this.myCoordsAccessor.getY() - 1);
                this.myTerminalTextBuffer.clearAll();
                this.myCoordsAccessor.setY(0);
                this.myCursor.setY(1);
                this.myTerminalTextBuffer.addLine(line);
            }
            this.updateScrolling();
            this.myClientScrollOrigin = this.myBoundedRangeModel.getValue();
        }
    }

    @Override
    public TerminalActionProvider getNextProvider() {
        return this.myNextActionProvider;
    }

    @Override
    public void setNextProvider(TerminalActionProvider provider) {
        this.myNextActionProvider = provider;
    }

    private void processTerminalKeyPressed(KeyEvent e) {
        try {
            int keycode = e.getKeyCode();
            char keychar = e.getKeyChar();
            if (keycode == 127 && keychar == '.') {
                this.myTerminalStarter.sendBytes(new byte[]{46});
                return;
            }
            if (keychar == ' ' && (e.getModifiers() & 2) != 0) {
                this.myTerminalStarter.sendBytes(new byte[]{0});
                return;
            }
            byte[] code = this.myTerminalStarter.getCode(keycode, e.getModifiers());
            if (code != null) {
                this.myTerminalStarter.sendBytes(code);
                if (this.mySettingsProvider.scrollToBottomOnTyping() && TerminalPanel.isCodeThatScrolls(keycode)) {
                    this.scrollToBottom();
                }
            } else if ((keychar & 0xFF00) == 0) {
                byte[] obuffer = this.mySettingsProvider.altSendsEscape() && (e.getModifiers() & 8) != 0 ? new byte[]{27, (byte)keychar} : new byte[]{(byte)keychar};
                this.myTerminalStarter.sendBytes(obuffer);
                if (this.mySettingsProvider.scrollToBottomOnTyping()) {
                    this.scrollToBottom();
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error sending key to emulator", (Throwable)ex);
        }
    }

    private static boolean isCodeThatScrolls(int keycode) {
        return keycode == 38 || keycode == 40 || keycode == 37 || keycode == 39 || keycode == 8 || keycode == 127;
    }

    private void processTerminalKeyTyped(KeyEvent e) {
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) != 0) {
            char[] foo = this.mySettingsProvider.altSendsEscape() && (e.getModifiers() & 8) != 0 ? new char[]{'\u001b', keychar} : new char[]{keychar};
            try {
                this.myTerminalStarter.sendString(new String(foo));
                if (this.mySettingsProvider.scrollToBottomOnTyping()) {
                    this.scrollToBottom();
                }
            }
            catch (RuntimeException ex) {
                LOG.error((Object)"Error sending key to emulator", (Throwable)ex);
            }
        }
    }

    private void handlePaste() {
        this.pasteSelection();
    }

    private boolean handleCopy(boolean unselect) {
        if (this.mySelection != null) {
            Pair<Point, Point> points = this.mySelection.pointsForRun(this.myTermSize.width);
            this.copySelection((Point)points.first, (Point)points.second);
            if (unselect) {
                this.mySelection = null;
                this.repaint();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        int commitCount = e.getCommittedCharacterCount();
        if (commitCount > 0) {
            this.myInputMethodUncommitedChars = null;
            AttributedCharacterIterator text = e.getText();
            if (text != null) {
                StringBuilder sb = new StringBuilder();
                char c = text.first();
                while (commitCount > 0) {
                    if (c >= ' ' && c != '\u007f') {
                        sb.append(c);
                    }
                    c = text.next();
                    --commitCount;
                }
                this.myTerminalStarter.sendString(sb.toString());
            }
        } else {
            this.myInputMethodUncommitedChars = TerminalPanel.uncommitedChars(e.getText());
        }
    }

    private static String uncommitedChars(AttributedCharacterIterator text) {
        StringBuilder sb = new StringBuilder();
        char c = text.first();
        while (c != '\uffff') {
            if (c >= ' ' && c != '\u007f') {
                sb.append(c);
            }
            c = text.next();
        }
        return sb.toString();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return new MyInputMethodRequests();
    }

    private class MyInputMethodRequests
    implements InputMethodRequests {
        private MyInputMethodRequests() {
        }

        public Rectangle getTextLocation(TextHitInfo offset) {
            Rectangle r = new Rectangle(TerminalPanel.this.myCursor.getCoordX() * TerminalPanel.this.myCharSize.width, (TerminalPanel.this.myCursor.getCoordY() + 1) * TerminalPanel.this.myCharSize.height, 0, 0);
            Point p = TerminalPanel.this.getLocationOnScreen();
            r.translate(p.x, p.y);
            return r;
        }

        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            return null;
        }

        public int getInsertPositionOffset() {
            return 0;
        }

        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        public int getCommittedTextLength() {
            return 0;
        }

        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }
    }

    public class TerminalKeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            if (!TerminalAction.processEvent(TerminalPanel.this, e)) {
                TerminalPanel.this.processTerminalKeyPressed(e);
            }
        }

        public void keyTyped(KeyEvent e) {
            TerminalPanel.this.processTerminalKeyTyped(e);
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class TerminalCursor {
        private boolean myCursorIsShown;
        protected Point myCursorCoordinates = new Point();
        private boolean myShouldDrawCursor = true;
        private boolean myBlinking = true;
        private long myLastCursorChange;
        private boolean myCursorHasChanged;

        public void setX(int x) {
            this.myCursorCoordinates.x = x;
            this.cursorChanged();
        }

        public void setY(int y) {
            this.myCursorCoordinates.y = y;
            this.cursorChanged();
        }

        public int getCoordX() {
            return this.myCursorCoordinates.x;
        }

        public int getCoordY() {
            return this.myCursorCoordinates.y - 1 - TerminalPanel.this.myClientScrollOrigin;
        }

        public void setShouldDrawCursor(boolean shouldDrawCursor) {
            this.myShouldDrawCursor = shouldDrawCursor;
        }

        public void setBlinking(boolean blinking) {
            this.myBlinking = blinking;
        }

        public boolean isBlinking() {
            return this.myBlinking && TerminalPanel.this.getBlinkingPeriod() > 0;
        }

        public void cursorChanged() {
            this.myCursorHasChanged = true;
            this.myLastCursorChange = System.currentTimeMillis();
            TerminalPanel.this.repaint();
        }

        private boolean cursorShouldChangeBlinkState(long currentTime) {
            return currentTime - this.myLastCursorChange > (long)TerminalPanel.this.getBlinkingPeriod();
        }

        public void changeStateIfNeeded() {
            if (!TerminalPanel.this.isFocusOwner()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.cursorShouldChangeBlinkState(currentTime)) {
                this.myCursorIsShown = !this.myCursorIsShown;
                this.myLastCursorChange = currentTime;
                this.myCursorHasChanged = false;
                TerminalPanel.this.repaint();
            }
        }

        private TerminalCursorState computeBlinkingState() {
            if (!this.isBlinking() || this.myCursorHasChanged || this.myCursorIsShown) {
                return TerminalCursorState.SHOWING;
            }
            return TerminalCursorState.HIDDEN;
        }

        private TerminalCursorState computeCursorState() {
            if (!this.myShouldDrawCursor) {
                return TerminalCursorState.HIDDEN;
            }
            if (!TerminalPanel.this.isFocusOwner()) {
                return TerminalCursorState.NO_FOCUS;
            }
            return this.computeBlinkingState();
        }

        public void drawCursor(char c, Graphics2D gfx, TextStyle style) {
            TerminalCursorState state = this.computeCursorState();
            if (state == TerminalCursorState.HIDDEN) {
                return;
            }
            int x = this.getCoordX();
            int y = this.getCoordY();
            if (y >= 0 && y < TerminalPanel.this.myTermSize.height) {
                if (state == TerminalCursorState.SHOWING) {
                    TextStyle styleToDraw = TerminalPanel.this.getInversedStyle(style);
                    TerminalPanel.this.drawCharacters(x, y, styleToDraw, new CharBuffer(c, 1), gfx);
                } else if (state == TerminalCursorState.NO_FOCUS) {
                    int xCoord = x * TerminalPanel.this.myCharSize.width;
                    int yCoord = y * TerminalPanel.this.myCharSize.height;
                    gfx.setColor(TerminalPanel.this.getPalette().getColor(TerminalPanel.this.myStyleState.getForeground(style.getForegroundForRun())));
                    gfx.drawRect(xCoord, yCoord, TerminalPanel.this.myCharSize.width - 1, TerminalPanel.this.myCharSize.height - 1);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TerminalCursorState {
        SHOWING,
        HIDDEN,
        NO_FOCUS;

    }

    static class WeakRedrawTimer
    implements ActionListener {
        private WeakReference<TerminalPanel> ref;

        public WeakRedrawTimer(TerminalPanel terminalPanel) {
            this.ref = new WeakReference<TerminalPanel>(terminalPanel);
        }

        public void actionPerformed(ActionEvent e) {
            TerminalPanel terminalPanel = (TerminalPanel)this.ref.get();
            if (terminalPanel != null) {
                terminalPanel.myCursor.changeStateIfNeeded();
                if (terminalPanel.needScrollUpdate.getAndSet(false)) {
                    terminalPanel.updateScrolling();
                }
                if (terminalPanel.needRepaint.getAndSet(false)) {
                    try {
                        terminalPanel.doRepaint();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error while terminal panel redraw", (Throwable)ex);
                    }
                }
            } else {
                Timer timer = (Timer)e.getSource();
                timer.removeActionListener(this);
                timer.stop();
            }
        }
    }
}

