/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.npw.NewModuleWizard;
import com.google.common.collect.Maps;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImportModuleAction
extends AnAction
implements DumbAware {
    public AndroidImportModuleAction() {
        super("Import Module...");
    }

    public static void importGradleSubprojectAsModule(@Nullable VirtualFile importSource, @NotNull Project destinationProject) throws IOException {
        if (destinationProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationProject", "com/android/tools/idea/actions/AndroidImportModuleAction", "importGradleSubprojectAsModule"));
        }
        if (importSource != null && AndroidImportModuleAction.performImportWithoutUI(importSource, destinationProject)) {
            return;
        }
        NewModuleWizard wizard = NewModuleWizard.createImportModuleWizard(destinationProject, importSource);
        if (wizard.showAndGet()) {
            wizard.createModule(true);
        }
    }

    private static boolean performImportWithoutUI(VirtualFile importSource, Project destinationProject) throws IOException {
        for (ModuleImporter importer : ModuleImporter.getAllImporters(destinationProject)) {
            if (!importer.canImport(importSource)) continue;
            HashMap modules = Maps.newHashMap();
            for (ModuleToImport module : importer.findModules(importSource)) {
                modules.put(module.name, module.location);
            }
            importer.importProjects(modules);
            return true;
        }
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            try {
                AndroidImportModuleAction.importGradleSubprojectAsModule(null, project);
            }
            catch (IOException e1) {
                Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)e1);
            }
        }
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null);
    }
}

