/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepLinkCodeGeneratorAction
extends AnAction {
    private static final String IF_CONTENT_FORMAT = "\n<action %1$s:name=\"android.intent.action.VIEW\" />\n<category %1$s:name=\"android.intent.category.DEFAULT\" />\n<category %1$s:name=\"android.intent.category.BROWSABLE\" />\n<data \n%1$s:host=\"%2$s\"\n%1$s:pathPrefix=\"%3$s\"\n%1$s:scheme=\"http\"/>";
    private static final String IF_COMMENT_TEXT = "<!-- ATTENTION: This intent was auto-generated. Follow instructions at\n  https://g.co/AppIndexing/AndroidStudio to publish your URLs. -->";
    private static final String DATA_COMMENT_TEXT = "<!-- ATTENTION: This data URL was auto-generated. We recommend that you use the HTTP scheme.\n  TODO: Change the host or pathPrefix as necessary. -->";
    private static final String ACTIVITY_STRING = "activity";

    public void update(AnActionEvent e) {
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        e.getPresentation().setEnabled(DeepLinkCodeGeneratorAction.isDeepLinkAvailable(editor, file));
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        final PsiFile file = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (project != null && editor != null && file != null) {
            UsageTracker.getInstance().trackEvent("appIndexing", "deepLinkCreated", null, null);
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    DeepLinkCodeGeneratorAction.addDeepLinkAtCaret(project, editor, file);
                }
            });
        }
    }

    public static boolean isDeepLinkAvailable(@Nullable Editor editor, @Nullable PsiFile file) {
        return file != null && editor != null && DeepLinkCodeGeneratorAction.isAndroidManifestXmlFile(file) && DeepLinkCodeGeneratorAction.isInsideActivityTag(editor, file);
    }

    private static boolean isAndroidManifestXmlFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "isAndroidManifestXmlFile"));
        }
        return file.getName().equalsIgnoreCase("AndroidManifest.xml");
    }

    private static boolean isInsideActivityTag(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "isInsideActivityTag"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "isInsideActivityTag"));
        }
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement != null) {
            return DeepLinkCodeGeneratorAction.findXmlTagByName(psiElement, ACTIVITY_STRING) != null;
        }
        return false;
    }

    @Nullable
    private static XmlTag findXmlTagByName(PsiElement element, String tagName) {
        if (element == null) {
            return null;
        }
        while (element != null) {
            XmlTag tag;
            if (element instanceof XmlTag && (tag = (XmlTag)element).getName().equals(tagName)) {
                return tag;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    public static void addDeepLinkAtCaret(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "addDeepLinkAtCaret"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "addDeepLinkAtCaret"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "addDeepLinkAtCaret"));
        }
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement != null) {
            XmlTag activity = DeepLinkCodeGeneratorAction.findXmlTagByName(psiElement, ACTIVITY_STRING);
            XmlTag manifest = ((XmlFile)file).getRootTag();
            if (activity != null && manifest != null) {
                String prefix = manifest.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                String packageName = manifest.getAttributeValue("package");
                String host = packageName == null ? "" : DeepLinkCodeGeneratorAction.reversePackageName(packageName).toLowerCase(Locale.US);
                String activityName = activity.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                String pathPrefix = activityName == null ? "/" : "/" + DeepLinkCodeGeneratorAction.generatePathPrefix(activityName);
                String tagContent = String.format(IF_CONTENT_FORMAT, prefix != null ? prefix : "android", host, pathPrefix);
                XmlTag intentFilter = activity.createChildTag("intent-filter", null, tagContent, false);
                XmlTag tagAdded = activity.addSubTag(intentFilter, false);
                activity.addBefore((PsiElement)DeepLinkCodeGeneratorAction.createXmlComment(project, IF_COMMENT_TEXT), (PsiElement)tagAdded);
                XmlTag dataTag = tagAdded.findFirstSubTag("data");
                if (dataTag != null) {
                    tagAdded.addBefore((PsiElement)DeepLinkCodeGeneratorAction.createXmlComment(project, DATA_COMMENT_TEXT), (PsiElement)dataTag);
                }
            }
        }
    }

    private static XmlComment createXmlComment(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "createXmlComment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/actions/DeepLinkCodeGeneratorAction", "createXmlComment"));
        }
        XmlTag commentElement = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<foo>" + text + "</foo>"), (Language)XMLLanguage.INSTANCE);
        return (XmlComment)PsiTreeUtil.getChildOfType((PsiElement)commentElement, XmlComment.class);
    }

    private static String reversePackageName(String packageName) {
        ArrayList strs = Lists.newArrayList((Object[])packageName.split("\\."));
        return Joiner.on((char)'.').join((Iterable)Lists.reverse((List)strs));
    }

    private static String generatePathPrefix(String canonicalActivityName) {
        String[] strs = canonicalActivityName.split("\\.");
        if (strs.length > 0) {
            String shortActivityName = strs[strs.length - 1].toLowerCase(Locale.US);
            if (shortActivityName.endsWith(ACTIVITY_STRING)) {
                shortActivityName = shortActivityName.substring(0, shortActivityName.length() - ACTIVITY_STRING.length());
            }
            return shortActivityName;
        }
        return "";
    }
}

