/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.chartlib.EventData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.actions.AbstractClientToggleAction;
import com.android.tools.idea.editors.allocations.AllocationCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ToggleAllocationTrackingAction
extends AbstractClientToggleAction {
    private final Project myProject;
    private final EventData myEvents;
    private EventData.Event myEvent;

    public ToggleAllocationTrackingAction(@NotNull Project project, @NotNull DeviceContext context, @NotNull EventData events) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "<init>"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "<init>"));
        }
        super(context, AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]), AndroidBundle.message("android.ddms.actions.allocationtracker.description", new Object[0]), AndroidIcons.Ddms.AllocationTracker);
        this.myProject = project;
        this.myEvents = events;
    }

    @Override
    protected boolean isSelected(@NotNull Client c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "isSelected"));
        }
        return c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON;
    }

    @Override
    protected void setSelected(@NotNull Client c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "setSelected"));
        }
        long now = System.currentTimeMillis();
        if (c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON) {
            c.requestAllocationDetails();
            c.enableAllocationTracker(false);
            if (this.myEvent == null) {
                this.myEvent = this.myEvents.start(now, 2);
            }
            this.myEvent.stop(now);
            this.myEvent = null;
        } else {
            this.installListener(c, this.myProject);
            c.enableAllocationTracker(true);
            if (this.myEvent != null) {
                this.myEvent.stop(now);
            }
            this.myEvent = this.myEvents.start(now, 2);
        }
        c.requestAllocationStatus();
    }

    @Override
    @NotNull
    protected String getActiveText(@NotNull Client c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "getActiveText"));
        }
        String string = c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON ? AndroidBundle.message("android.ddms.actions.allocationtracker.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "getActiveText"));
        }
        return string;
    }

    private void installListener(final @NotNull Client listeningClient, @NotNull Project project) {
        if (listeningClient == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeningClient", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "installListener"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "installListener"));
        }
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                if (client == listeningClient && (changeMask & 0x200) != 0) {
                    final byte[] data = client.getClientData().getAllocationsData();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (ToggleAllocationTrackingAction.this.myProject.isDisposed()) {
                                    return;
                                }
                                final CaptureService service = CaptureService.getInstance(ToggleAllocationTrackingAction.this.myProject);
                                String name = service.getSuggestedName(listeningClient);
                                CaptureHandle handle = service.startCaptureFile(AllocationCaptureType.class, name);
                                service.appendDataCopy(handle, data);
                                service.finalizeCaptureFileAsynchronous(handle, new FutureCallback<Capture>(){

                                    public void onSuccess(Capture result) {
                                        service.notifyCaptureReady(result);
                                    }

                                    public void onFailure(Throwable t) {
                                        throw new RuntimeException(t);
                                    }
                                }, EdtExecutor.INSTANCE);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                }
            }
        });
    }
}

