/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.forms;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceDialog
extends JDialog {
    private JPanel contentPane;
    private JButton myBeginButton;
    private JButton myCancelButton;
    private JTextField myTraceName;
    private JProgressBar myProgressBar;
    private JPanel myProgressPanel;
    private JLabel myActionLabel;
    private JLabel myActionDetails;
    private State myState = State.UNINITIALIZED;
    @NotNull
    private Listener myListener = NULL_LISTENER;
    private static final Listener NULL_LISTENER = new Listener(){

        @Override
        public void onStartTrace(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/forms/TraceDialog$1", "onStartTrace"));
            }
        }

        @Override
        public void onStopTrace() {
        }

        @Override
        public void onCancelTrace() {
        }
    };

    public TraceDialog() {
        this.$$$setupUI$$$();
        this.setTitle("Graphics Trace");
        this.setContentPane(this.contentPane);
        this.getRootPane().setDefaultButton(this.myBeginButton);
        this.myBeginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceDialog.this.onBegin();
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceDialog.this.cancelStopOrClose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TraceDialog.this.cancelStopOrClose();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceDialog.this.cancelStopOrClose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.setState(State.PRE_TRACE);
        this.pack();
    }

    public void setListener(@Nullable Listener listener) {
        this.myListener = listener != null ? listener : NULL_LISTENER;
    }

    public void setDefaultName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/forms/TraceDialog", "setDefaultName"));
        }
        this.myTraceName.setText(name);
    }

    public void onProgress(@NotNull String action, @NotNull String details) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/editors/gfxtrace/forms/TraceDialog", "onProgress"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/android/tools/idea/editors/gfxtrace/forms/TraceDialog", "onProgress"));
        }
        this.myActionLabel.setText(action);
        this.myActionDetails.setText(details);
    }

    public void onError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/editors/gfxtrace/forms/TraceDialog", "onError"));
        }
        this.myActionLabel.setText(message);
        this.setState(State.ERROR);
    }

    public void onCancel() {
        this.dispose();
    }

    public void onStop() {
        this.dispose();
    }

    private void setState(State state) {
        if (this.myState == state) {
            return;
        }
        switch (state) {
            case PRE_TRACE: {
                this.myProgressPanel.setVisible(false);
                this.myTraceName.setEditable(true);
                this.myBeginButton.setVisible(true);
                this.myCancelButton.setText("Cancel");
                break;
            }
            case TRACING: {
                this.myProgressPanel.setVisible(true);
                this.myProgressBar.setVisible(true);
                this.myTraceName.setEditable(false);
                this.myBeginButton.setVisible(false);
                this.myCancelButton.setText("Stop");
                break;
            }
            case ERROR: {
                this.myProgressPanel.setVisible(true);
                this.myProgressBar.setVisible(false);
                this.myTraceName.setEditable(false);
                this.myBeginButton.setVisible(false);
                this.myCancelButton.setText("Close");
            }
        }
        this.myState = state;
        this.pack();
    }

    public void onBegin() {
        this.setState(State.TRACING);
        this.myListener.onStartTrace(this.myTraceName.getText().trim());
    }

    private void cancelStopOrClose() {
        switch (this.myState) {
            case PRE_TRACE: {
                this.myListener.onCancelTrace();
                this.onCancel();
                break;
            }
            case TRACING: {
                this.myListener.onStopTrace();
                this.onStop();
                break;
            }
            case ERROR: {
                this.onClose();
            }
        }
    }

    private void onClose() {
        this.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JProgressBar jProgressBar;
        JLabel jLabel2;
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(400, -1), null));
        this.myTraceName = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Trace file name:");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProgressPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        this.myActionLabel = jLabel2 = new JLabel();
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myActionDetails = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(11);
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBeginButton = jButton2 = new JButton();
        jButton2.setText("Trace...");
        jPanel5.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCancelButton = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public static interface Listener {
        public void onStartTrace(@NotNull String var1);

        public void onStopTrace();

        public void onCancelTrace();
    }

    private static enum State {
        UNINITIALIZED,
        PRE_TRACE,
        TRACING,
        ERROR;

    }
}

