/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.rpclib.futures.SingleInFlight;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class CellWidget<T extends Data, C extends JComponent>
extends JPanel {
    @NotNull
    protected final C myComponent;
    @NotNull
    protected final CellRenderer<T> myRenderer;
    @NotNull
    private List<T> myData = Collections.emptyList();
    @NotNull
    private AtomicBoolean myFireSelectionEvents = new AtomicBoolean(true);

    public CellWidget(C component, CellRenderer.CellLoader<T> loader) {
        super(new BorderLayout());
        this.myComponent = component;
        this.myRenderer = this.createCellRenderer(loader);
        this.add((Component)this.myComponent, "Center");
    }

    protected abstract CellRenderer<T> createCellRenderer(CellRenderer.CellLoader<T> var1);

    public CellRenderer<T> getRenderer() {
        return this.myRenderer;
    }

    public void addSelectionListener(final SelectionListener listener) {
        this.addSelectionListener(this.myComponent, new SelectionListener<T>(){

            @Override
            public void selected(T item) {
                if (CellWidget.this.myFireSelectionEvents.get()) {
                    listener.selected(item);
                }
            }
        });
    }

    protected abstract void addSelectionListener(C var1, SelectionListener<T> var2);

    public Iterable<T> items() {
        return this.myData;
    }

    public boolean isEmpty() {
        return this.myData.isEmpty();
    }

    public void setData(@NotNull List<T> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/gfxtrace/widgets/CellWidget", "setData"));
        }
        this.myData = data;
    }

    public abstract int getSelectedItem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItem(int index, boolean fireEvents) {
        boolean previousValue = this.myFireSelectionEvents.getAndSet(fireEvents);
        try {
            this.setSelectedIndex(this.myComponent, index);
        }
        finally {
            this.myFireSelectionEvents.set(previousValue);
        }
    }

    protected abstract void setSelectedIndex(C var1, int var2);

    public static interface SelectionListener<T> {
        public void selected(T var1);
    }

    public static class Data {
        public final SingleInFlight controller = new SingleInFlight(new SingleInFlight.Listener(){

            public void onIdleToWorking() {
                this.startLoading();
            }

            public void onWorkingToIdle() {
                this.stopLoading();
            }
        });
        protected LoadingState loadingState = LoadingState.NOT_LOADED;
        public boolean isSelected = false;

        public boolean requiresLoading() {
            return this.loadingState == LoadingState.NOT_LOADED;
        }

        public boolean isLoading() {
            return this.loadingState == LoadingState.LOADING;
        }

        public boolean isLoaded() {
            return this.loadingState == LoadingState.LOADED;
        }

        public void startLoading() {
            this.loadingState = LoadingState.LOADING;
        }

        public void stopLoading() {
            this.loadingState = LoadingState.LOADED;
        }

        protected static enum LoadingState {
            NOT_LOADED,
            LOADING,
            LOADED;

        }
    }
}

