/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.model;

import com.android.tools.idea.editors.navigation.model.State;

public class Locator {
    private final State state;
    private final String fragmentClassName;
    private final String viewId;

    private Locator(State state, String fragmentClassName, String viewId) {
        this.state = state;
        this.fragmentClassName = fragmentClassName;
        this.viewId = viewId;
    }

    public static Locator of(State state) {
        return new Locator(state, null, null);
    }

    public static Locator of(State state, String viewName) {
        return new Locator(state, null, viewName);
    }

    public static Locator of(State state, String fragmentClassName, String viewName) {
        return new Locator(state, fragmentClassName, viewName);
    }

    public State getState() {
        return this.state;
    }

    public String getFragmentClassName() {
        return this.fragmentClassName;
    }

    public String getViewId() {
        return this.viewId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Locator locator = (Locator)o;
        if (this.fragmentClassName != null ? !this.fragmentClassName.equals(locator.fragmentClassName) : locator.fragmentClassName != null) {
            return false;
        }
        if (!this.state.equals(locator.state)) {
            return false;
        }
        return !(this.viewId != null ? !this.viewId.equals(locator.viewId) : locator.viewId != null);
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + (this.fragmentClassName != null ? this.fragmentClassName.hashCode() : 0);
        result = 31 * result + (this.viewId != null ? this.viewId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Locator{state=" + this.state + ", viewName='" + this.viewId + '\'' + '}';
    }
}

