/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedConfiguration;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeAttributeResolver {
    private static final Logger LOG = Logger.getInstance(ThemeAttributeResolver.class);
    private final ConfigurationManager myManager;
    private final ConfiguredThemeEditorStyle myStyle;
    private final MultiMap<String, ConfiguredElement<ItemResourceValue>> myItemValueMap = new MultiMap();

    private ThemeAttributeResolver(ConfiguredThemeEditorStyle style, ConfigurationManager manager) {
        this.myStyle = style;
        this.myManager = manager;
    }

    @Nullable(value="if there is no configuration that matches to restrictions")
    private static RestrictedConfiguration getRestrictedConfiguration(@NotNull ThemeEditorStyle theme, @NotNull FolderConfiguration compatible) {
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/ThemeAttributeResolver", "getRestrictedConfiguration"));
        }
        if (compatible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compatible", "com/android/tools/idea/editors/theme/ThemeAttributeResolver", "getRestrictedConfiguration"));
        }
        ArrayList incompatibles = Lists.newArrayList();
        for (FolderConfiguration folder : theme.getFolders()) {
            if (compatible.equals((Object)folder)) continue;
            incompatibles.add(folder);
        }
        return RestrictedConfiguration.restrict(compatible, incompatibles);
    }

    private void resolveFromInheritance(@NotNull ThemeEditorStyle themeEditorStyle, @NotNull FolderConfiguration configuration, @NotNull RestrictedConfiguration restricted, @NotNull Set<String> seenAttributes) {
        if (themeEditorStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeEditorStyle", "com/android/tools/idea/editors/theme/ThemeAttributeResolver", "resolveFromInheritance"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeAttributeResolver", "resolveFromInheritance"));
        }
        if (restricted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restricted", "com/android/tools/idea/editors/theme/ThemeAttributeResolver", "resolveFromInheritance"));
        }
        if (seenAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seenAttributes", "com/android/tools/idea/editors/theme/ThemeAttributeResolver", "resolveFromInheritance"));
        }
        RestrictedConfiguration styleRestricted = ThemeAttributeResolver.getRestrictedConfiguration(themeEditorStyle, configuration);
        if (styleRestricted == null) {
            LOG.warn(configuration + " is unreachable");
            return;
        }
        if ((styleRestricted = restricted.intersect(styleRestricted)) == null) {
            return;
        }
        HashSet<String> newSeenAttributes = new HashSet<String>(seenAttributes);
        for (ItemResourceValue item : themeEditorStyle.getValues(configuration)) {
            String itemName = ResolutionUtils.getQualifiedItemName(item);
            if (newSeenAttributes.contains(itemName)) continue;
            this.myItemValueMap.putValue((Object)itemName, ConfiguredElement.create(styleRestricted.getAny(), item));
            newSeenAttributes.add(itemName);
        }
        String parentName = themeEditorStyle.getParentName(configuration);
        if (parentName == null) {
            return;
        }
        ThemeEditorStyle parent = new ThemeEditorStyle(this.myManager, parentName);
        for (FolderConfiguration folder : parent.getFolders()) {
            this.resolveFromInheritance(parent, folder, styleRestricted, newSeenAttributes);
        }
    }

    @NotNull
    private List<EditedStyleItem> resolveAll() {
        ThemeEditorStyle theme = new ThemeEditorStyle(this.myManager, this.myStyle.getQualifiedName());
        for (FolderConfiguration folder : theme.getFolders()) {
            this.resolveFromInheritance(this.myStyle, folder, new RestrictedConfiguration(), new HashSet<String>());
        }
        ArrayList result = Lists.newArrayList();
        FolderConfiguration configuration = this.myStyle.getConfiguration().getFullConfig();
        for (String key : this.myItemValueMap.keySet()) {
            Collection itemValues = this.myItemValueMap.get((Object)key);
            ConfiguredElement selectedValue = (ConfiguredElement)configuration.findMatchingConfigurable((List)Lists.newArrayList((Iterable)itemValues));
            if (selectedValue == null) {
                result.add(new EditedStyleItem((ConfiguredElement)itemValues.iterator().next(), itemValues, this.myStyle));
                continue;
            }
            itemValues.remove(selectedValue);
            assert (!itemValues.contains(selectedValue));
            result.add(new EditedStyleItem(selectedValue, itemValues, this.myStyle));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeAttributeResolver", "resolveAll"));
        }
        return arrayList;
    }

    public static List<EditedStyleItem> resolveAll(ConfiguredThemeEditorStyle style, ConfigurationManager manager) {
        return new ThemeAttributeResolver(style, manager).resolveAll();
    }
}

