/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.AbstractContentRootModuleCustomizer;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentRootModuleCustomizer
extends AbstractContentRootModuleCustomizer<AndroidGradleModel>
implements BuildVariantModuleCustomizer<AndroidGradleModel> {
    @Override
    @NotNull
    protected Collection<ContentEntry> findOrCreateContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull AndroidGradleModel androidModel) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        ArrayList contentEntries = Lists.newArrayList((Object[])new ContentEntry[]{moduleModel.addContentEntry(androidModel.getRootDir())});
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        if (!FileUtil.isAncestor((File)androidModel.getRootDirPath(), (File)buildFolderPath, (boolean)false)) {
            contentEntries.add(moduleModel.addContentEntry(FilePaths.pathToIdeaUrl(buildFolderPath)));
        }
        ArrayList arrayList = contentEntries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        return arrayList;
    }

    @Override
    protected void setUpContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull AndroidGradleModel androidModel, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        this.addSourceFolders(androidModel, contentEntries, (BaseArtifact)mainArtifact, false, orphans);
        if (GradleExperimentalSettings.getInstance().LOAD_ALL_TEST_ARTIFACTS) {
            for (BaseArtifact artifact : androidModel.getTestArtifactsInSelectedVariant()) {
                this.addSourceFolders(androidModel, contentEntries, artifact, true, orphans);
            }
        } else {
            BaseArtifact testArtifact = androidModel.findSelectedTestArtifact(androidModel.getSelectedVariant());
            if (testArtifact != null) {
                this.addSourceFolders(androidModel, contentEntries, testArtifact, true, orphans);
            }
        }
        for (String flavorName : selectedVariant.getProductFlavors()) {
            ProductFlavorContainer flavor = androidModel.findProductFlavor(flavorName);
            if (flavor == null) continue;
            this.addSourceFolder(androidModel, contentEntries, flavor, orphans);
        }
        String buildTypeName = selectedVariant.getBuildType();
        BuildTypeContainer buildTypeContainer = androidModel.findBuildType(buildTypeName);
        if (buildTypeContainer != null) {
            this.addSourceFolder(androidModel, contentEntries, buildTypeContainer.getSourceProvider(), false, orphans);
            Collection<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(buildTypeContainer.getExtraSourceProviders());
            for (SourceProvider testSourceProvider : testSourceProviders) {
                this.addSourceFolder(androidModel, contentEntries, testSourceProvider, true, orphans);
            }
        }
        ProductFlavorContainer defaultConfig = androidModel.getAndroidProject().getDefaultConfig();
        this.addSourceFolder(androidModel, contentEntries, defaultConfig, orphans);
        this.addExcludedOutputFolders(contentEntries, androidModel);
    }

    private void addSourceFolders(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull BaseArtifact artifact, boolean isTest, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        SourceProvider multiFlavorSourceProvider;
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        this.addGeneratedSourceFolders(androidModel, contentEntries, artifact, isTest, orphans);
        SourceProvider variantSourceProvider = artifact.getVariantSourceProvider();
        if (variantSourceProvider != null) {
            this.addSourceFolder(androidModel, contentEntries, variantSourceProvider, isTest, orphans);
        }
        if ((multiFlavorSourceProvider = artifact.getMultiFlavorSourceProvider()) != null) {
            this.addSourceFolder(androidModel, contentEntries, multiFlavorSourceProvider, isTest, orphans);
        }
    }

    private void addGeneratedSourceFolders(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull BaseArtifact artifact, boolean isTest, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        Collection generatedSourceFolders;
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolders"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolders"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolders"));
        }
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        if ((artifact instanceof AndroidArtifact || ContentRootModuleCustomizer.modelVersionIsAtLeast(androidModel, "1.2")) && (generatedSourceFolders = artifact.getGeneratedSourceFolders()) != null) {
            this.addSourceFolders(androidModel, contentEntries, generatedSourceFolders, sourceType, true, orphans);
        }
        if (artifact instanceof AndroidArtifact) {
            sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
            this.addSourceFolders(androidModel, contentEntries, ((AndroidArtifact)artifact).getGeneratedResourceFolders(), sourceType, true, orphans);
        }
    }

    private static boolean modelVersionIsAtLeast(@NotNull AndroidGradleModel androidModel, @NotNull String revision) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "modelVersionIsAtLeast"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "modelVersionIsAtLeast"));
        }
        GradleVersion modelVersion = androidModel.getModelVersion();
        return modelVersion != null && modelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    private void addSourceFolder(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull ProductFlavorContainer flavor, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        this.addSourceFolder(androidModel, contentEntries, flavor.getSourceProvider(), false, orphans);
        Collection<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(flavor.getExtraSourceProviders());
        for (SourceProvider sourceProvider : testSourceProviders) {
            this.addSourceFolder(androidModel, contentEntries, sourceProvider, true, orphans);
        }
    }

    private void addSourceFolder(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull SourceProvider sourceProvider, boolean isTest, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getResDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getResourcesDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getAssetsDirectories(), sourceType, false, orphans);
        sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getAidlDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getJavaDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getCDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getCppDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getRenderscriptDirectories(), sourceType, false, orphans);
    }

    @NotNull
    private static JpsModuleSourceRootType getResourceSourceType(boolean isTest) {
        JavaResourceRootType javaResourceRootType = isTest ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
        if (javaResourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getResourceSourceType"));
        }
        return javaResourceRootType;
    }

    @NotNull
    private static JpsModuleSourceRootType getSourceType(boolean isTest) {
        JavaSourceRootType javaSourceRootType = isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        if (javaSourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getSourceType"));
        }
        return javaSourceRootType;
    }

    private void addSourceFolders(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull Collection<File> folderPaths, @NotNull JpsModuleSourceRootType type, boolean generated, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (folderPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPaths", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        for (File folderPath : folderPaths) {
            if (generated && !ContentRootModuleCustomizer.isGeneratedAtCorrectLocation(folderPath, androidModel.getAndroidProject())) {
                androidModel.registerExtraGeneratedSourceFolder(folderPath);
            }
            this.addSourceFolder(contentEntries, folderPath, type, generated, orphans);
        }
    }

    private static boolean isGeneratedAtCorrectLocation(@NotNull File folderPath, @NotNull AndroidProject project) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "isGeneratedAtCorrectLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "isGeneratedAtCorrectLocation"));
        }
        File generatedFolderPath = new File(project.getBuildFolder(), "generated");
        return FileUtil.isAncestor((File)generatedFolderPath, (File)folderPath, (boolean)false);
    }

    private void addExcludedOutputFolders(@NotNull Collection<ContentEntry> contentEntries, @NotNull AndroidGradleModel androidModel) {
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addExcludedOutputFolders"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addExcludedOutputFolders"));
        }
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        ContentEntry parentContentEntry = FilePaths.findParentContentEntry(buildFolderPath, contentEntries);
        if (parentContentEntry != null) {
            List<File> excludedFolderPaths = androidModel.getExcludedFolderPaths();
            for (File folderPath : excludedFolderPaths) {
                this.addExcludedFolder(parentContentEntry, folderPath);
            }
        }
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public Class<AndroidGradleModel> getSupportedModelType() {
        if (AndroidGradleModel.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getSupportedModelType"));
        }
        return AndroidGradleModel.class;
    }
}

