/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel
extends GradleFileModel {
    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.parseBuildFile(file, project, "<Unknown>");
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildDslFile buildDslFile = new GradleBuildDslFile(file, project, moduleName);
        GradleBuildModel.populateWithParentModuleSubProjectsProperties(buildDslFile);
        buildDslFile.parse();
        GradleBuildModel gradleBuildModel = new GradleBuildModel(buildDslFile);
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    private static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "populateWithParentModuleSubProjectsProperties"));
        }
        GradleSettingsModel gradleSettingsModel = GradleSettingsModel.get(buildDslFile.getProject());
        if (gradleSettingsModel == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (parentModuleModel == null) {
            return;
        }
        GradleDslFile parentModuleDslFile = parentModuleModel.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getProperty("subprojects", SubProjectsDslElement.class);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement("subprojects", subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            buildDslFile.setParsedElement(entry.getKey(), entry.getValue());
        }
    }

    private GradleBuildModel(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "<init>"));
        }
        super(buildDslFile);
    }

    @NotNull
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.getProperty("android", AndroidDslElement.class);
        if (androidDslElement == null) {
            androidDslElement = new AndroidDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("android", androidDslElement);
        }
        AndroidModel androidModel = new AndroidModel(androidDslElement);
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "android"));
        }
        return androidModel;
    }

    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.getProperty("buildscript", BuildScriptDslElement.class);
        if (buildScriptDslElement == null) {
            buildScriptDslElement = new BuildScriptDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("buildscript", buildScriptDslElement);
        }
        BuildScriptModel buildScriptModel = new BuildScriptModel(buildScriptDslElement);
        if (buildScriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "buildscript"));
        }
        return buildScriptModel;
    }

    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.getProperty("dependencies", DependenciesDslElement.class);
        if (dependenciesDslElement == null) {
            dependenciesDslElement = new DependenciesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("dependencies", dependenciesDslElement);
        }
        return new DependenciesModel(dependenciesDslElement);
    }

    @NotNull
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getProperty("ext", ExtDslElement.class);
        if (extDslElement == null) {
            extDslElement = new ExtDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("ext", extDslElement);
        }
        ExtModel extModel = new ExtModel(extDslElement);
        if (extModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "ext"));
        }
        return extModel;
    }

    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getProperty("java", JavaDslElement.class);
        if (javaDslElement == null) {
            javaDslElement = new JavaDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("java", javaDslElement);
        }
        JavaModel javaModel = new JavaModel(javaDslElement);
        if (javaModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "java"));
        }
        return javaModel;
    }

    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.getProperty("repositories", RepositoriesDslElement.class);
        if (repositoriesDslElement == null) {
            repositoriesDslElement = new RepositoriesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("repositories", repositoriesDslElement);
        }
        RepositoriesModel repositoriesModel = new RepositoriesModel(repositoriesDslElement);
        if (repositoriesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "repositories"));
        }
        return repositoriesModel;
    }

    private static class GradleBuildDslFile
    extends GradleDslFile {
        private GradleBuildDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            super(file, project, moduleName);
        }

        @Override
        public void reparse() {
            super.reparse();
        }

        @Override
        protected void parse(@NotNull GroovyFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "parse"));
            }
            psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitApplicationStatement(GrApplicationStatement e) {
                    this.process((GroovyPsiElement)e);
                }

                void process(GroovyPsiElement e) {
                    GradleDslParser.parse(e, this);
                }
            }));
        }

        @Override
        public void setParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "setParsedElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "setParsedElement"));
            }
            if (("sourceCompatibility".equals(property) || "targetCompatibility".equals(property)) && (element instanceof GradleDslLiteral || element instanceof GradleDslReference)) {
                JavaDslElement javaDslElement = this.getProperty("java", JavaDslElement.class);
                if (javaDslElement == null) {
                    javaDslElement = new JavaDslElement(this);
                    super.setParsedElement("java", javaDslElement);
                }
                javaDslElement.setParsedElement(property, element);
                return;
            }
            super.setParsedElement(property, element);
        }

        @Override
        protected void reset() {
            super.reset();
        }

        @Override
        protected void apply() {
            super.apply();
        }
    }
}

