/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.settings;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslNewExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPropertiesDslElement
extends GradlePropertiesDslElement {
    @NonNls
    private static final String PROJECT_DIR = "projectDir";
    @NonNls
    private static final String BUILD_FILE_NAME = "buildFileName";

    public ProjectPropertiesDslElement(@Nullable GradleDslElement parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/settings/ProjectPropertiesDslElement", "<init>"));
        }
        super(parent, null, name);
    }

    @Nullable
    public File projectDir() {
        GradleDslNewExpression projectDir = this.getProperty(PROJECT_DIR, GradleDslNewExpression.class);
        if (projectDir == null || !projectDir.getName().equals("File")) {
            return null;
        }
        List<GradleDslExpression> arguments = projectDir.getArguments();
        if (arguments.isEmpty()) {
            return null;
        }
        String firstArgumentValue = arguments.get(0).getValue(String.class);
        if (firstArgumentValue == null) {
            return null;
        }
        File result = new File(firstArgumentValue);
        for (int i = 1; i < arguments.size(); ++i) {
            String value = arguments.get(i).getValue(String.class);
            if (value == null) {
                return null;
            }
            result = new File(result, value);
        }
        return result;
    }

    @Nullable
    public String buildFileName() {
        return this.getProperty(BUILD_FILE_NAME, String.class);
    }

    @Nullable
    public static String getStandardProjectKey(@NotNull String projectReference) {
        if (projectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectReference", "com/android/tools/idea/gradle/dsl/parser/settings/ProjectPropertiesDslElement", "getStandardProjectKey"));
        }
        String standardForm = projectReference.replaceAll("\\s", "").replace("\"", "'");
        if (standardForm.startsWith("project(':") && standardForm.endsWith("')")) {
            return standardForm;
        }
        return null;
    }
}

