/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixAndroidGradlePluginVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myModelVersion;
    @Nullable
    private final String myGradleVersion;
    private final boolean myOpenMigrationGuide;

    public FixAndroidGradlePluginVersionHyperlink(boolean openMigrationGuide) {
        this("2.0.0", "2.10", openMigrationGuide);
    }

    public FixAndroidGradlePluginVersionHyperlink(@NotNull String modelVersion, @Nullable String gradleVersion, boolean openMigrationGuide) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/service/notification/hyperlink/FixAndroidGradlePluginVersionHyperlink", "<init>"));
        }
        super("fixGradleElements", openMigrationGuide ? "Open migration guide, fix plugin version and sync project" : "Fix plugin version and sync project");
        this.myModelVersion = modelVersion;
        this.myGradleVersion = gradleVersion;
        this.myOpenMigrationGuide = false;
    }

    @Override
    public void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixAndroidGradlePluginVersionHyperlink", "execute"));
        }
        if (this.myOpenMigrationGuide) {
            BrowserUtil.browse((String)"http://tools.android.com/tech-docs/new-build-system/migrating-to-1-0-0");
        }
        GradleUtil.updateGradlePluginVersionAndNotifyFailure(project, this.myModelVersion, this.myGradleVersion, false);
    }
}

