/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.ArtifactRepositorySearch;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.SearchResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

class MavenCentralRepositorySearch
extends ArtifactRepositorySearch {
    MavenCentralRepositorySearch() {
    }

    @Override
    @NotNull
    String getName() {
        if ("Maven Central" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch", "getName"));
        }
        return "Maven Central";
    }

    @Override
    boolean supportsPagination() {
        return true;
    }

    @Override
    @NotNull
    SearchResult start(@NotNull ArtifactRepositorySearch.Request request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch", "start"));
        }
        String url = MavenCentralRepositorySearch.createRequestUrl(request);
        SearchResult searchResult = (SearchResult)HttpRequests.request((String)url).accept("application/xml").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<SearchResult>(){

            public SearchResult process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch$1", "process"));
                }
                try {
                    return MavenCentralRepositorySearch.this.parse(request.getReader());
                }
                catch (JDOMException e) {
                    String msg = String.format("Failed to parse request '%1$s'", request);
                    throw new IOException(msg, e);
                }
            }
        });
        if (searchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch", "start"));
        }
        return searchResult;
    }

    @VisibleForTesting
    @NotNull
    static String createRequestUrl(@NotNull ArtifactRepositorySearch.Request request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch", "createRequestUrl"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("https://search.maven.org/solrsearch/select?").append("rows=").append(request.rows).append("&").append("start=").append(request.start).append("&").append("wt=xml&").append("q=");
        String groupId = request.groupId;
        if (StringUtil.isNotEmpty((String)groupId)) {
            buffer.append("g:\"").append(groupId).append("\"+AND+");
        }
        buffer.append("a:\"").append(request.artifactName).append("\"");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch", "createRequestUrl"));
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    SearchResult parse(@NotNull Reader response) throws JDOMException, IOException {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch", "parse"));
        }
        ArrayList data = Lists.newArrayList();
        int totalFound = 0;
        Element root = JDOMUtil.load((Reader)response);
        Element result = root.getChild("result");
        if (result != null) {
            String found = result.getAttributeValue("numFound");
            if (StringUtil.isNotEmpty((String)found)) {
                try {
                    totalFound = Integer.parseInt(found);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            block2: for (Element doc : result.getChildren("doc")) {
                String id = null;
                String latestVersion = null;
                for (Element str : doc.getChildren("str")) {
                    String name = str.getAttributeValue("name");
                    if ("id".equals(name)) {
                        id = str.getTextTrim();
                    } else if ("latestVersion".equals(name)) {
                        latestVersion = str.getTextTrim();
                    }
                    if (!StringUtil.isNotEmpty((String)id) || !StringUtil.isNotEmpty((String)latestVersion)) continue;
                    data.add(id + ":" + latestVersion);
                    continue block2;
                }
            }
        }
        SearchResult searchResult = new SearchResult(this.getName(), data, totalFound);
        if (searchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/MavenCentralRepositorySearch", "parse"));
        }
        return searchResult;
    }
}

