/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import android.databinding.tool.reflection.ModelField;
import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.databinding.BrUtil;
import com.android.tools.idea.lang.databinding.DataBindingXmlReferenceContributor;
import com.android.tools.idea.lang.databinding.DbFile;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.model.PsiModelField;
import com.android.tools.idea.lang.databinding.model.PsiModelMethod;
import com.android.tools.idea.lang.databinding.psi.PsiDbDotExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbMethodExpr;
import com.android.tools.idea.rendering.DataBindingInfo;
import com.android.tools.idea.rendering.PsiDataBindingResourceItem;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class DataBindingCompletionContributor
extends CompletionContributor {
    public DataBindingCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                boolean fullCompletion;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/lang/databinding/DataBindingCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/lang/databinding/DataBindingCompletionContributor$1", "addCompletions"));
                }
                PsiElement position = parameters.getOriginalPosition();
                boolean bl = fullCompletion = parameters.getInvocationCount() > 1;
                if (position == null) {
                    position = parameters.getPosition();
                }
                PsiElement parent = position.getParent();
                PsiReference[] references = parent.getReferences();
                boolean usingGrandparent = false;
                if (references.length == 0) {
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof PsiDbDotExpr) {
                        parent = ((PsiDbDotExpr)grandParent).getExpr();
                    } else if (grandParent instanceof PsiDbMethodExpr) {
                        parent = ((PsiDbMethodExpr)grandParent).getExpr();
                    } else {
                        if (grandParent instanceof DbFile) {
                            DataBindingCompletionContributor.autoCompleteVariables((DbFile)grandParent, result);
                            return;
                        }
                        return;
                    }
                    references = parent.getReferences();
                    usingGrandparent = true;
                }
                for (PsiReference reference : references) {
                    if (!(reference instanceof DataBindingXmlReferenceContributor.ResolvesToModelClass)) continue;
                    DataBindingXmlReferenceContributor.ResolvesToModelClass ref = (DataBindingXmlReferenceContributor.ResolvesToModelClass)reference;
                    boolean staticRef = ref.isStatic();
                    PsiModelClass resolvedType = ref.getResolvedType();
                    if (resolvedType == null) {
                        return;
                    }
                    for (ModelField modelField : resolvedType.getDeclaredFields()) {
                        PsiModelField psiModelField = (PsiModelField)modelField;
                        if (!fullCompletion && (!psiModelField.isPublic() || staticRef && !psiModelField.isStatic())) continue;
                        if (usingGrandparent) {
                            result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)psiModelField.getPsiField()));
                            continue;
                        }
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)psiModelField.getPsiField(), (String)(parent.getText() + "." + psiModelField.getName())));
                    }
                    for (ModelField modelField : resolvedType.getDeclaredMethods()) {
                        PsiMethod psiMethod;
                        PsiModelMethod psiModelMethod = (PsiModelMethod)modelField;
                        if (!fullCompletion && !psiModelMethod.isPublic() || psiModelMethod.isVoid() || (psiMethod = psiModelMethod.getPsiMethod()).isConstructor() || !fullCompletion && staticRef && !psiModelMethod.isStatic()) continue;
                        String name = psiModelMethod.getName() + "()";
                        if (BrUtil.isGetter(psiMethod)) {
                            name = StringUtil.decapitalize((String)psiModelMethod.getName().substring(3));
                        } else if (BrUtil.isBooleanGetter(psiMethod)) {
                            name = StringUtil.decapitalize((String)psiModelMethod.getName().substring(2));
                        }
                        if (usingGrandparent) {
                            result.addElement((LookupElement)LookupElementBuilder.create((Object)psiMethod, (String)name));
                            continue;
                        }
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)psiMethod, (String)(parent.getText() + "." + name)));
                    }
                }
            }
        });
    }

    private static void autoCompleteVariables(DbFile file, CompletionResultSet result) {
        DataBindingInfo dataBindingInfo = DataBindingXmlReferenceContributor.getDataBindingInfo((PsiElement)file);
        if (dataBindingInfo == null) {
            return;
        }
        for (PsiDataBindingResourceItem resourceItem : dataBindingInfo.getItems(DataBindingResourceType.VARIABLE)) {
            result.addElement((LookupElement)LookupElementBuilder.create((Object)resourceItem.getXmlTag(), (String)resourceItem.getName()));
        }
    }
}

