/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.proguard;

import com.android.tools.idea.lang.proguard.ProguardFileType;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ProguardFileTypeFactory
extends FileTypeFactory {
    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/lang/proguard/ProguardFileTypeFactory", "createFileTypes"));
        }
        consumer.consume((FileType)ProguardFileType.INSTANCE, new FileNameMatcher[]{new ProguardNameMatcher()});
    }

    private static class ProguardNameMatcher
    extends FileNameMatcherEx {
        private ProguardNameMatcher() {
        }

        public boolean acceptsCharSequence(@NotNull CharSequence fileName) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/lang/proguard/ProguardFileTypeFactory$ProguardNameMatcher", "acceptsCharSequence"));
            }
            return StringUtil.endsWith((CharSequence)fileName, (CharSequence)".pro") || StringUtil.startsWith((CharSequence)fileName, (CharSequence)"proguard-") && StringUtil.endsWith((CharSequence)fileName, (CharSequence)".txt") || StringUtil.equals((CharSequence)fileName, (CharSequence)"proguard.cfg");
        }

        @NotNull
        public String getPresentableString() {
            if ("*.pro or proguard-*.txt or proguard.cfg" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/proguard/ProguardFileTypeFactory$ProguardNameMatcher", "getPresentableString"));
            }
            return "*.pro or proguard-*.txt or proguard.cfg";
        }
    }
}

