/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.MonitorPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class MinimizeAction
extends AnAction
implements RightAlignedToolbarAction {
    private static final Icon MIN_ICON = AllIcons.General.HideDown;
    private static final Icon RESTORE_ICON = AllIcons.Debugger.RestoreLayout;
    @NotNull
    private MonitorPanel myMonitorPanel;
    @NotNull
    private BaseMonitorView myBaseMonitorView;

    MinimizeAction(@NotNull MonitorPanel monitorPanel, @NotNull BaseMonitorView monitor) {
        if (monitorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitorPanel", "com/android/tools/idea/monitor/MinimizeAction", "<init>"));
        }
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MinimizeAction", "<init>"));
        }
        super("Minimize/Maximize " + monitor.getTitleName() + " Monitor", "Minimizes or maximizes the " + monitor.getTitleName() + " Monitor.", monitor.getIsMinimized() ? RESTORE_ICON : MIN_ICON);
        this.myMonitorPanel = monitorPanel;
        this.myBaseMonitorView = monitor;
    }

    public void actionPerformed(AnActionEvent e) {
        this.myMonitorPanel.setMonitorMinimized(this.myBaseMonitorView, !this.myBaseMonitorView.getIsMinimized());
        this.update(e);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(this.myBaseMonitorView.getIsMinimized() ? RESTORE_ICON : MIN_ICON);
    }
}

