/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.navigator.nodes.AndroidResFileNode;
import com.android.tools.idea.navigator.nodes.AndroidResGroupNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class AndroidResComparator
implements Comparator {
    public static final AndroidResComparator INSTANCE = new AndroidResComparator();

    public int compare(Object o1, Object o2) {
        int c;
        int c2;
        if (!(o1 instanceof NodeDescriptor) || !(o2 instanceof NodeDescriptor)) {
            return 0;
        }
        if (!(o1 instanceof AndroidResFileNode) && !(o1 instanceof AndroidResGroupNode)) {
            return 0;
        }
        if (!(o2 instanceof AndroidResFileNode) && !(o2 instanceof AndroidResGroupNode)) {
            return 0;
        }
        if (o1 instanceof AndroidResGroupNode || o2 instanceof AndroidResGroupNode) {
            String n1 = AndroidResComparator.getName(o1);
            String n2 = AndroidResComparator.getName(o2);
            return StringUtil.compare((String)n1, (String)n2, (boolean)false);
        }
        AndroidResFileNode r1 = (AndroidResFileNode)o1;
        AndroidResFileNode r2 = (AndroidResFileNode)o2;
        PsiFile file1 = (PsiFile)r1.getValue();
        PsiFile file2 = (PsiFile)r2.getValue();
        if (file1 != null && file2 != null && (c2 = StringUtil.compare((String)file1.getName(), (String)file2.getName(), (boolean)false)) != 0) {
            return c2;
        }
        FolderConfiguration config1 = r1.getFolderConfiguration();
        FolderConfiguration config2 = r2.getFolderConfiguration();
        if (config1 != null && config2 != null && (c = config1.compareTo(config2)) != 0) {
            return c;
        }
        return StringUtil.compare((String)r1.getQualifier(), (String)r2.getQualifier(), (boolean)false);
    }

    @Nullable
    private static String getName(Object o1) {
        if (o1 instanceof AndroidResGroupNode) {
            return ((AndroidResGroupNode)o1).getResName();
        }
        if (o1 instanceof AndroidResFileNode) {
            return ((AndroidResFileNode)o1).getResName();
        }
        return null;
    }
}

