/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidModuleNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestsNode
extends ProjectViewNode<AndroidFacet>
implements DirectoryGroupNode {
    private static final String ANDROID_TESTS = "androidTests";
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidTestsNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull ViewSettings viewSettings, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "<init>"));
        }
        if (projectViewPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectViewPane", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "<init>"));
        }
        super(project, (Object)facet, viewSettings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = ((AndroidFacet)((Object)this.getValue())).getModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || facet.getAndroidModel() == null) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "getChildren"));
            }
            return list;
        }
        Collection<AbstractTreeNode> collection = AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, IdeaSourceProvider.getCurrentTestSourceProviders(facet));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "getChildren"));
        }
        return collection;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "contains"));
        }
        Module module = ((AndroidFacet)((Object)this.getValue())).getModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || facet.getAndroidModel() == null) {
            return false;
        }
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentTestSourceProviders(facet)) {
            if (!provider.containsFile(file)) continue;
            return true;
        }
        return false;
    }

    public void update(PresentationData presentation) {
        presentation.setPresentableText(ANDROID_TESTS);
        presentation.addText(ANDROID_TESTS, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(ModuleType.get((Module)((AndroidFacet)((Object)this.getValue())).getModule()).getIcon());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return ANDROID_TESTS;
    }

    public boolean equals(Object object) {
        return object instanceof AndroidTestsNode && super.equals(object);
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidTestsNode", "getDirectories"));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }
}

