/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.sdklib.repositoryv2.targets.AndroidTargetManager;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.sdkv2.StudioDownloader;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdkv2.StudioProgressRunner;
import com.android.tools.idea.sdkv2.StudioSettingsController;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormFactorApiComboBox
extends JComboBox {
    private static final Set<AndroidVersion> ourInstalledVersions = Sets.newHashSet();
    private static final List<AndroidTargetComboBoxItem> ourTargets = Lists.newArrayList();
    private static IAndroidTarget ourHighestInstalledApiTarget;
    private FormFactorUtils.FormFactor myFormFactor;
    private RepoPackage myInstallRequest;
    private ScopedStateStore.Key<String> myBuildApiKey;
    private ScopedStateStore.Key<Integer> myBuildApiLevelKey;
    private ScopedStateStore.Key<Integer> myTargetApiLevelKey;
    private ScopedStateStore.Key<String> myTargetApiStringKey;
    private ScopedStateStore.Key<AndroidTargetComboBoxItem> myTargetComboBoxKey;
    private ScopedStateStore.Key<Boolean> myInclusionKey;
    private RepositoryPackages myRepoPackages;
    static final ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox> TARGET_COMBO_BINDING;

    public void init(@NotNull FormFactorUtils.FormFactor formFactor, int minSdkLevel, @Nullable Runnable completedCallback, @Nullable Runnable foundItemsCallback, @Nullable Runnable noItemsCallback) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorApiComboBox", "init"));
        }
        this.myFormFactor = formFactor;
        FormFactorApiComboBox.loadTargets();
        FormFactorApiComboBox.loadInstalledVersions();
        this.myBuildApiKey = FormFactorUtils.getBuildApiKey(formFactor);
        this.myBuildApiLevelKey = FormFactorUtils.getBuildApiLevelKey(formFactor);
        this.myTargetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(formFactor);
        this.myTargetApiStringKey = FormFactorUtils.getTargetApiStringKey(formFactor);
        this.myTargetComboBoxKey = FormFactorUtils.getTargetComboBoxKey(formFactor);
        this.myInclusionKey = FormFactorUtils.getInclusionKey(formFactor);
        this.populateComboBox(formFactor, minSdkLevel);
        if (this.getItemCount() > 0 && foundItemsCallback != null) {
            foundItemsCallback.run();
        }
        this.loadSavedApi();
        this.loadRemoteTargets(minSdkLevel, completedCallback, foundItemsCallback, noItemsCallback);
    }

    public void registerWith(@NotNull ScopedDataBinder binder) {
        if (binder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binder", "com/android/tools/idea/npw/FormFactorApiComboBox", "registerWith"));
        }
        assert (this.myFormFactor != null) : "register() called on FormFactorApiComboBox before init()";
        binder.register(FormFactorUtils.getTargetComboBoxKey(this.myFormFactor), this, TARGET_COMBO_BINDING);
    }

    public void loadSavedApi() {
        String savedApiLevel = PropertiesComponent.getInstance().getValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), Integer.toString(this.myFormFactor.defaultApi));
        this.setSelectedItem(savedApiLevel);
        if (this.getSelectedIndex() < 0 && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void deriveValues(@NotNull ScopedStateStore stateStore, @NotNull Set<ScopedStateStore.Key> modified) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/android/tools/idea/npw/FormFactorApiComboBox", "deriveValues"));
        }
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/android/tools/idea/npw/FormFactorApiComboBox", "deriveValues"));
        }
        if (modified.contains(this.myTargetComboBoxKey) || modified.contains(this.myInclusionKey)) {
            AndroidSdkData sdkData;
            AndroidTargetComboBoxItem targetItem = stateStore.get(this.myTargetComboBoxKey);
            if (targetItem == null) {
                return;
            }
            stateStore.put(FormFactorUtils.getMinApiKey(this.myFormFactor), ((String)targetItem.getData()).toString());
            stateStore.put(FormFactorUtils.getMinApiLevelKey(this.myFormFactor), targetItem.apiLevel);
            IAndroidTarget target = targetItem.target;
            if (target != null && (target.getVersion().isPreview() || !target.isPlatform())) {
                this.populateApiLevels(targetItem.apiLevel, target, stateStore);
            } else {
                int targetApiLevel = ourHighestInstalledApiTarget != null ? ourHighestInstalledApiTarget.getVersion().getFeatureLevel() : 0;
                this.populateApiLevels(targetApiLevel, ourHighestInstalledApiTarget, stateStore);
            }
            AndroidVersion androidVersion = new AndroidVersion(targetItem.apiLevel, null);
            String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)androidVersion);
            if (this.myInstallRequest != null) {
                stateStore.listRemove(WizardConstants.INSTALL_REQUESTS_KEY, this.myInstallRequest.getPath());
                if (!(this.myInstallRequest.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) {
                    stateStore.listRemove(WizardConstants.INSTALL_REQUESTS_KEY, platformPath);
                }
            }
            if (target == null) {
                if (ourHighestInstalledApiTarget == null || androidVersion.getApiLevel() > ourHighestInstalledApiTarget.getVersion().getApiLevel() && !ourInstalledVersions.contains(androidVersion) && stateStore.get(this.myInclusionKey).booleanValue()) {
                    platformPath = DetailsTypes.getPlatformPath((AndroidVersion)new AndroidVersion(23, null));
                    stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformPath);
                    this.myInstallRequest = (RepoPackage)this.myRepoPackages.getRemotePackages().get(platformPath);
                    this.populateApiLevels(23, null, stateStore);
                }
                if (targetItem.myAddon != null) {
                    RepoPackage p = targetItem.myAddon;
                    stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, p.getPath());
                    this.myInstallRequest = p;
                    StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
                    AndroidTargetManager targetManager = AndroidSdkUtils.tryToChooseSdkHandler().getAndroidTargetManager((ProgressIndicator)progress);
                    if (targetManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion), (ProgressIndicator)progress) == null) {
                        stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformPath);
                    }
                    this.populateApiLevels(targetItem.apiLevel, null, stateStore);
                }
            }
            PropertiesComponent.getInstance().setValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), ((String)targetItem.getData()).toString());
            String javaVersion = null;
            if (ourHighestInstalledApiTarget != null && ourHighestInstalledApiTarget.getVersion().getFeatureLevel() >= 21 && (sdkData = AndroidSdkUtils.tryToChooseAndroidSdk()) != null) {
                JavaSdkVersion version;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version = jdk.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    javaVersion = JavaSdkVersion.JDK_1_7.getDescription();
                }
            }
            stateStore.put(FormFactorUtils.getLanguageLevelKey(this.myFormFactor), javaVersion);
        }
    }

    public void setSelectedItem(String item) {
        ScopedDataBinder.setSelectedItem(this, item);
    }

    private void populateComboBox(@NotNull FormFactorUtils.FormFactor formFactor, int minSdk) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorApiComboBox", "populateComboBox"));
        }
        for (AndroidTargetComboBoxItem target : Iterables.filter(ourTargets, FormFactorUtils.getMinSdkComboBoxFilter(formFactor, minSdk))) {
            if (target.apiLevel < minSdk && (target.target == null || !target.target.getVersion().isPreview())) continue;
            this.addItem(target);
        }
    }

    private static void loadTargets() {
        ourTargets.clear();
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(knownVersions[i], i + 1);
                ourTargets.add(targetInfo);
            }
        }
        for (IAndroidTarget target : targets) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourTargets.add(targetInfo);
        }
    }

    public static void loadInstalledVersions() {
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        IAndroidTarget highestInstalledTarget = null;
        ourInstalledVersions.clear();
        for (IAndroidTarget target : targets) {
            if (target.isPlatform() && target.getVersion().getFeatureLevel() >= 22 && (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview())) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourInstalledVersions.add(targetInfo.target.getVersion());
        }
        ourHighestInstalledApiTarget = highestInstalledTarget;
    }

    @NotNull
    private static IAndroidTarget[] getCompilationTargets() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            IAndroidTarget[] iAndroidTargetArray = new IAndroidTarget[]{};
            if (iAndroidTargetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox", "getCompilationTargets"));
            }
            return iAndroidTargetArray;
        }
        IAndroidTarget[] iAndroidTargetArray = FormFactorApiComboBox.getCompilationTargets(sdkData);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    @NotNull
    public static IAndroidTarget[] getCompilationTargets(@NotNull AndroidSdkData sdkData) {
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "com/android/tools/idea/npw/FormFactorApiComboBox", "getCompilationTargets"));
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() && target.getAdditionalLibraries().isEmpty()) continue;
            list.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = list.toArray(new IAndroidTarget[list.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    public void populateApiLevels(int apiLevel, @Nullable IAndroidTarget apiTarget, @NotNull ScopedStateStore state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/FormFactorApiComboBox", "populateApiLevels"));
        }
        if (apiLevel >= 1) {
            if (apiTarget == null) {
                state.put(this.myBuildApiKey, Integer.toString(apiLevel));
            } else if (!apiTarget.isPlatform()) {
                state.put(this.myBuildApiKey, AndroidTargetHash.getTargetHashString((IAndroidTarget)apiTarget));
            } else {
                state.put(this.myBuildApiKey, TemplateMetadata.getBuildApiString(apiTarget.getVersion()));
            }
            state.put(this.myBuildApiLevelKey, apiLevel);
            if (apiLevel >= 23 || apiTarget != null && apiTarget.getVersion().isPreview()) {
                state.put(this.myTargetApiLevelKey, apiLevel);
                if (apiTarget != null) {
                    state.put(this.myTargetApiStringKey, apiTarget.getVersion().getApiString());
                } else {
                    state.put(this.myTargetApiStringKey, Integer.toString(apiLevel));
                }
            } else if (ourHighestInstalledApiTarget != null) {
                state.put(this.myTargetApiLevelKey, ourHighestInstalledApiTarget.getVersion().getApiLevel());
                state.put(this.myTargetApiStringKey, ourHighestInstalledApiTarget.getVersion().getApiString());
            }
        }
    }

    private void loadRemoteTargets(final int minSdkLevel, final Runnable completedCallback, final Runnable foundItemsCallback, final Runnable noItemsCallback) {
        AndroidSdkHandler sdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
        final StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        final AndroidTargetManager targetManager = sdkHandler.getAndroidTargetManager((ProgressIndicator)progress);
        final Runnable runCallbacks = new Runnable(){

            @Override
            public void run() {
                if (completedCallback != null) {
                    completedCallback.run();
                }
                if (FormFactorApiComboBox.this.getItemCount() > 0) {
                    if (foundItemsCallback != null) {
                        foundItemsCallback.run();
                    }
                } else if (noItemsCallback != null) {
                    noItemsCallback.run();
                }
            }
        };
        RepoManager.RepoLoadedCallback onComplete = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/npw/FormFactorApiComboBox$3", "doRun"));
                }
                ArrayList packageList = Lists.newArrayList((Iterable)packages.getNewPkgs());
                Collections.sort(packageList);
                for (RepoPackage info : Iterables.filter((Iterable)packageList, FormFactorUtils.getMinSdkPackageFilter(FormFactorApiComboBox.this.myFormFactor, minSdkLevel))) {
                    FormFactorApiComboBox.this.addItem(new AndroidTargetComboBoxItem(info));
                }
                runCallbacks.run();
            }
        };
        RepoManager.RepoLoadedCallback onLocalComplete = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/npw/FormFactorApiComboBox$4", "doRun"));
                }
                ArrayList packageList = Lists.newArrayList(packages.getLocalPackages().values());
                Collections.sort(packageList);
                Iterable addons = Iterables.filter((Iterable)packageList, (Predicate)new Predicate<LocalPackage>(){

                    public boolean apply(LocalPackage input) {
                        return input.getTypeDetails() instanceof DetailsTypes.AddonDetailsType;
                    }
                });
                Iterable result = Iterables.filter((Iterable)addons, FormFactorUtils.getMinSdkPackageFilter(FormFactorApiComboBox.this.myFormFactor, minSdkLevel));
                for (LocalPackage info : result) {
                    if (targetManager.getTargetFromPackage(info, (ProgressIndicator)progress) != null) continue;
                    FormFactorApiComboBox.this.addItem(new AndroidTargetComboBoxItem((RepoPackage)info));
                }
                FormFactorApiComboBox.this.myRepoPackages = packages;
            }
        };
        Runnable onError = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        runCallbacks.run();
                    }
                }, ModalityState.any());
            }
        };
        StudioProgressRunner runner = new StudioProgressRunner(false, true, false, "Refreshing Targets", true, null);
        sdkHandler.getSdkManager((ProgressIndicator)progress).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)onLocalComplete), (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    static {
        TARGET_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox>(){

            @Override
            public void setValue(@Nullable AndroidTargetComboBoxItem newValue, @NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "setValue"));
                }
                component.setSelectedItem(newValue);
            }

            @Override
            @Nullable
            public AndroidTargetComboBoxItem getValue(@NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "getValue"));
                }
                return (AndroidTargetComboBoxItem)component.getItemAt(component.getSelectedIndex());
            }

            @Override
            public void addActionListener(@NotNull ActionListener listener, @NotNull JComboBox component) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "addActionListener"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "addActionListener"));
                }
                component.addActionListener(listener);
            }
        };
    }

    public static class AndroidTargetComboBoxItem
    extends ApiComboBoxItem<String> {
        public int apiLevel;
        public IAndroidTarget target;
        public RepoPackage myAddon;

        public AndroidTargetComboBoxItem(@NotNull String label, int apiLevel) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "<init>"));
            }
            super(Integer.toString(apiLevel), label, 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.myAddon = null;
            this.apiLevel = apiLevel;
        }

        public AndroidTargetComboBoxItem(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "<init>"));
            }
            super(AndroidTargetComboBoxItem.getId(target), AndroidTargetComboBoxItem.getLabel(target), 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.myAddon = null;
            this.target = target;
            this.apiLevel = target.getVersion().getFeatureLevel();
        }

        public AndroidTargetComboBoxItem(RepoPackage info) {
            this(info.getDisplayName(), ((DetailsTypes.AddonDetailsType)info.getTypeDetails()).getApiLevel());
            this.myAddon = info;
        }

        @NotNull
        private static String getLabel(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
            }
            if (target.isPlatform() && target.getVersion().getApiLevel() <= 23) {
                if (target.getVersion().isPreview()) {
                    String string = target.getVersion().getApiString() + ": " + target.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
                    }
                    return string;
                }
                String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
                if (name == null) {
                    String string = "API " + Integer.toString(target.getVersion().getApiLevel());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
                    }
                    return string;
                }
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
                }
                return string;
            }
            String string = AndroidSdkUtils.getTargetLabel(target);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
            }
            return string;
        }

        @NotNull
        private static String getId(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getId"));
            }
            String string = target.getVersion().getApiString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getId"));
            }
            return string;
        }
    }
}

