/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ClipartAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.swing.IconProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public final class ClipartAssetButton
extends JButton
implements AssetComponent {
    private static final int CLIPART_BUTTON_SIZE = JBUI.scale((int)40);
    private static final int CLIPART_DIALOG_BORDER = JBUI.scale((int)10);
    private static final int DIALOG_HEADER = JBUI.scale((int)20);
    private final ClipartAsset myClipartAsset = new ClipartAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myListeners = Lists.newArrayListWithExpectedSize((int)1);

    public ClipartAssetButton() {
        ClipartAssetButton.setIconButtonDimensions(this);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipartAssetButton.this.showClipartDialog();
            }
        });
        this.myBindings.bind(new IconProperty(this), new Expression<Optional<Icon>>(new ObservableValue[]{this.myClipartAsset.clipartName()}){

            @Override
            @NotNull
            public Optional<Icon> get() {
                Optional optional;
                try {
                    optional = Optional.of((Object)ClipartAssetButton.this.myClipartAsset.createIcon());
                }
                catch (IOException e) {
                    Optional optional2 = Optional.absent();
                    if (optional2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ClipartAssetButton$2", "get"));
                    }
                    return optional2;
                }
                if (optional == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ClipartAssetButton$2", "get"));
                }
                return optional;
            }
        });
        this.myClipartAsset.clipartName().addListener(new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/npw/assetstudio/ui/ClipartAssetButton$3", "onInvalidated"));
                }
                ActionEvent e = new ActionEvent(this, 1001, null);
                for (ActionListener listener : ClipartAssetButton.this.myListeners) {
                    listener.actionPerformed(e);
                }
            }
        });
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(ClipartAssetButton.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ClipartAssetButton", "getLog"));
        }
        return logger;
    }

    private static void setIconButtonDimensions(@NotNull JButton b) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/npw/assetstudio/ui/ClipartAssetButton", "setIconButtonDimensions"));
        }
        Dimension d = new Dimension(CLIPART_BUTTON_SIZE, CLIPART_BUTTON_SIZE);
        b.setMinimumSize(d);
        b.setMaximumSize(d);
        b.setPreferredSize(d);
    }

    @Override
    @NotNull
    public BaseAsset getAsset() {
        ClipartAsset clipartAsset = this.myClipartAsset;
        if (clipartAsset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ClipartAssetButton", "getAsset"));
        }
        return clipartAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/android/tools/idea/npw/assetstudio/ui/ClipartAssetButton", "addAssetListener"));
        }
        this.myListeners.add(l);
    }

    private void showClipartDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        final JDialog dialog = new JDialog(window, "Choose Clipart", Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.getRootPane().setLayout(new BorderLayout());
        dialog.getRootPane().setBorder(new EmptyBorder(CLIPART_DIALOG_BORDER, CLIPART_DIALOG_BORDER, CLIPART_DIALOG_BORDER, CLIPART_DIALOG_BORDER));
        FlowLayout layout = new FlowLayout(0);
        JPanel iconPanel = new JPanel(layout);
        List<String> clipartNames = ClipartAsset.getAllClipartNames();
        for (final String clipartName : clipartNames) {
            try {
                JButton btn = new JButton();
                btn.setIcon(ClipartAsset.createIcon(clipartName));
                ClipartAssetButton.setIconButtonDimensions(btn);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClipartAssetButton.this.myClipartAsset.clipartName().set(clipartName);
                        dialog.setVisible(false);
                    }
                });
                iconPanel.add(btn);
            }
            catch (IOException e) {
                ClipartAssetButton.getLog().error((Throwable)e);
            }
        }
        dialog.getRootPane().add(iconPanel);
        int size = (int)(Math.sqrt(clipartNames.size()) + 1.0) * (CLIPART_BUTTON_SIZE + layout.getHgap()) + CLIPART_DIALOG_BORDER * 2;
        dialog.setSize(size, size + DIALOG_HEADER);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }
}

