/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.archives.Archive;
import com.android.tools.idea.sdk.remote.internal.packages.IMinPlatformToolsDependency;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkRepoConstants;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.android.utils.GrabProcessOutput;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class RemoteToolPkgInfo
extends RemotePkgInfo
implements IMinPlatformToolsDependency {
    public static final String INSTALL_ID = "tools";
    private static final String INSTALL_ID_PREVIEW = "tools-preview";
    private final Revision mMinPlatformToolsRevision;

    public RemoteToolPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mMinPlatformToolsRevision = RemotePackageParserUtils.parseRevisionElement(RemotePackageParserUtils.findChildElement(packageNode, "min-platform-tools-rev"));
        if (this.mMinPlatformToolsRevision.equals((Object)MIN_PLATFORM_TOOLS_REV_INVALID) && SdkRepoConstants.versionGreaterOrEqualThan(nsUri, 3)) {
            throw new IllegalArgumentException(String.format("Missing %1$s element in %2$s package", "min-platform-tools-rev", "platform-tool"));
        }
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newTool((Revision)this.getRevision(), (Revision)this.mMinPlatformToolsRevision);
        pkgDescBuilder.setDescriptionShort(RemoteToolPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteToolPkgInfo.createListDescription(this.mListDisplay, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    public Revision getMinPlatformToolsRevision() {
        return this.mMinPlatformToolsRevision;
    }

    @Override
    public String installId() {
        if (this.getRevision().isPreview()) {
            return INSTALL_ID_PREVIEW;
        }
        return INSTALL_ID;
    }

    private static String createListDescription(String listDisplay, boolean obsolete) {
        return String.format("%1$s%2$s", listDisplay.isEmpty() ? "Android SDK Tools" : listDisplay, obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, Revision revision, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Tools, revision %1$s%2$s", revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        if (!this.getMinPlatformToolsRevision().equals((Object)MIN_PLATFORM_TOOLS_REV_INVALID)) {
            props.setProperty("Platform.MinPlatformToolsRev", this.getMinPlatformToolsRevision().toShortString());
        }
    }

    @Override
    public void postInstallHook(Archive archive, final ITaskMonitor monitor, File installFolder) {
        super.postInstallHook(archive, monitor, installFolder);
        if (installFolder == null) {
            return;
        }
        File libDir = new File(installFolder, "lib");
        if (!libDir.isDirectory()) {
            return;
        }
        String scriptName = "post_tools_install";
        String shell = "";
        if (SdkConstants.currentPlatform() == 2) {
            shell = "cmd.exe /c ";
            scriptName = scriptName + ".bat";
        } else {
            scriptName = scriptName + ".sh";
        }
        File scriptFile = new File(libDir, scriptName);
        if (!scriptFile.isFile()) {
            return;
        }
        int status = -1;
        try {
            Process proc = Runtime.getRuntime().exec(shell + scriptName, null, libDir);
            final String tag = scriptName;
            status = GrabProcessOutput.grabProcessOutput((Process)proc, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_PROCESS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                public void out(String line) {
                    if (line != null) {
                        monitor.log("[%1$s] %2$s", tag, line);
                    }
                }

                public void err(String line) {
                    if (line != null) {
                        monitor.logError("[%1$s] Error: %2$s", tag, line);
                    }
                }
            });
        }
        catch (Exception e) {
            monitor.logError("Exception: %s", e.toString());
        }
        if (status != 0) {
            monitor.logError("Failed to execute %s", scriptName);
            return;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mMinPlatformToolsRevision == null ? 0 : this.mMinPlatformToolsRevision.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemoteToolPkgInfo)) {
            return false;
        }
        RemoteToolPkgInfo other = (RemoteToolPkgInfo)obj;
        return !(this.mMinPlatformToolsRevision == null ? other.mMinPlatformToolsRevision != null : !this.mMinPlatformToolsRevision.equals((Object)other.mMinPlatformToolsRevision));
    }
}

