/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.expressions.string;

import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.expressions.string.StringExpression;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FormatExpression
extends StringExpression {
    private final List<ObservableValue> myValues;
    @NotNull
    private final String myFormatString;

    public FormatExpression(@NotNull String formatString, ObservableValue ... values) {
        if (formatString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatString", "com/android/tools/idea/ui/properties/expressions/string/FormatExpression", "<init>"));
        }
        super(values);
        this.myFormatString = formatString;
        this.myValues = Arrays.asList(values);
    }

    @Override
    @NotNull
    public String get() {
        Object[] values = new Object[this.myValues.size()];
        int i = 0;
        for (ObservableValue observableValue : this.myValues) {
            values[i++] = observableValue.get();
        }
        String string = String.format(this.myFormatString, values);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/expressions/string/FormatExpression", "get"));
        }
        return string;
    }
}

