/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.actions;

import com.android.tools.idea.configurations.FlatComboAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.PlatformIcons;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractComboBoxAction<T>
extends FlatComboAction {
    protected static final Icon CHECKED = PlatformIcons.CHECK_ICON;
    protected List<T> myItems = Collections.emptyList();
    private T mySelection;
    private Presentation myPresentation;
    private boolean myShowDisabledActions;

    public void setItems(List<T> items, @Nullable T selection) {
        this.myItems = items;
        this.setSelection(selection);
    }

    public T getSelection() {
        return this.mySelection;
    }

    public void setSelection(T selection) {
        this.mySelection = selection;
        if (selection == null && !this.myItems.isEmpty()) {
            this.mySelection = this.myItems.get(0);
        }
        this.update();
    }

    public void clearSelection() {
        this.mySelection = null;
        this.update();
    }

    public void showDisabledActions(boolean value) {
        this.myShowDisabledActions = value;
    }

    @Override
    public JComponent createCustomComponent(Presentation presentation) {
        this.myPresentation = presentation;
        this.update();
        return super.createCustomComponent(presentation);
    }

    @Override
    protected FlatComboAction.FlatComboButton createComboBoxButton(Presentation presentation) {
        if (this.myShowDisabledActions) {
            return new FlatComboAction.FlatComboButton(presentation){

                @Override
                protected JBPopup createPopup(Runnable onDispose) {
                    ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)AbstractComboBoxAction.this.createPopupActionGroup(this), this.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, onDispose, AbstractComboBoxAction.this.getMaxRows());
                    popup.setMinimumSize(new Dimension(AbstractComboBoxAction.this.getMinWidth(), AbstractComboBoxAction.this.getMinHeight()));
                    return popup;
                }
            };
        }
        return super.createComboBoxButton(presentation);
    }

    public void update() {
        this.update(this.mySelection, this.myPresentation == null ? this.getTemplatePresentation() : this.myPresentation, false);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (final T item : this.myItems) {
            if (this.addSeparator(actionGroup, item)) continue;
            AnAction action = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (AbstractComboBoxAction.this.mySelection != item && AbstractComboBoxAction.this.selectionChanged(item)) {
                        AbstractComboBoxAction.this.mySelection = item;
                        AbstractComboBoxAction.this.update(item, AbstractComboBoxAction.this.myPresentation, false);
                    }
                }
            };
            actionGroup.add(action);
            Presentation presentation = action.getTemplatePresentation();
            presentation.setIcon(this.mySelection == item ? CHECKED : null);
            this.update(item, presentation, true);
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/actions/AbstractComboBoxAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    protected boolean addSeparator(DefaultActionGroup actionGroup, T item) {
        return false;
    }

    protected abstract void update(T var1, Presentation var2, boolean var3);

    protected abstract boolean selectionChanged(T var1);
}

