/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.google.common.collect.Lists;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeConverter
extends ResolvingConverter<String> {
    private final List<ResolvingConverter<String>> myConverters;

    CompositeConverter(List<ResolvingConverter<String>> converters) {
        this.myConverters = converters;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        ArrayList variants = Lists.newArrayList();
        for (ResolvingConverter<String> converter : this.myConverters) {
            variants.addAll(converter.getVariants(context));
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/CompositeConverter", "getVariants"));
        }
        return arrayList;
    }

    public String fromString(@Nullable String s, ConvertContext context) {
        for (ResolvingConverter<String> converter : this.myConverters) {
            String result = (String)converter.fromString(s, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotThreadSafe
    public static class Builder {
        private final List<ResolvingConverter<String>> myConverters = Lists.newArrayList();
        private boolean myIsBuilt = false;

        private void assertNotBuilt() {
            if (this.myIsBuilt) {
                throw new IllegalStateException("CompositeConverterBuilder shouldn't be used after .build() is called");
            }
        }

        public void addConverter(@NotNull ResolvingConverter<String> converter) {
            if (converter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "org/jetbrains/android/dom/converters/CompositeConverter$Builder", "addConverter"));
            }
            this.assertNotBuilt();
            this.myConverters.add(converter);
        }

        @Nullable
        public ResolvingConverter<String> build() {
            this.assertNotBuilt();
            this.myIsBuilt = true;
            switch (this.myConverters.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.myConverters.get(0);
                }
            }
            return new CompositeConverter(this.myConverters);
        }
    }
}

