/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.Node;
import com.google.gwt.dev.js.rhino.TokenStream;

public class IRFactory {
    private TokenStream ts;

    public IRFactory(TokenStream ts) {
        this.ts = ts;
    }

    public Object createScript(Object body2, String sourceName, int baseLineno, int endLineno, Object source) {
        Node result2 = new Node(147);
        Node children2 = ((Node)body2).getFirstChild();
        if (children2 != null) {
            result2.addChildrenToBack(children2);
        }
        result2.putProp(16, sourceName);
        result2.putIntProp(28, baseLineno);
        result2.putIntProp(29, endLineno);
        if (source != null) {
            result2.putProp(17, source);
        }
        return result2;
    }

    public Object createLeaf(int nodeType) {
        return new Node(nodeType);
    }

    public Object createLeaf(int nodeType, int nodeOp) {
        return new Node(nodeType, nodeOp);
    }

    public int getLeafType(Object leaf) {
        Node n = (Node)leaf;
        return n.getType();
    }

    public Object createSwitch(int lineno) {
        return new Node(115, lineno);
    }

    public Object createVariables(int lineno) {
        return new Node(123, lineno);
    }

    public Object createExprStatement(Object expr, int lineno) {
        return new Node(140, (Node)expr, lineno);
    }

    public Object createName(String name2) {
        return Node.newString(44, name2);
    }

    public Object createString(String string) {
        return Node.newString(string);
    }

    public Object createNumber(int number) {
        return Node.newNumber(number);
    }

    public Object createNumber(double number) {
        return Node.newNumber(number);
    }

    public Object createCatch(String varName, Object catchCond, Object stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new Node(109, 52);
        }
        return new Node(125, (Node)this.createName(varName), (Node)catchCond, (Node)stmts, lineno);
    }

    public Object createThrow(Object expr, int lineno) {
        return new Node(62, (Node)expr, lineno);
    }

    public Object createReturn(Object expr, int lineno) {
        return expr == null ? new Node(5, lineno) : new Node(5, (Node)expr, lineno);
    }

    public Object createLabel(String label, int lineno) {
        Node result2 = new Node(136, lineno);
        Node name2 = Node.newString(44, label);
        result2.addChildToBack(name2);
        return result2;
    }

    public Object createBreak(String label, int lineno) {
        Node result2 = new Node(121, lineno);
        if (label == null) {
            return result2;
        }
        Node name2 = Node.newString(44, label);
        result2.addChildToBack(name2);
        return result2;
    }

    public Object createContinue(String label, int lineno) {
        Node result2 = new Node(122, lineno);
        if (label == null) {
            return result2;
        }
        Node name2 = Node.newString(44, label);
        result2.addChildToBack(name2);
        return result2;
    }

    public Object createDebugger(int lineno) {
        Node result2 = new Node(146, lineno);
        return result2;
    }

    public Object createBlock(int lineno) {
        return new Node(133, lineno);
    }

    public Object createFunction(String name2, Object args, Object statements, String sourceName, int baseLineno, int endLineno, Object source, boolean isExpr) {
        Node f = new Node(110, Node.newString(44, name2 == null ? "" : name2), (Node)args, (Node)statements, baseLineno);
        f.putProp(16, sourceName);
        f.putIntProp(28, baseLineno);
        f.putIntProp(29, endLineno);
        if (source != null) {
            f.putProp(17, source);
        }
        return f;
    }

    public void addChildToBack(Object parent2, Object child) {
        ((Node)parent2).addChildToBack((Node)child);
    }

    public Object createWhile(Object cond, Object body2, int lineno) {
        return new Node(118, (Node)cond, (Node)body2, lineno);
    }

    public Object createDoWhile(Object body2, Object cond, int lineno) {
        return new Node(119, (Node)body2, (Node)cond, lineno);
    }

    public Object createFor(Object init, Object test, Object incr, Object body2, int lineno) {
        return new Node(120, (Node)init, (Node)test, (Node)incr, (Node)body2);
    }

    public Object createForIn(Object lhs, Object obj, Object body2, int lineno) {
        return new Node(120, (Node)lhs, (Node)obj, (Node)body2);
    }

    public Object createTryCatchFinally(Object tryblock, Object catchblocks, Object finallyblock, int lineno) {
        if (finallyblock == null) {
            return new Node(75, (Node)tryblock, (Node)catchblocks);
        }
        return new Node(75, (Node)tryblock, (Node)catchblocks, (Node)finallyblock);
    }

    public Object createWith(Object obj, Object body2, int lineno) {
        return new Node(124, (Node)obj, (Node)body2, lineno);
    }

    public Object createArrayLiteral(Object obj) {
        return obj;
    }

    public Object createObjectLiteral(Object obj) {
        return obj;
    }

    public Object createRegExp(String string, String flags) {
        return flags.length() == 0 ? new Node(56, Node.newString(string)) : new Node(56, Node.newString(string), Node.newString(flags));
    }

    public Object createIf(Object cond, Object ifTrue, Object ifFalse, int lineno) {
        if (ifFalse == null) {
            return new Node(113, (Node)cond, (Node)ifTrue, lineno);
        }
        return new Node(113, (Node)cond, (Node)ifTrue, (Node)ifFalse, lineno);
    }

    public Object createTernary(Object cond, Object ifTrue, Object ifFalse) {
        return new Node(98, (Node)cond, (Node)ifTrue, (Node)ifFalse);
    }

    public Object createUnary(int nodeType, Object child) {
        Node childNode = (Node)child;
        return new Node(nodeType, childNode);
    }

    public Object createUnary(int nodeType, int nodeOp, Object child) {
        return new Node(nodeType, (Node)child, nodeOp);
    }

    public Object createBinary(int nodeType, Object left, Object right) {
        switch (nodeType) {
            case 108: {
                nodeType = 39;
                Node idNode = (Node)right;
                idNode.setType(46);
                String id = idNode.getString();
                if (!id.equals("__proto__") && !id.equals("__parent__")) break;
                Node result2 = new Node(nodeType, (Node)left);
                result2.putProp(19, id);
                return result2;
            }
            case 90: {
                nodeType = 41;
            }
        }
        return new Node(nodeType, (Node)left, (Node)right);
    }

    public Object createBinary(int nodeType, int nodeOp, Object left, Object right) {
        if (nodeType == 97) {
            return this.createAssignment(nodeOp, (Node)left, (Node)right, null, false);
        }
        return new Node(nodeType, (Node)left, (Node)right, nodeOp);
    }

    public Object createAssignment(int nodeOp, Node left, Node right, Class convert2, boolean postfix) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: 
            case 41: 
            case 44: {
                break;
            }
            default: {
                this.reportError("msg.bad.lhs.assign");
            }
        }
        return new Node(97, left, right, nodeOp);
    }

    private void reportError(String msgResource) {
        String message2 = Context.getMessage0(msgResource);
        this.ts.reportSyntaxError(message2, null);
    }
}

