/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor$CFPVisitor$WhenMappings;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "generate", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "subroutine", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateImplicitReturnValue", "", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generatePseudocode", "processLocalDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "CFPVisitor", "frontend"})
public final class ControlFlowProcessor {
    private final ControlFlowBuilder builder;
    private final BindingTrace trace;

    @NotNull
    public final Pseudocode generatePseudocode(@NotNull KtElement subroutine) {
        Pseudocode pseudocode2;
        Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
        Pseudocode pseudocode3 = pseudocode2 = this.generate(subroutine);
        if (pseudocode3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        }
        ((PseudocodeImpl)pseudocode3).postProcess();
        return pseudocode2;
    }

    private final Pseudocode generate(KtElement subroutine) {
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof KtDeclarationWithBody && !(subroutine instanceof KtSecondaryConstructor)) {
            List<KtParameter> valueParameters = ((KtDeclarationWithBody)subroutine).getValueParameters();
            for (KtParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter);
            }
            KtExpression bodyExpression = ((KtDeclarationWithBody)subroutine).getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
                if (!((KtDeclarationWithBody)subroutine).hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        return this.builder.exitSubroutine(subroutine);
    }

    private final void generateImplicitReturnValue(KtExpression bodyExpression, KtElement subroutine) {
        CallableDescriptor callableDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor subroutineDescriptor = callableDescriptor;
        KotlinType returnType2 = subroutineDescriptor.getReturnType();
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue pseudoValue = this.builder.getBoundValue(bodyExpression);
        if (pseudoValue == null) {
            return;
        }
        PseudoValue returnValue = pseudoValue;
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private final void processLocalDeclaration(KtDeclaration subroutine) {
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, subroutine, null);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    public ControlFlowProcessor(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.trace = trace;
        this.builder = new ControlFlowInstructionsGenerator();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0087\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002\u00d2\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J(\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J5\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u001b\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u001cJ1\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001b\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u00182\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0018H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010 \u001a\u00020$H\u0002J\u001e\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020$0\u00182\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0002J(\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020'2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110-2\u0006\u0010.\u001a\u00020$H\u0002J\u0010\u0010/\u001a\u00020\r2\u0006\u0010 \u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\r2\u0006\u0010 \u001a\u000200H\u0002J\u0010\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\u000fH\u0002J\u0014\u00102\u001a\u0002042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u00105\u001a\u00020\r2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\r2\u0006\u00109\u001a\u00020:H\u0002J\u0018\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0011H\u0002J\u0010\u0010@\u001a\u00020\r2\u0006\u00109\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010 \u001a\u00020EH\u0002J8\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020H0G2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020H2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020H0GH\u0002J2\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020H0G2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110-2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020O0\u000bH\u0002J\u0014\u0010P\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010Q\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020RH\u0002J\u0012\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010 \u001a\u00020$H\u0002J\u0010\u0010U\u001a\u00020V2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010W\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110-2\b\u0010 \u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010X\u001a\u0004\u0018\u00010T2\u0006\u0010 \u001a\u00020$H\u0002J:\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020Z0G2\u0006\u00103\u001a\u00020\u000f2\b\u0010[\u001a\u0004\u0018\u00010Z2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020Z0GH\u0002J \u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020Z0]2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0012\u0010^\u001a\u00020V2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010_\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110-2\b\u0010`\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010a\u001a\u00020\t2\u0006\u0010 \u001a\u00020bH\u0002J\u0010\u0010c\u001a\u00020\t2\u0006\u0010d\u001a\u00020eH\u0002J\u0018\u0010f\u001a\u00020\t2\u0006\u0010g\u001a\u00020R2\u0006\u0010h\u001a\u00020\u000fH\u0002J\u0010\u0010i\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010j\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020$0\u00182\u0006\u0010\u0016\u001a\u00020$H\u0002J\u0016\u0010k\u001a\u00020\r2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0002J\u0010\u0010m\u001a\u00020\r2\u0006\u0010 \u001a\u00020nH\u0016J\u0010\u0010o\u001a\u00020\r2\u0006\u0010p\u001a\u00020qH\u0016J\u0010\u0010r\u001a\u00020\r2\u0006\u0010 \u001a\u00020'H\u0016J*\u0010s\u001a\u00020\r2\b\u0010+\u001a\u0004\u0018\u00010$2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110-2\u0006\u0010.\u001a\u00020$H\u0002J\u0010\u0010t\u001a\u00020\r2\u0006\u0010 \u001a\u000200H\u0016J\u0010\u0010u\u001a\u00020\r2\u0006\u0010 \u001a\u00020vH\u0016J\u0010\u0010w\u001a\u00020\r2\u0006\u0010 \u001a\u00020bH\u0016J\u0010\u0010x\u001a\u00020\r2\u0006\u0010 \u001a\u00020yH\u0016J\u0010\u0010z\u001a\u00020\r2\u0006\u0010 \u001a\u00020{H\u0016J\u0010\u0010|\u001a\u00020\r2\u0006\u0010}\u001a\u00020~H\u0016J\u0011\u0010\u007f\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u0080\u0001H\u0016J\u0012\u0010\u0081\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u0082\u0001H\u0016J\u0013\u0010\u0083\u0001\u001a\u00020\r2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0016J\u0012\u0010\u0086\u0001\u001a\u00020\r2\u0007\u0010=\u001a\u00030\u0087\u0001H\u0016J\u001b\u0010\u0086\u0001\u001a\u00020\r2\u0007\u0010=\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u00020\tH\u0002J\u0012\u0010\u0089\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u008a\u0001H\u0016J\u0012\u0010\u008b\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u008c\u0001H\u0016J\u0011\u0010\u008d\u0001\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0016J\u0013\u0010\u008e\u0001\u001a\u00020\r2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0002J\u0012\u0010\u0091\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u0092\u0001H\u0016J\u0012\u0010\u0093\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u0094\u0001H\u0016J\u0011\u0010\u0095\u0001\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0096\u0001\u001a\u00020\r2\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0016J\u0012\u0010\u0099\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u009a\u0001H\u0016J\u0013\u0010\u009b\u0001\u001a\u00020\r2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0016J\u0013\u0010\u009e\u0001\u001a\u00020\r2\b\u0010\u008f\u0001\u001a\u00030\u009f\u0001H\u0016J\u0013\u0010\u00a0\u0001\u001a\u00020\r2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00a4\u0001H\u0016J\u0011\u0010\u00a5\u0001\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u00a6\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00a7\u0001H\u0016J\u0013\u0010\u00a8\u0001\u001a\u00020\r2\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0016J\u0013\u0010\u00ab\u0001\u001a\u00020\r2\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0016J\u0012\u0010\u00ae\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00af\u0001H\u0016J\u0012\u0010\u00b0\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00b1\u0001H\u0016J\u0013\u0010\u00b2\u0001\u001a\u00020\r2\b\u0010\u00b3\u0001\u001a\u00030\u00b4\u0001H\u0016J\u0013\u0010\u00b5\u0001\u001a\u00020\r2\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001H\u0016J\u0012\u0010\u00b8\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00b9\u0001H\u0016J\u0012\u0010\u00ba\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00bb\u0001H\u0016J\u0012\u0010\u00bc\u0001\u001a\u00020\r2\u0007\u00106\u001a\u00030\u00bd\u0001H\u0016J\u0013\u0010\u00be\u0001\u001a\u00020\r2\b\u0010\u0084\u0001\u001a\u00030\u00bf\u0001H\u0016J\u0013\u0010\u00c0\u0001\u001a\u00020\r2\b\u0010\u00c1\u0001\u001a\u00030\u00c2\u0001H\u0016J\u0012\u0010\u00c3\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00c4\u0001H\u0016J\u0012\u0010\u00c5\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00c6\u0001H\u0016J\u0011\u0010\u00c7\u0001\u001a\u00020\r2\u0006\u0010 \u001a\u00020EH\u0016J\u0013\u0010\u00c8\u0001\u001a\u00020\r2\b\u0010\u00c9\u0001\u001a\u00030\u00ca\u0001H\u0016J\u0012\u0010\u00cb\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00cc\u0001H\u0016J\u0012\u0010\u00cd\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00ce\u0001H\u0016J\u0012\u0010\u00cf\u0001\u001a\u00020\r2\u0007\u0010 \u001a\u00030\u00d0\u0001H\u0016J\u0011\u0010\u00d1\u0001\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u00d3\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;)V", "conditionVisitor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1", "Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1;", "checkAndGenerateCall", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "checkNothingType", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "computePseudoValueForParameter", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "copyValue", "from", "to", "createNonSyntheticValue", "", "kind", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;[Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "createSyntheticValue", "instructionElement", "declareLoopParameter", "expression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "elementsToValues", "generateAndGetReceiverIfAny", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateArrayAccess", "arrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "generateArrayAccessArguments", "generateArrayAccessWithoutCall", "generateArrayAssignment", "lhs", "rhsDeferredValue", "Lkotlin/Function0;", "parentExpression", "generateBooleanOperation", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "generateBothArgumentsAndMark", "generateCall", "callElement", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/InstructionWithValue;", "generateCallOrMarkUnresolved", "call", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "generateDeclarationForLocalClassOrObjectIfNeeded", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateHeaderDelegationSpecifiers", "generateInitializer", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "initValue", "generateInitializersForScriptClassOrObject", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "generateInstructions", "generateTryAndCatches", "Lorg/jetbrains/kotlin/cfg/Label;", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "generateValueArgument", "Lcom/intellij/util/SmartFMap;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameterDescriptor", "parameterValuesArg", "getArraySetterArguments", "setResolvedCall", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getBoundOrUnreachableValue", "getCorrespondingLoop", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "getCorrespondingLoopWithoutLabel", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "getDeclarationAccessTarget", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;", "getDeferredValue", "getNearestLoopExpression", "getReceiverValues", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiver", "receiverValuesArg", "", "getResolvedCallAccessTarget", "getValueAsFunction", "value", "isBlockInDoWhile", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isIncrementOrDecrement", "operationType", "Lcom/intellij/psi/tree/IElementType;", "jumpDoesNotCrossFunctionBoundary", "jumpExpression", "jumpTarget", "mark", "mergeValues", "processParameters", "parameters", "visitAnnotatedExpression", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "visitAnonymousInitializer", "classInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "visitArrayAccessExpression", "visitAssignment", "visitBinaryExpression", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBlockExpression", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitDelegatedSuperTypeEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "visitDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "generateWriteForEntries", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitDoubleColonExpression", "Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "visitForExpression", "visitFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitKtElement", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectDeclaration", "objectDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitParameter", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "visitScript", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitSuperTypeCallEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "visitSuperTypeList", "list", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitTryExpression", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "writeLoopParameterAssignment", "FinallyBlockGenerator", "frontend"})
    private final class CFPVisitor
    extends KtVisitorVoid {
        private final conditionVisitor.1 conditionVisitor;
        private final ControlFlowBuilder builder;

        private final void mark(KtElement element2) {
            this.builder.mark(element2);
        }

        public final void generateInstructions(@Nullable KtElement element2) {
            if (element2 == null) {
                return;
            }
            element2.accept(this);
            this.checkNothingType(element2);
        }

        private final void checkNothingType(KtElement element2) {
            if (!(element2 instanceof KtExpression)) {
                return;
            }
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)element2);
            if (ktExpression == null) {
                return;
            }
            KtExpression expression2 = ktExpression;
            if (expression2 instanceof KtStatementExpression || expression2 instanceof KtTryExpression || expression2 instanceof KtIfExpression || expression2 instanceof KtWhenExpression) {
                return;
            }
            KotlinType type2 = ControlFlowProcessor.this.trace.getBindingContext().getType(expression2);
            if (type2 != null && KotlinBuiltIns.isNothing(type2)) {
                KtElement ktElement = expression2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"expression");
                this.builder.jumpToError(ktElement);
            }
        }

        private final PseudoValue createSyntheticValue(KtElement instructionElement, MagicKind kind2, KtElement ... from) {
            return this.builder.magic(instructionElement, null, this.elementsToValues(ArraysKt.asList((Object[])from)), kind2).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, List<? extends KtElement> from, MagicKind kind2) {
            return this.builder.magic(to, to, this.elementsToValues(from), kind2).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, MagicKind kind2, KtElement ... from) {
            return this.createNonSyntheticValue(to, ArraysKt.asList((Object[])from), kind2);
        }

        private final void mergeValues(List<? extends KtExpression> from, KtExpression to) {
            this.builder.merge(to, this.elementsToValues(from));
        }

        private final void copyValue(KtElement from, KtElement to) {
            block0: {
                PseudoValue pseudoValue = this.getBoundOrUnreachableValue(from);
                if (pseudoValue == null) break block0;
                PseudoValue pseudoValue2 = pseudoValue;
                PseudoValue it = pseudoValue2;
                this.builder.bindValue(it, to);
            }
        }

        private final PseudoValue getBoundOrUnreachableValue(KtElement element2) {
            if (element2 == null) {
                return null;
            }
            PseudoValue value2 = this.builder.getBoundValue(element2);
            return value2 != null || element2 instanceof KtDeclaration ? value2 : this.builder.newValue(element2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<PseudoValue> elementsToValues(List<? extends KtElement> from) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = from;
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList();
            void var5_5 = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                PseudoValue pseudoValue;
                Object element$iv$iv = element$iv$iv$iv;
                KtElement element2 = (KtElement)element$iv$iv;
                if (this.getBoundOrUnreachableValue(element2) == null) continue;
                PseudoValue it$iv$iv = pseudoValue;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final void generateInitializer(KtDeclaration declaration, PseudoValue initValue) {
            this.builder.write(declaration, declaration, initValue, this.getDeclarationAccessTarget(declaration), MapsKt.emptyMap());
        }

        private final AccessTarget getResolvedCallAccessTarget(KtElement element2) {
            AccessTarget accessTarget;
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element2, bindingContext2);
            if (resolvedCall2 != null) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                ResolvedCall<? extends CallableDescriptor> it = resolvedCall3;
                accessTarget = new AccessTarget.Call(it);
            } else {
                accessTarget = AccessTarget.BlackBox.INSTANCE;
            }
            return accessTarget;
        }

        private final AccessTarget getDeclarationAccessTarget(KtElement element2) {
            DeclarationDescriptor descriptor2 = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
            return descriptor2 instanceof VariableDescriptor ? (AccessTarget)new AccessTarget.Declaration((VariableDescriptor)descriptor2) : (AccessTarget)AccessTarget.BlackBox.INSTANCE;
        }

        @Override
        public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression innerExpression = expression2.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression);
                this.copyValue(innerExpression, expression2);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitThisExpression(@NotNull KtThisExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtElement ktElement = expression2;
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
            if (resolvedCall2 == null) {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, new KtElement[0]);
                return;
            }
            CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression2, resolvedCall2, this.getReceiverValues(resolvedCall2));
            }
            KtElement ktElement2 = expression2;
            KtElement ktElement3 = expression2.getInstanceReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement3, (String)"expression.instanceReference");
            this.copyValue(ktElement2, ktElement3);
        }

        @Override
        public void visitConstantExpression(@NotNull KtConstantExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2;
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.Companion.getConstant(ktExpression, bindingContext2);
            this.builder.loadConstant(expression2, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtElement ktElement = expression2;
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
            } else if (!this.generateCall(expression2) && !(expression2.getParent() instanceof KtCallExpression)) {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, this.generateAndGetReceiverIfAny(expression2));
            }
        }

        @Override
        public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtSimpleNameExpression operationReference = expression2.getOperationReference();
            IElementType operationType = operationReference.getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            if (operationType == KtTokens.ANDAND || operationType == KtTokens.OROR) {
                this.generateBooleanOperation(expression2);
            } else if (operationType == KtTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression2);
            } else {
                Map map2 = (Map)OperatorConventions.ASSIGNMENT_OPERATIONS;
                Map map3 = map2;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map3.containsKey(operationType)) {
                    KtElement ktElement = expression2;
                    BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
                    if (resolvedCall2 != null) {
                        PseudoValue rhsValue = this.generateCall(resolvedCall2).getOutputValue();
                        IElementType iElementType = expression2.getOperationToken();
                        if (iElementType == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
                        }
                        Name assignMethodName = OperatorConventions.getNameForOperationSymbol((KtToken)iElementType);
                        if (Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getName(), (Object)assignMethodName) ^ true) {
                            this.visitAssignment(left, this.getValueAsFunction(rhsValue), expression2);
                        }
                    } else {
                        this.generateBothArgumentsAndMark(expression2);
                    }
                } else if (operationType == KtTokens.ELVIS) {
                    this.generateInstructions(left);
                    this.mark(expression2);
                    Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                    this.builder.jumpOnTrue(afterElvis, expression2, this.builder.getBoundValue(left));
                    this.generateInstructions(right);
                    this.builder.bindLabel(afterElvis);
                    this.mergeValues(CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new KtExpression[]{left, right})), expression2);
                } else if (!this.generateCall(expression2)) {
                    this.generateBothArgumentsAndMark(expression2);
                }
            }
        }

        private final void generateBooleanOperation(KtBinaryExpression expression2) {
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions(left);
            if (operationType == KtTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, expression2, this.builder.getBoundValue(left));
            } else {
                this.builder.jumpOnTrue(resultLabel, expression2, this.builder.getBoundValue(left));
            }
            this.generateInstructions(right);
            this.builder.bindLabel(resultLabel);
            ControlFlowBuilder.PredefinedOperation operation = operationType == KtTokens.ANDAND ? ControlFlowBuilder.PredefinedOperation.AND : ControlFlowBuilder.PredefinedOperation.OR;
            this.builder.predefinedOperation(expression2, operation, this.elementsToValues(CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new KtExpression[]{left, right}))));
        }

        private final Function0<PseudoValue> getValueAsFunction(PseudoValue value2) {
            return (Function0)new Function0<PseudoValue>(value2){
                final /* synthetic */ PseudoValue $value;

                @Nullable
                public final PseudoValue invoke() {
                    return this.$value;
                }
                {
                    this.$value = pseudoValue;
                    super(0);
                }
            };
        }

        private final Function0<PseudoValue> getDeferredValue(KtExpression expression2) {
            return (Function0)new Function0<PseudoValue>(this, expression2){
                final /* synthetic */ CFPVisitor this$0;
                final /* synthetic */ KtExpression $expression;

                @Nullable
                public final PseudoValue invoke() {
                    this.this$0.generateInstructions(this.$expression);
                    return CFPVisitor.access$getBoundOrUnreachableValue(this.this$0, this.$expression);
                }
                {
                    this.this$0 = cFPVisitor;
                    this.$expression = ktExpression;
                    super(0);
                }
            };
        }

        private final void generateBothArgumentsAndMark(KtBinaryExpression expression2) {
            KtExpression right;
            KtExpression left = KtPsiUtil.deparenthesize(expression2.getLeft());
            if (left != null) {
                this.generateInstructions(left);
            }
            if ((right = expression2.getRight()) != null) {
                this.generateInstructions(right);
            }
            this.mark(expression2);
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, left, right);
        }

        private final void visitAssignment(KtExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            PseudoValue rightValue;
            PseudoValue pseudoValue;
            KtExpression left;
            block11: {
                Object object;
                block13: {
                    block12: {
                        left = KtPsiUtil.deparenthesize(lhs);
                        if (left != null) break block11;
                        object = (PseudoValue)rhsDeferredValue.invoke();
                        if (object == null) break block12;
                        PseudoValue pseudoValue2 = object;
                        PseudoValue it = pseudoValue2;
                        object = CollectionsKt.listOf((Object)it);
                        if (object != null) break block13;
                    }
                    object = CollectionsKt.emptyList();
                }
                Object arguments2 = object;
                this.builder.magic(parentExpression, parentExpression, (List<? extends PseudoValue>)arguments2, MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof KtArrayAccessExpression) {
                this.generateArrayAssignment((KtArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            SmartFMap smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"SmartFMap.emptyMap<PseudoValue, ReceiverValue>()");
            Map<PseudoValue, ReceiverValue> receiverValues = (Map<PseudoValue, ReceiverValue>)smartFMap;
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE;
            if (left instanceof KtSimpleNameExpression || left instanceof KtQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(KtPsiUtilKt.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof KtProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            }
            if (accessTarget == AccessTarget.BlackBox.INSTANCE && !(left instanceof KtProperty)) {
                this.generateInstructions(left);
                this.createSyntheticValue(left, MagicKind.VALUE_CONSUMER, left);
            }
            if ((pseudoValue = (rightValue = (PseudoValue)rhsDeferredValue.invoke())) == null) {
                pseudoValue = this.createSyntheticValue(parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new KtElement[0]);
            }
            PseudoValue rValue = pseudoValue;
            this.builder.write(parentExpression, left, rValue, accessTarget, receiverValues);
        }

        private final void generateArrayAssignment(KtArrayAccessExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            ResolvedCall setResolvedCall = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                List arguments2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new PseudoValue[]{this.getBoundOrUnreachableValue(lhs), (PseudoValue)rhsDeferredValue.invoke()}));
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNRESOLVED_CALL);
                return;
            }
            KtExpression ktExpression = parentExpression;
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
            }
            if (((KtOperationExpression)ktExpression).getOperationReference().getReferencedNameElementType() == KtTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, setResolvedCall, receiverValues, (Map)argumentValues);
        }

        /*
         * WARNING - void declaration
         */
        private final SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<? extends PseudoValue> rhsDeferredValue, ResolvedCall<FunctionDescriptor> setResolvedCall) {
            void destination$iv;
            void $receiver$iv;
            Iterable iterable = setResolvedCall.getResultingDescriptor().getValueParameters();
            Collection collection = new ArrayList();
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)element$iv;
                Object object = setResolvedCall.getValueArguments().get(descriptor2);
                Iterable list$iv = object != null && (object = object.getArguments()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            ArrayList valueArguments2 = (ArrayList)destination$iv;
            ValueArgument rhsArgument = (ValueArgument)CollectionsKt.lastOrNull((List)valueArguments2);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : valueArguments2) {
                ArgumentMapping argumentMapping = setResolvedCall.getArgumentMapping(valueArgument);
                if (argumentMapping.isError() || !(argumentMapping instanceof ArgumentMatch)) continue;
                ValueParameterDescriptor parameterDescriptor = ((ArgumentMatch)argumentMapping).getValueParameter();
                if (valueArgument != rhsArgument) {
                    ValueArgument valueArgument2 = valueArgument;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument2, (String)"valueArgument");
                    SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = argumentValues;
                    Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"argumentValues");
                    argumentValues = this.generateValueArgument(valueArgument2, parameterDescriptor, smartFMap);
                    continue;
                }
                PseudoValue rhsValue = (PseudoValue)rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                argumentValues = argumentValues.plus((Object)rhsValue, (Object)parameterDescriptor);
            }
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = argumentValues;
            Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"argumentValues");
            return smartFMap;
        }

        private final void generateArrayAccess(KtArrayAccessExpression arrayAccessExpression, ResolvedCall<?> resolvedCall2) {
            if (this.builder.getBoundValue(arrayAccessExpression) != null) {
                return;
            }
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(resolvedCall2)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private final void generateArrayAccessWithoutCall(KtArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((KtElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression), MagicKind.UNRESOLVED_CALL);
        }

        private final List<KtExpression> generateArrayAccessArguments(KtArrayAccessExpression arrayAccessExpression) {
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression != null) {
                inputExpressions.add(arrayExpression);
            }
            this.generateInstructions(arrayExpression);
            for (KtExpression index2 : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index2);
                inputExpressions.add(index2);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
            PseudoValue rhsValue;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtSimpleNameExpression operationSign = expression2.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            KtExpression ktExpression = expression2.getBaseExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression baseExpression = ktExpression;
            if (KtTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression);
                this.builder.predefinedOperation(expression2, ControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(CollectionsKt.listOf((Object)baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            KtElement ktElement = expression2;
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
            if (resolvedCall2 != null) {
                rhsValue = this.generateCall(resolvedCall2).getOutputValue();
            } else {
                this.generateInstructions(baseExpression);
                rhsValue = this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, baseExpression);
            }
            if (incrementOrDecrement) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression2);
                if (expression2 instanceof KtPostfixExpression) {
                    this.copyValue(baseExpression, expression2);
                }
            }
        }

        private final boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull KtIfExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>(2);
            KtExpression condition2 = expression2.getCondition();
            this.generateInstructions(condition2);
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, expression2, this.builder.getBoundValue(condition2));
            KtExpression thenBranch = expression2.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, expression2);
            this.builder.bindLabel(elseLabel);
            KtExpression elseBranch = expression2.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
        }

        @Override
        public void visitTryExpression(@NotNull KtTryExpression expression2) {
            boolean hasFinally;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(finallyBlockGenerator){
                    private boolean working;
                    final /* synthetic */ FinallyBlockGenerator $finallyBlockGenerator;

                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        this.$finallyBlockGenerator.generate();
                        this.working = false;
                    }
                    {
                        this.$finallyBlockGenerator = $captured_local_variable$0;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression2);
            if (hasFinally) {
                boolean bl2 = onExceptionToFinallyBlock != null;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "No finally label generated: " + expression2.getText();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression2);
                Label label = onExceptionToFinallyBlock;
                if (label == null) {
                    Intrinsics.throwNpe();
                }
                this.builder.bindLabel(label);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression2);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            branches.add(expression2.getTryBlock());
            for (KtCatchClause catchClause : expression2.getCatchClauses()) {
                KtExpression ktExpression;
                if (catchClause.getCatchBody() == null) continue;
                KtExpression it = ktExpression;
                branches.add(it);
            }
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
        }

        /*
         * WARNING - void declaration
         */
        private final Label generateTryAndCatches(KtTryExpression expression2) {
            List<KtCatchClause> catchClauses = expression2.getCatchClauses();
            boolean hasCatches = !catchClauses.isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression2, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression2.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression2, null);
            }
            KtBlockExpression tryBlock2 = expression2.getTryBlock();
            this.generateInstructions(tryBlock2);
            if (hasCatches && onException != null) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression2);
                this.builder.bindLabel(onException);
                LinkedList catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                int n = 0;
                int n2 = catchClausesSize - 1 - 1;
                if (n <= n2) {
                    while (true) {
                        void i;
                        catchLabels.add(this.builder.createUnboundLabel("catch " + (int)i));
                        if (i == n2) break;
                        ++i;
                    }
                }
                if (!catchLabels.isEmpty()) {
                    List list2 = catchLabels;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"catchLabels");
                    this.builder.nondeterministicJump(list2, expression2);
                }
                boolean isFirst = true;
                for (KtCatchClause catchClause : catchClauses) {
                    KtElement ktElement = catchClause;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"catchClause");
                    this.builder.enterBlockScope(ktElement);
                    if (!isFirst) {
                        Label label = (Label)catchLabels.remove();
                        Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"catchLabels.remove()");
                        this.builder.bindLabel(label);
                    } else {
                        isFirst = false;
                    }
                    KtParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                    }
                    this.generateInstructions(catchClause.getCatchBody());
                    this.builder.jump(afterCatches, expression2);
                    KtElement ktElement2 = catchClause;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"catchClause");
                    this.builder.exitBlockScope(ktElement2);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            Label label = loopInfo.getConditionEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"loopInfo.conditionEntryPoint");
            this.builder.bindLabel(label);
            KtExpression condition2 = expression2.getCondition();
            this.generateInstructions(condition2);
            this.mark(expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition2, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                Label label2 = loopInfo.getExitPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)label2, (String)"loopInfo.exitPoint");
                this.builder.jumpOnFalse(label2, expression2, this.builder.getBoundValue(condition2));
            } else {
                boolean bl = condition2 != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Invalid while condition: " + expression2.getText();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                KtExpression ktExpression = condition2;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtElement ktElement = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"condition!!");
                this.createSyntheticValue(ktElement, MagicKind.VALUE_CONSUMER, condition2);
            }
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            Label label3 = loopInfo.getEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label3, (String)"loopInfo.entryPoint");
            this.builder.jump(label3, expression2);
            this.builder.exitLoopBody(expression2);
            Label label4 = loopInfo.getExitPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label4, (String)"loopInfo.exitPoint");
            this.builder.bindLabel(label4);
            this.builder.loadUnit(expression2);
        }

        @Override
        public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.builder.enterBlockScope(expression2);
            this.mark(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            this.builder.exitLoopBody(expression2);
            Label label = loopInfo.getConditionEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"loopInfo.conditionEntryPoint");
            this.builder.bindLabel(label);
            KtExpression condition2 = expression2.getCondition();
            this.generateInstructions(condition2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition2, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                Label label2 = loopInfo.getEntryPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)label2, (String)"loopInfo.entryPoint");
                this.builder.jumpOnTrue(label2, expression2, this.builder.getBoundValue(expression2.getCondition()));
            } else {
                boolean bl = condition2 != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Invalid do / while condition: " + expression2.getText();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                KtExpression ktExpression = condition2;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtElement ktElement = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"condition!!");
                this.createSyntheticValue(ktElement, MagicKind.VALUE_CONSUMER, condition2);
                Label label3 = loopInfo.getEntryPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)label3, (String)"loopInfo.entryPoint");
                this.builder.jump(label3, expression2);
            }
            Label label4 = loopInfo.getExitPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label4, (String)"loopInfo.exitPoint");
            this.builder.bindLabel(label4);
            this.builder.loadUnit(expression2);
            this.builder.exitBlockScope(expression2);
        }

        @Override
        public void visitForExpression(@NotNull KtForExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.builder.enterBlockScope(expression2);
            this.generateInstructions(expression2.getLoopRange());
            this.declareLoopParameter(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            Label label = loopInfo.getConditionEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"loopInfo.conditionEntryPoint");
            this.builder.bindLabel(label);
            Label label2 = loopInfo.getExitPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label2, (String)"loopInfo.exitPoint");
            this.builder.nondeterministicJump(label2, expression2, null);
            this.writeLoopParameterAssignment(expression2);
            this.mark(expression2);
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            Label label3 = loopInfo.getEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label3, (String)"loopInfo.entryPoint");
            this.builder.jump(label3, expression2);
            this.builder.exitLoopBody(expression2);
            Label label4 = loopInfo.getExitPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label4, (String)"loopInfo.exitPoint");
            this.builder.bindLabel(label4);
            this.builder.loadUnit(expression2);
            this.builder.exitBlockScope(expression2);
        }

        private final void declareLoopParameter(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            KtDestructuringDeclaration multiDeclaration = expression2.getDestructuringParameter();
            if (loopParameter != null) {
                this.builder.declareParameter(loopParameter);
            } else if (multiDeclaration != null) {
                this.visitDestructuringDeclaration(multiDeclaration, false);
            }
        }

        private final void writeLoopParameterAssignment(KtForExpression expression2) {
            KtExpression loopRange;
            KtParameter loopParameter = expression2.getLoopParameter();
            KtDestructuringDeclaration multiDeclaration = expression2.getDestructuringParameter();
            KtExpression ktExpression = loopRange = expression2.getLoopRange();
            KtElement ktElement = ktExpression != null ? (KtElement)ktExpression : (KtElement)expression2;
            KtElement ktElement2 = null;
            List list2 = ContainerUtil.createMaybeSingletonList((Object)this.builder.getBoundValue(loopRange));
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.createMayb\u2026getBoundValue(loopRange))");
            PseudoValue value2 = this.builder.magic(ktElement, ktElement2, list2, MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                this.generateInitializer(loopParameter, value2);
            } else if (multiDeclaration != null) {
                for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                    KtDeclaration ktDeclaration = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"entry");
                    this.generateInitializer(ktDeclaration, value2);
                }
            }
        }

        @Override
        public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtElement loop = this.getCorrespondingLoop(expression2);
                if (loop == null || !this.jumpDoesNotCrossFunctionBoundary(expression2, loop)) break block1;
                Label label = this.builder.getExitPoint(loop);
                if (label != null) {
                    Label label2 = label;
                    Label it = label2;
                    this.builder.jump(it, expression2);
                }
            }
        }

        @Override
        public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtElement loop = this.getCorrespondingLoop(expression2);
            if (loop != null && this.jumpDoesNotCrossFunctionBoundary(expression2, loop)) {
                this.builder.jump(this.builder.getConditionEntryPoint(loop), expression2);
            }
        }

        private final KtLoopExpression getNearestLoopExpression(KtExpression expression2) {
            PsiElement $receiver$iv = (PsiElement)expression2;
            return (KtLoopExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLoopExpression.class, (boolean)true);
        }

        private final KtLoopExpression getCorrespondingLoopWithoutLabel(KtExpression expression2) {
            KtLoopExpression ktLoopExpression = this.getNearestLoopExpression(expression2);
            if (ktLoopExpression == null) {
                return null;
            }
            KtLoopExpression parentLoop = ktLoopExpression;
            KtExpression parentBody = parentLoop.getBody();
            return parentBody != null && parentBody.getTextRange().contains(expression2.getTextRange()) ? parentLoop : this.getNearestLoopExpression(parentLoop);
        }

        private final KtElement getCorrespondingLoop(KtExpressionWithLabel expression2) {
            KtExpression ktExpression;
            KtLoopExpression loop;
            String labelName = expression2.getLabelName();
            if (labelName != null) {
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
                if (ktSimpleNameExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
                PsiElement labeledElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof KtLoopExpression) {
                    loop = (KtLoopExpression)labeledElement;
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on((KtExpressionWithLabel)((PsiElement)expression2), targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = this.getCorrespondingLoopWithoutLabel(expression2);
                if (loop == null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                } else {
                    KtWhenExpression whenExpression2 = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), KtWhenExpression.class, (boolean)true, (Class[])new Class[]{KtLoopExpression.class});
                    if (whenExpression2 != null) {
                        ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_IN_WHEN.on((KtExpressionWithLabel)((PsiElement)expression2)));
                    }
                }
            }
            if ((ktExpression = loop) != null && (ktExpression = ktExpression.getBody()) != null) {
                KtExpression ktExpression2 = ktExpression;
                KtExpression it = ktExpression2;
                if (!it.getTextRange().contains(expression2.getTextRange())) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                    return null;
                }
            }
            return loop;
        }

        private final boolean jumpDoesNotCrossFunctionBoundary(KtExpressionWithLabel jumpExpression, KtElement jumpTarget) {
            boolean bl;
            FunctionDescriptor labelTargetEnclosingFunc;
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext2, jumpExpression);
            if (labelExprEnclosingFunc != (labelTargetEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext2, jumpTarget))) {
                if (this.builder.getExitPoint(jumpTarget) != null || labelExprEnclosingFunc instanceof ConstructorDescriptor && !((ConstructorDescriptor)labelExprEnclosingFunc).isPrimary()) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on((KtExpressionWithLabel)((PsiElement)jumpExpression)));
                }
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        @Override
        public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
            KtElement subroutine;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression returnedExpression = expression2.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression);
            }
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            String labelName = expression2.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement labeledElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    boolean bl = labeledElement instanceof KtElement;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    subroutine = (KtElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof KtFunction || subroutine instanceof KtPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : (PseudoValue)null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression2, subroutine);
                } else {
                    this.builder.returnValue(expression2, returnValue, subroutine);
                }
            } else {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, returnedExpression);
            }
        }

        @Override
        public void visitParameter(@NotNull KtParameter parameter) {
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            this.builder.declareParameter(parameter);
            KtExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                StringBuilder stringBuilder = new StringBuilder().append("after default value for parameter ");
                String string = parameter.getName();
                if (string == null) {
                    string = "<anonymous>";
                }
                Label skipDefaultValue = this.builder.createUnboundLabel(stringBuilder.append(string).toString());
                this.builder.nondeterministicJump(skipDefaultValue, defaultValue, null);
                this.generateInstructions(defaultValue);
                this.builder.bindLabel(skipDefaultValue);
            }
            this.generateInitializer(parameter, this.computePseudoValueForParameter(parameter));
        }

        private final PseudoValue computePseudoValueForParameter(KtParameter parameter) {
            PseudoValue syntheticValue = this.createSyntheticValue(parameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
            PseudoValue pseudoValue = this.builder.getBoundValue(parameter.getDefaultValue());
            if (pseudoValue == null) {
                return syntheticValue;
            }
            PseudoValue defaultValue = pseudoValue;
            KtExpression ktExpression = parameter;
            List list2 = Lists.newArrayList((Object[])new PseudoValue[]{defaultValue, syntheticValue});
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"Lists.newArrayList(defaultValue, syntheticValue)");
            return this.builder.merge(ktExpression, list2).getOutputValue();
        }

        @Override
        public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
            boolean declareBlockScope;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            boolean bl = declareBlockScope = !this.isBlockInDoWhile(expression2);
            if (declareBlockScope) {
                this.builder.enterBlockScope(expression2);
            }
            this.mark(expression2);
            List<KtExpression> statements = expression2.getStatements();
            for (KtExpression statement2 : statements) {
                Label afterClassLabel;
                Label label;
                KtExpression ktExpression = statement2;
                if (!(ktExpression instanceof KtClassOrObject)) {
                    ktExpression = null;
                }
                if ((KtClassOrObject)ktExpression != null) {
                    KtClassOrObject ktClassOrObject;
                    KtClassOrObject it = ktClassOrObject;
                    label = this.builder.createUnboundLabel("after local class");
                } else {
                    label = afterClassLabel = null;
                }
                if (afterClassLabel != null) {
                    KtElement ktElement = statement2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"statement");
                    this.builder.nondeterministicJump(afterClassLabel, ktElement, null);
                }
                this.generateInstructions(statement2);
                if (afterClassLabel == null) continue;
                this.builder.bindLabel(afterClassLabel);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression2);
            } else {
                this.copyValue((KtElement)CollectionsKt.lastOrNull(statements), expression2);
            }
            if (declareBlockScope) {
                this.builder.exitBlockScope(expression2);
            }
        }

        private final boolean isBlockInDoWhile(KtBlockExpression expression2) {
            PsiElement psiElement = expression2.getParent();
            if (psiElement == null) {
                return false;
            }
            PsiElement parent2 = psiElement;
            return parent2.getParent() instanceof KtDoWhileExpression;
        }

        private final void visitFunction(KtFunction function2) {
            boolean isAnonymousFunction;
            ControlFlowProcessor.this.processLocalDeclaration(function2);
            boolean bl = isAnonymousFunction = function2 instanceof KtFunctionLiteral || function2.getName() == null;
            if (isAnonymousFunction || function2.isLocal() && !(function2.getParent() instanceof KtBlockExpression)) {
                this.builder.createLambda(function2);
            }
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            this.visitFunction(function2);
        }

        @Override
        public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
            Intrinsics.checkParameterIsNotNull((Object)lambdaExpression, (String)"lambdaExpression");
            this.mark(lambdaExpression);
            KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
            KtFunction ktFunction = functionLiteral;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction, (String)"functionLiteral");
            this.visitFunction(ktFunction);
            this.copyValue(functionLiteral, lambdaExpression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression selectorExpression = expression2.getSelectorExpression();
            KtExpression receiverExpression = expression2.getReceiverExpression();
            boolean safe = expression2 instanceof KtSafeQualifiedExpression;
            if (selectorExpression instanceof KtCallExpression || selectorExpression instanceof KtSimpleNameExpression) {
                if (!safe) {
                    this.generateInstructions(selectorExpression);
                } else {
                    Label resultLabel = this.builder.createUnboundLabel("result of call");
                    this.builder.jumpOnFalse(resultLabel, expression2, null);
                    this.generateInstructions(selectorExpression);
                    this.builder.bindLabel(resultLabel);
                }
                this.copyValue(selectorExpression, expression2);
            } else {
                this.generateInstructions(receiverExpression);
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, receiverExpression);
            }
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            if (!this.generateCall(expression2)) {
                ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
                for (KtValueArgument argument2 : expression2.getValueArguments()) {
                    KtExpression argumentExpression = argument2.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                KtExpression calleeExpression = expression2.getCalleeExpression();
                this.generateInstructions(calleeExpression);
                if (calleeExpression != null) {
                    inputExpressions.add(calleeExpression);
                    KtExpression ktExpression = this.generateAndGetReceiverIfAny(expression2);
                    if (ktExpression != null) {
                        KtExpression ktExpression2 = ktExpression;
                        KtExpression it = ktExpression2;
                        inputExpressions.add(it);
                    }
                }
                this.mark(expression2);
                this.createNonSyntheticValue((KtElement)expression2, (List<? extends KtElement>)inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        private final KtExpression generateAndGetReceiverIfAny(KtExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            if (!(parent2 instanceof KtQualifiedExpression)) {
                return null;
            }
            if (((KtQualifiedExpression)parent2).getSelectorExpression() != expression2) {
                return null;
            }
            KtExpression receiverExpression = ((KtQualifiedExpression)parent2).getReceiverExpression();
            this.generateInstructions(receiverExpression);
            return receiverExpression;
        }

        @Override
        public void visitProperty(@NotNull KtProperty property2) {
            KtExpression delegate2;
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            this.builder.declareVariable(property2);
            KtExpression initializer2 = property2.getInitializer();
            if (initializer2 != null) {
                this.visitAssignment(property2, this.getDeferredValue(initializer2), property2);
            }
            if ((delegate2 = property2.getDelegateExpression()) != null) {
                this.visitAssignment(property2, this.getDeferredValue(null), property2);
                this.generateInstructions(delegate2);
                if (this.builder.getBoundValue(delegate2) != null) {
                    this.createSyntheticValue(property2, MagicKind.VALUE_CONSUMER, delegate2);
                }
            }
            if (KtPsiUtil.isLocal(property2)) {
                for (KtPropertyAccessor accessor : property2.getAccessors()) {
                    this.generateInstructions(accessor);
                }
            }
        }

        @Override
        public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            this.visitDestructuringDeclaration(declaration, true);
        }

        @Override
        private final void visitDestructuringDeclaration(KtDestructuringDeclaration declaration, boolean generateWriteForEntries) {
            KtExpression initializer2 = declaration.getInitializer();
            this.generateInstructions(initializer2);
            for (KtDestructuringDeclarationEntry entry : declaration.getEntries()) {
                PseudoValue pseudoValue;
                PseudoValue writtenValue;
                KtVariableDeclaration ktVariableDeclaration = entry;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktVariableDeclaration, (String)"entry");
                this.builder.declareVariable(ktVariableDeclaration);
                ResolvedCall resolvedCall2 = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall2 != null) {
                    KtElement ktElement = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"entry");
                    writtenValue = this.builder.call(ktElement, resolvedCall2, this.getReceiverValues(resolvedCall2), MapsKt.emptyMap()).getOutputValue();
                } else if (initializer2 != null) {
                    KtExpression ktExpression;
                    KtExpression it = ktExpression;
                    KtElement ktElement = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"entry");
                    KtElement[] ktElementArray = new KtElement[1];
                    KtExpression ktExpression2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"it");
                    ktElementArray[0] = ktExpression2;
                    pseudoValue = this.createSyntheticValue(ktElement, MagicKind.UNRESOLVED_CALL, ktElementArray);
                } else {
                    pseudoValue = writtenValue = null;
                }
                if (!generateWriteForEntries) continue;
                KtDeclaration ktDeclaration = entry;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"entry");
                PseudoValue pseudoValue2 = writtenValue;
                if (pseudoValue2 == null) {
                    KtElement ktElement = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"entry");
                    pseudoValue2 = this.createSyntheticValue(ktElement, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
                }
                this.generateInitializer(ktDeclaration, pseudoValue2);
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
            Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
            ControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            if (operationType == KtTokens.AS_KEYWORD || operationType == KtTokens.AS_SAFE) {
                this.generateInstructions(left);
                if (this.getBoundOrUnreachableValue(left) != null) {
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.CAST, left);
                }
            } else {
                this.visitKtElement(expression2);
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, left);
            }
        }

        @Override
        public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression ktExpression = expression2.getThrownExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression thrownExpression = ktExpression;
            this.generateInstructions(thrownExpression);
            PseudoValue pseudoValue = this.builder.getBoundValue(thrownExpression);
            if (pseudoValue == null) {
                return;
            }
            PseudoValue thrownValue = pseudoValue;
            this.builder.throwException(expression2, thrownValue);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.generateArrayAccess(expression2, (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression2));
        }

        @Override
        public void visitIsExpression(@NotNull KtIsExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression left = expression2.getLeftHandSide();
            this.generateInstructions(left);
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.IS, left);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression);
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
            while (iterator2.hasNext()) {
                KtWhenEntry whenEntry = iterator2.next();
                KtElement ktElement = whenEntry;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"whenEntry");
                this.mark(ktElement);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    ControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on((KtWhenEntry)((PsiElement)whenEntry)));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                int n = 0;
                KtWhenCondition[] conditions = whenEntry.getConditions();
                int n2 = conditions.length - 1;
                if (n <= n2) {
                    while (true) {
                        void i;
                        KtWhenCondition condition2 = conditions[i];
                        condition2.accept(this.conditionVisitor);
                        if (i + true < ((Object[])conditions).length) {
                            this.builder.nondeterministicJump(bodyLabel, expression2, this.builder.getBoundValue(condition2));
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    KtWhenCondition lastCondition = (KtWhenCondition)ArraysKt.lastOrNull((Object[])conditions);
                    this.builder.nondeterministicJump(nextLabel, expression2, this.builder.getBoundValue(lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                KtExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression2);
                if (isElse || nextLabel == null) continue;
                this.builder.bindLabel(nextLabel);
                if (iterator2.hasNext() || !WhenChecker.isWhenExhaustive(expression2, ControlFlowProcessor.this.trace)) continue;
                this.builder.magic(expression2, null, CollectionsKt.emptyList(), MagicKind.EXHAUSTIVE_WHEN_ELSE);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
            WhenChecker.INSTANCE.checkDuplicatedLabels(expression2, ControlFlowProcessor.this.trace);
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtObjectDeclaration declaration = expression2.getObjectDeclaration();
            this.generateInstructions(declaration);
            this.builder.createAnonymousObject(expression2);
        }

        @Override
        public void visitObjectDeclaration(@NotNull KtObjectDeclaration objectDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)objectDeclaration, (String)"objectDeclaration");
            this.generateHeaderDelegationSpecifiers(objectDeclaration);
            this.generateInitializersForScriptClassOrObject(objectDeclaration);
            this.generateDeclarationForLocalClassOrObjectIfNeeded(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
            for (int i = 0; i < ktStringTemplateEntryArray.length; ++i) {
                KtStringTemplateEntry entry = ktStringTemplateEntryArray[i];
                if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
                KtExpression entryExpression = entry.getExpression();
                this.generateInstructions(entryExpression);
                if (entryExpression == null) continue;
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression2, this.elementsToValues((List<? extends KtElement>)inputExpressions));
        }

        @Override
        public void visitTypeProjection(@NotNull KtTypeProjection typeProjection) {
            Intrinsics.checkParameterIsNotNull((Object)typeProjection, (String)"typeProjection");
        }

        @Override
        public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer classInitializer) {
            Intrinsics.checkParameterIsNotNull((Object)classInitializer, (String)"classInitializer");
            this.generateInstructions(classInitializer.getBody());
        }

        private final void generateHeaderDelegationSpecifiers(KtClassOrObject classOrObject) {
            for (KtSuperTypeListEntry specifier : classOrObject.getSuperTypeListEntries()) {
                this.generateInstructions(specifier);
            }
        }

        private final void generateInitializersForScriptClassOrObject(KtDeclarationContainer classOrObject) {
            for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                if (!(declaration instanceof KtProperty) && !(declaration instanceof KtAnonymousInitializer)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitClass(@NotNull KtClass klass2) {
            Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
            if (klass2.hasPrimaryConstructor()) {
                this.processParameters(klass2.getPrimaryConstructorParameters());
                this.generateHeaderDelegationSpecifiers(klass2);
                this.generateInitializersForScriptClassOrObject(klass2);
            }
            this.generateDeclarationForLocalClassOrObjectIfNeeded(klass2);
        }

        @Override
        public void visitScript(@NotNull KtScript script) {
            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
            this.generateInitializersForScriptClassOrObject(script);
        }

        private final void generateDeclarationForLocalClassOrObjectIfNeeded(KtClassOrObject classOrObject) {
            if (classOrObject.isLocal()) {
                for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                    if (declaration instanceof KtSecondaryConstructor || declaration instanceof KtProperty || declaration instanceof KtAnonymousInitializer) continue;
                    this.generateInstructions(declaration);
                }
            }
        }

        private final void processParameters(List<? extends KtParameter> parameters2) {
            for (KtParameter ktParameter : parameters2) {
                this.generateInstructions(ktParameter);
            }
        }

        @Override
        public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)constructor, KtClassOrObject.class);
            if (ktClassOrObject == null) {
                String string = "Guaranteed by parsing contract";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            List<KtParameter> list2 = constructor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"constructor.valueParameters");
            this.processParameters(list2);
            this.generateCallOrMarkUnresolved(constructor.getDelegationCall());
            if (!constructor.getDelegationCall().isCallToThis()) {
                KtDeclarationContainer ktDeclarationContainer = classOrObject;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclarationContainer, (String)"classOrObject");
                this.generateInitializersForScriptClassOrObject(ktDeclarationContainer);
            }
            this.generateInstructions(constructor.getBodyExpression());
        }

        @Override
        public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
            this.generateCallOrMarkUnresolved(call);
        }

        /*
         * WARNING - void declaration
         */
        private final void generateCallOrMarkUnresolved(KtCallElement call) {
            if (!this.generateCall(call)) {
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                Iterable $receiver$iv = call.getValueArguments();
                Iterable iterable = $receiver$iv;
                Collection collection = new ArrayList();
                void var6_5 = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    KtExpression ktExpression;
                    Object element$iv$iv = element$iv$iv$iv;
                    ValueArgument valueArgument = (ValueArgument)element$iv$iv;
                    if (valueArgument.getArgumentExpression() == null) continue;
                    KtExpression it$iv$iv = ktExpression;
                    destination$iv$iv.add(it$iv$iv);
                }
                List arguments2 = (List)destination$iv$iv;
                for (KtExpression argument2 : arguments2) {
                    this.generateInstructions(argument2);
                }
                this.createNonSyntheticValue((KtElement)call, arguments2, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Override
        public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
            Intrinsics.checkParameterIsNotNull((Object)specifier, (String)"specifier");
            KtExpression delegateExpression = specifier.getDelegateExpression();
            this.generateInstructions(delegateExpression);
            if (delegateExpression != null) {
                this.createSyntheticValue(specifier, MagicKind.VALUE_CONSUMER, delegateExpression);
            }
        }

        @Override
        public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
            Intrinsics.checkParameterIsNotNull((Object)specifier, (String)"specifier");
        }

        @Override
        public void visitSuperTypeList(@NotNull KtSuperTypeList list2) {
            Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
            list2.acceptChildren(this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            for (KtDeclaration declaration : file2.getDeclarations()) {
                if (!(declaration instanceof KtProperty)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.mark(expression2);
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.CALLABLE_REFERENCE, new KtElement[0]);
        }

        @Override
        public void visitKtElement(@NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.createNonSyntheticValue(element2, MagicKind.UNSUPPORTED_ELEMENT, new KtElement[0]);
        }

        private final boolean generateCall(KtElement callElement2) {
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            return this.checkAndGenerateCall(CallUtilKt.getResolvedCall(callElement2, bindingContext2));
        }

        private final boolean checkAndGenerateCall(ResolvedCall<?> resolvedCall2) {
            if (resolvedCall2 == null) {
                return false;
            }
            this.generateCall(resolvedCall2);
            return true;
        }

        private final InstructionWithValue generateCall(ResolvedCall<?> resolvedCall2) {
            KtElement callElement2 = resolvedCall2.getCall().getCallElement();
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall2);
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
                ArgumentMapping argumentMapping = resolvedCall2.getArgumentMapping(valueArgument);
                KtExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping instanceof ArgumentMatch) {
                    ValueArgument valueArgument2 = valueArgument;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument2, (String)"argument");
                    ValueParameterDescriptor valueParameterDescriptor = ((ArgumentMatch)argumentMapping).getValueParameter();
                    SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = parameterValues;
                    Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"parameterValues");
                    parameterValues = this.generateValueArgument(valueArgument2, valueParameterDescriptor, smartFMap);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression);
                this.createSyntheticValue(argumentExpression, MagicKind.VALUE_CONSUMER, argumentExpression);
            }
            if (resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor) {
                KtElement ktElement = callElement2;
                if (!(ktElement instanceof KtExpression)) {
                    ktElement = null;
                }
                KtExpression ktExpression = (KtExpression)ktElement;
                if (ktExpression == null) {
                    String string = "Variable-based call without callee expression: " + callElement2.getText();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                KtExpression ktExpression2 = ktExpression;
                boolean bl = parameterValues.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Variable-based call with non-empty argument list: " + ((KtExpression)callElement2).getText();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                return this.builder.readVariable(ktExpression2, resolvedCall2, receivers);
            }
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"resolvedCall.call.callElement");
            this.mark(ktElement);
            KtElement ktElement2 = callElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"callElement");
            Map map2 = (Map)parameterValues;
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"parameterValues");
            return this.builder.call(ktElement2, resolvedCall2, receivers, map2);
        }

        private final Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall2) {
            KtElement callElement2;
            PseudoValue varCallResult = null;
            ReceiverValue explicitReceiver = null;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                varCallResult = this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall()).getOutputValue();
                ExplicitReceiverKind kind2 = resolvedCall2.getExplicitReceiverKind();
                switch (ControlFlowProcessor$CFPVisitor$WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                    case 1: {
                        explicitReceiver = resolvedCall2.getDispatchReceiver();
                        break;
                    }
                    case 2: 
                    case 3: {
                        explicitReceiver = resolvedCall2.getExtensionReceiver();
                    }
                }
            }
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            if (explicitReceiver != null && varCallResult != null) {
                receiverValues = receiverValues.plus((Object)varCallResult, (Object)explicitReceiver);
            }
            KtElement ktElement = callElement2 = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"callElement");
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues;
            Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"receiverValues");
            receiverValues = this.getReceiverValues(ktElement, receiverValue, smartFMap);
            KtElement ktElement2 = callElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"callElement");
            receiverValues = this.getReceiverValues(ktElement2, resolvedCall2.getExtensionReceiver(), receiverValues);
            return (Map)receiverValues;
        }

        private final SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(KtElement callElement2, ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValuesArg) {
            SmartFMap receiverValues = receiverValuesArg;
            if (receiver == null || receiverValues.containsValue((Object)receiver)) {
                return receiverValues;
            }
            ReceiverValue receiverValue = receiver;
            if (receiverValue instanceof ImplicitReceiver) {
                SmartFMap smartFMap = receiverValues.plus((Object)this.createSyntheticValue(callElement2, MagicKind.IMPLICIT_RECEIVER, new KtElement[0]), (Object)receiver);
                Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"receiverValues.plus(crea\u2026ICIT_RECEIVER), receiver)");
                receiverValues = smartFMap;
            } else if (receiverValue instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                KtExpression expression2 = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue(expression2) == null) {
                    this.generateInstructions(expression2);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    SmartFMap smartFMap = receiverValues.plus((Object)receiverPseudoValue, (Object)receiver);
                    Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"receiverValues.plus(receiverPseudoValue, receiver)");
                    receiverValues = smartFMap;
                }
            } else if (!(receiverValue instanceof TransientReceiver)) {
                throw (Throwable)new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            return receiverValues;
        }

        private final SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValuesArg) {
            SmartFMap parameterValues = parameterValuesArg;
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions(expression2);
                }
                if ((argValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    SmartFMap smartFMap = parameterValues.plus((Object)argValue, (Object)parameterDescriptor);
                    Intrinsics.checkExpressionValueIsNotNull((Object)smartFMap, (String)"parameterValues.plus(arg\u2026lue, parameterDescriptor)");
                    parameterValues = smartFMap;
                }
            }
            return parameterValues;
        }

        public CFPVisitor(ControlFlowBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            this.builder = builder;
            this.conditionVisitor = new KtVisitorVoid(this){
                final /* synthetic */ CFPVisitor this$0;

                private final KtExpression getSubjectExpression(KtWhenCondition condition2) {
                    PsiElement $receiver$iv = (PsiElement)condition2;
                    KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtWhenExpression.class, (boolean)true);
                    return ktWhenExpression != null ? ktWhenExpression.getSubjectExpression() : null;
                }

                public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition2) {
                    Intrinsics.checkParameterIsNotNull((Object)condition2, (String)"condition");
                    KtElement ktElement = condition2.getOperationReference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"condition.operationReference");
                    if (!CFPVisitor.access$generateCall(this.this$0, ktElement)) {
                        KtExpression rangeExpression = condition2.getRangeExpression();
                        this.this$0.generateInstructions(rangeExpression);
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, condition2, MagicKind.UNRESOLVED_CALL, rangeExpression);
                    }
                }

                public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition2) {
                    Intrinsics.checkParameterIsNotNull((Object)condition2, (String)"condition");
                    CFPVisitor.access$mark(this.this$0, condition2);
                    CFPVisitor.access$createNonSyntheticValue(this.this$0, condition2, MagicKind.IS, this.getSubjectExpression(condition2));
                }

                public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition2) {
                    Intrinsics.checkParameterIsNotNull((Object)condition2, (String)"condition");
                    CFPVisitor.access$mark(this.this$0, condition2);
                    KtExpression expression2 = condition2.getExpression();
                    this.this$0.generateInstructions(expression2);
                    KtExpression subjectExpression = this.getSubjectExpression(condition2);
                    if (subjectExpression != null) {
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, condition2, MagicKind.EQUALS_IN_WHEN_CONDITION, subjectExpression, expression2);
                    } else {
                        CFPVisitor.access$copyValue(this.this$0, expression2, condition2);
                    }
                }

                public void visitKtElement(@NotNull KtElement element2) {
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    throw (Throwable)new UnsupportedOperationException("[ControlFlowProcessor] " + element2.toString());
                }
                {
                    this.this$0 = $outer;
                }
            };
        }

        @Nullable
        public static final /* synthetic */ PseudoValue access$getBoundOrUnreachableValue(CFPVisitor $this, @Nullable KtElement element2) {
            return $this.getBoundOrUnreachableValue(element2);
        }

        public static final /* synthetic */ boolean access$generateCall(CFPVisitor $this, @NotNull KtElement callElement2) {
            return $this.generateCall(callElement2);
        }

        @NotNull
        public static final /* synthetic */ PseudoValue access$createNonSyntheticValue(CFPVisitor $this, @NotNull KtElement to, @NotNull MagicKind kind2, KtElement ... from) {
            return $this.createNonSyntheticValue(to, kind2, from);
        }

        public static final /* synthetic */ void access$mark(CFPVisitor $this, @NotNull KtElement element2) {
            $this.mark(element2);
        }

        public static final /* synthetic */ void access$copyValue(CFPVisitor $this, @Nullable KtElement from, @NotNull KtElement to) {
            $this.copyValue(from, to);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$FinallyBlockGenerator;", "", "finallyBlock", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;Lorg/jetbrains/kotlin/psi/KtFinallySection;)V", "finishFinally", "Lorg/jetbrains/kotlin/cfg/Label;", "startFinally", "generate", "", "frontend"})
        private final class FinallyBlockGenerator {
            private Label startFinally;
            private Label finishFinally;
            private final KtFinallySection finallyBlock;

            public final void generate() {
                Label it;
                KtElementImpl ktElementImpl = this.finallyBlock;
                if (ktElementImpl == null || (ktElementImpl = ktElementImpl.getFinalExpression()) == null) {
                    return;
                }
                KtElementImpl finalExpression = ktElementImpl;
                Label label = this.startFinally;
                if (label != null) {
                    Label label2 = label;
                    Label it2 = label2;
                    boolean bl = this.finishFinally != null;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "startFinally label is set to " + this.startFinally + " but finishFinally label is not set";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    ControlFlowBuilder controlFlowBuilder = CFPVisitor.this.builder;
                    Label label3 = this.finishFinally;
                    if (label3 == null) {
                        Intrinsics.throwNpe();
                    }
                    controlFlowBuilder.repeatPseudocode(it2, label3);
                    return;
                }
                Label label4 = CFPVisitor.this.builder.createUnboundLabel("start finally");
                this.startFinally = it = label4;
                CFPVisitor.this.builder.bindLabel(it);
                CFPVisitor.this.generateInstructions(finalExpression);
                label4 = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                this.finishFinally = it = label4;
                CFPVisitor.this.builder.bindLabel(it);
            }

            public FinallyBlockGenerator(KtFinallySection finallyBlock) {
                this.finallyBlock = finallyBlock;
            }
        }
    }
}

