/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.resolve.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinIconProvider;", "Lcom/intellij/ide/IconProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getIcon", "Ljavax/swing/Icon;", "psiElement", "Lcom/intellij/psi/PsiElement;", "flags", "", "Companion", "idea-analysis"})
public final class KotlinIconProvider
extends IconProvider
implements DumbAware {
    @NotNull
    private static KotlinIconProvider INSTANCE;
    public static final Companion Companion;

    @Nullable
    public Icon getIcon(@NotNull PsiElement psiElement, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        if (psiElement instanceof KtFile) {
            KtClassOrObject mainClass = Companion.getMainClass((KtFile)psiElement);
            return mainClass != null && ((KtFile)psiElement).getDeclarations().size() == 1 ? this.getIcon(mainClass, flags) : KotlinIcons.FILE;
        }
        Icon result2 = Companion.getBaseIcon(psiElement);
        if ((flags & 1) > 0 && result2 != null && psiElement instanceof KtModifierListOwner) {
            KtModifierList list2 = ((KtModifierListOwner)psiElement).getModifierList();
            return (Icon)KotlinIconProvider.Companion.createRowIcon(result2, KotlinIconProvider.Companion.getVisibilityIcon(list2));
        }
        return result2;
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new KotlinIconProvider();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\f\u0010\u0015\u001a\u0004\u0018\u00010\f*\u00020\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinIconProvider$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/kotlin/idea/KotlinIconProvider;", "getINSTANCE", "()Lorg/jetbrains/kotlin/idea/KotlinIconProvider;", "setINSTANCE", "(Lorg/jetbrains/kotlin/idea/KotlinIconProvider;)V", "createRowIcon", "Lcom/intellij/ui/RowIcon;", "baseIcon", "Ljavax/swing/Icon;", "visibilityIcon", "getMainClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getVisibilityIcon", "list", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "getBaseIcon", "Lcom/intellij/psi/PsiElement;", "idea-analysis"})
    public static final class Companion {
        @NotNull
        public final KotlinIconProvider getINSTANCE() {
            return INSTANCE;
        }

        public final void setINSTANCE(@NotNull KotlinIconProvider kotlinIconProvider) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinIconProvider), (String)"<set-?>");
            INSTANCE = kotlinIconProvider;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final KtClassOrObject getMainClass(@NotNull KtFile file2) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Iterable $receiver$iv = file2.getDeclarations();
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtClassOrObject)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List classes2 = (List)destination$iv$iv;
            if (classes2.size() == 1 && Intrinsics.areEqual((Object)StringUtil.getPackageName((String)file2.getName()), (Object)((KtClassOrObject)classes2.get(0)).getName())) {
                return (KtClassOrObject)classes2.get(0);
            }
            return null;
        }

        private final RowIcon createRowIcon(Icon baseIcon, Icon visibilityIcon) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(baseIcon, 0);
            rowIcon.setIcon(visibilityIcon, 1);
            return rowIcon;
        }

        @NotNull
        public final Icon getVisibilityIcon(@Nullable KtModifierList list2) {
            if (list2 != null) {
                if (list2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    Icon icon = PlatformIcons.PRIVATE_ICON;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PlatformIcons.PRIVATE_ICON");
                    return icon;
                }
                if (list2.hasModifier(KtTokens.PROTECTED_KEYWORD)) {
                    Icon icon = PlatformIcons.PROTECTED_ICON;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PlatformIcons.PROTECTED_ICON");
                    return icon;
                }
                if (list2.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
                    Icon icon = PlatformIcons.PACKAGE_LOCAL_ICON;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PlatformIcons.PACKAGE_LOCAL_ICON");
                    return icon;
                }
            }
            Icon icon = PlatformIcons.PUBLIC_ICON;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PlatformIcons.PUBLIC_ICON");
            return icon;
        }

        @Nullable
        public final Icon getBaseIcon(@NotNull PsiElement $receiver) {
            Icon icon;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PsiElement psiElement = $receiver;
            if (psiElement instanceof KtPackageDirective) {
                icon = PlatformIcons.PACKAGE_ICON;
            } else if (psiElement instanceof KtLightClassForFacade) {
                icon = KotlinIcons.FILE;
            } else if (psiElement instanceof KtLightClassForDecompiledDeclaration) {
                KtClassOrObject origin = ((KtLightClassForDecompiledDeclaration)$receiver).getKotlinOrigin();
                icon = origin != null ? this.getBaseIcon(origin) : KotlinIcons.CLASS;
            } else if (psiElement instanceof KtLightClassForExplicitDeclaration) {
                icon = this.getBaseIcon(((KtLightClassForExplicitDeclaration)$receiver).getNavigationElement());
            } else if (psiElement instanceof KtNamedFunction) {
                if (((KtNamedFunction)$receiver).getReceiverTypeReference() != null) {
                    icon = KotlinIcons.EXTENSION_FUNCTION;
                } else {
                    PsiElement $receiver$iv = $receiver;
                    icon = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedDeclaration.class, (boolean)true) instanceof KtClass ? (KtPsiUtil.isAbstract((KtDeclarationWithBody)$receiver) ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON) : KotlinIcons.FUNCTION;
                }
            } else {
                icon = psiElement instanceof KtFunctionLiteral ? KotlinIcons.LAMBDA : (psiElement instanceof KtClass ? (((KtClass)$receiver).isInterface() ? KotlinIcons.INTERFACE : (((KtClass)$receiver).isEnum() ? KotlinIcons.ENUM : (((KtClass)$receiver).isAnnotation() ? KotlinIcons.ANNOTATION : ($receiver instanceof KtEnumEntry && ((KtEnumEntry)$receiver).getPrimaryConstructorParameterList() == null ? KotlinIcons.ENUM : KotlinIcons.CLASS)))) : (psiElement instanceof KtObjectDeclaration ? KotlinIcons.OBJECT : (psiElement instanceof KtParameter ? (KtPsiUtil.getClassIfParameterIsProperty((KtParameter)$receiver) != null ? (((KtParameter)$receiver).isMutable() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL) : KotlinIcons.PARAMETER) : (psiElement instanceof KtProperty ? (((KtProperty)$receiver).isVar() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL) : (Icon)null))));
            }
            return icon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

