/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.debugger.MockStackFrame;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u001a\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0018"}, d2={"functionNameByArgument", "", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "functionNameByLocalVariable", "name", "isInsideInlineArgument", "", "inlineArgument", "location", "Lcom/sun/jdi/Location;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "isInsideInlineFunctionBody", "visibleVariables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "lambdaOrdinalByArgument", "", "lambdaOrdinalByLocalVariable", "numberOfInlinedFunctions", "Lcom/sun/jdi/LocalVariable;", "idea"})
public final class DebuggerUtilKt {
    public static final boolean isInsideInlineFunctionBody(@NotNull List<? extends LocalVariableProxyImpl> visibleVariables) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(visibleVariables, (String)"visibleVariables");
            Iterable $receiver$iv = visibleVariables;
            for (Object element$iv : $receiver$iv) {
                LocalVariableProxyImpl it = (LocalVariableProxyImpl)element$iv;
                if (!StringsKt.startsWith$default((String)it.name(), (String)"$i$f$", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final int numberOfInlinedFunctions(@NotNull List<? extends LocalVariableProxyImpl> visibleVariables) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(visibleVariables, (String)"visibleVariables");
        Iterable $receiver$iv = visibleVariables;
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            LocalVariableProxyImpl it = (LocalVariableProxyImpl)element$iv;
            if (!StringsKt.startsWith$default((String)it.name(), (String)"$i$f$", (boolean)false, (int)2, null)) continue;
            ++count$iv;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideInlineArgument(@NotNull KtFunction inlineArgument, @NotNull Location location2, @NotNull DebugProcessImpl debugProcess) {
        Object element$iv;
        boolean bl;
        void $receiver$iv;
        void destination$iv$iv;
        Iterable $receiver$iv$iv;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)inlineArgument, (String)"inlineArgument");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        List<LocalVariable> visibleVariables = DebuggerUtilKt.visibleVariables(location2, debugProcess);
        BindingContext context = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper(inlineArgument).getBindingContext();
        int lambdaOrdinal2 = ((Number)ApplicationUtilsKt.runReadAction((Function0)new Function0<Integer>(inlineArgument, context){
            final /* synthetic */ KtFunction $inlineArgument;
            final /* synthetic */ BindingContext $context;

            public final int invoke() {
                BindingContext bindingContext2 = this.$context;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context");
                return DebuggerUtilKt.access$lambdaOrdinalByArgument(this.$inlineArgument, bindingContext2);
            }
            {
                this.$inlineArgument = ktFunction;
                this.$context = bindingContext2;
                super(0);
            }
        })).intValue();
        Iterable iterable = visibleVariables;
        void var8_7 = $receiver$iv2;
        Object object = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            LocalVariable it = (LocalVariable)element$iv$iv;
            if (!StringsKt.startsWith$default((String)it.name(), (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List markerLocalVariables = (List)destination$iv$iv;
        String functionName2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(inlineArgument, context){
            final /* synthetic */ KtFunction $inlineArgument;
            final /* synthetic */ BindingContext $context;

            @NotNull
            public final String invoke() {
                BindingContext bindingContext2 = this.$context;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context");
                return DebuggerUtilKt.access$functionNameByArgument(this.$inlineArgument, bindingContext2);
            }
            {
                this.$inlineArgument = ktFunction;
                this.$context = bindingContext2;
                super(0);
            }
        });
        $receiver$iv$iv = markerLocalVariables;
        object = $receiver$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            element$iv = object.next();
            LocalVariable it = (LocalVariable)element$iv;
            String string = it.name();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
            if (DebuggerUtilKt.lambdaOrdinalByLocalVariable(string) == lambdaOrdinal2) {
                String string2 = it.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.name()");
                if (Intrinsics.areEqual((Object)DebuggerUtilKt.functionNameByLocalVariable(string2), (Object)functionName2)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        Object v3 = element$iv;
        if (v3 == null) return false;
        return true;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt, BindingContext context) {
        Type type2 = CodegenBinding.asmTypeForAnonymousClass(context, elementAt);
        String string = StringsKt.substringAfterLast$default((String)type2.getClassName(), (String)"$", null, (int)2, null);
        return Integer.parseInt(string);
    }

    private static final String functionNameByArgument(KtFunction elementAt, BindingContext context) {
        ValueParameterDescriptor inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor(elementAt, context);
        Object object = inlineArgumentDescriptor;
        if (object == null || (object = object.getContainingDeclaration()) == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
            object = "unknown";
        }
        return object;
    }

    private static final List<LocalVariable> visibleVariables(@NotNull Location $receiver, DebugProcessImpl debugProcess) {
        VirtualMachine virtualMachine = debugProcess.getVirtualMachineProxy().getVirtualMachine();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"debugProcess.virtualMachineProxy.virtualMachine");
        MockStackFrame stackFrame = new MockStackFrame($receiver, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name2) {
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
            return Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static final String functionNameByLocalVariable(String name2) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final /* synthetic */ int access$lambdaOrdinalByArgument(@NotNull KtFunction elementAt, @NotNull BindingContext context) {
        return DebuggerUtilKt.lambdaOrdinalByArgument(elementAt, context);
    }

    @NotNull
    public static final /* synthetic */ String access$functionNameByArgument(@NotNull KtFunction elementAt, @NotNull BindingContext context) {
        return DebuggerUtilKt.functionNameByArgument(elementAt, context);
    }
}

