/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Value;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCachesKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002RE\u0010\u0005\u001a9\u00120\u0012.\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t \u000b*\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\r\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f \u000b*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u000e0\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u0010\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011 \u000b*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedClassNames", "Lcom/intellij/psi/util/CachedValue;", "", "Lcom/intellij/psi/PsiElement;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "cachedCompiledData", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "cachedTypeMappers", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "canBeEvaluatedInThisContext", "", "compiledData", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Companion", "CompiledDataDescriptor", "ComputedClassNames", "Parameter", "ParametersDescriptor", "idea"})
public final class KotlinDebuggerCaches {
    private final CachedValue<MultiMap<String, CompiledDataDescriptor>> cachedCompiledData;
    private final CachedValue<Map<PsiElement, List<String>>> cachedClassNames;
    private final CachedValue<Map<PsiElement, KotlinTypeMapper>> cachedTypeMappers;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final boolean canBeEvaluatedInThisContext(CompiledDataDescriptor compiledData2, EvaluationContextImpl context) {
        boolean bl;
        block4: {
            void $receiver$iv;
            FrameVisitor frameVisitor = new FrameVisitor(context);
            Iterable iterable = compiledData2.getParameters();
            for (Object element$iv : $receiver$iv) {
                boolean bl2;
                void name2;
                Parameter p;
                Parameter parameter = p = (Parameter)element$iv;
                String string = parameter.component1();
                KotlinType kotlinType = parameter.component2();
                parameter = null;
                Value value2 = frameVisitor.findValue((String)name2, null, false, false);
                if (value2 == null) {
                    bl2 = false;
                } else {
                    void jetType;
                    Type type2 = value2.getAsmType();
                    GlobalSearchScope globalSearchScope = context.getDebugProcess().getSearchScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"context.debugProcess.searchScope");
                    ClassDescriptor thisDescriptor = KotlinEvaluationBuilderKt.getClassDescriptor(type2, globalSearchScope);
                    ClassifierDescriptor classifierDescriptor = jetType.getConstructor().getDeclarationDescriptor();
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    ClassDescriptor superClassDescriptor = (ClassDescriptor)classifierDescriptor;
                    bl2 = thisDescriptor != null && superClassDescriptor != null && (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(thisDescriptor, superClassDescriptor){
                        final /* synthetic */ ClassDescriptor $thisDescriptor;
                        final /* synthetic */ ClassDescriptor $superClassDescriptor;

                        public final boolean invoke() {
                            return DescriptorUtils.isSubclass(this.$thisDescriptor, this.$superClassDescriptor);
                        }
                        {
                            this.$thisDescriptor = classDescriptor;
                            this.$superClassDescriptor = classDescriptor2;
                            super(0);
                        }
                    }) != false;
                }
                if (bl2) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        return bl;
    }

    public KotlinDebuggerCaches(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.cachedCompiledData = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedCompiledData.1.INSTANCE, false);
        this.cachedClassNames = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedClassNames.1.INSTANCE, false);
        this.cachedTypeMappers = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedTypeMappers.1.INSTANCE, false);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getLogger(KotlinDebuggerCaches.class);
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        LOG = logger;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003JC\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "", "bytecodes", "", "additionalClasses", "", "Lkotlin/Pair;", "", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "parameters", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;", "([BLjava/util/List;Lcom/intellij/debugger/SourcePosition;Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;)V", "getAdditionalClasses", "()Ljava/util/List;", "getBytecodes", "()[B", "getParameters", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "component1", "component2", "component3", "component4", "copy", "idea"})
    public static final class CompiledDataDescriptor {
        @NotNull
        private final byte[] bytecodes;
        @NotNull
        private final List<Pair<String, byte[]>> additionalClasses;
        @NotNull
        private final SourcePosition sourcePosition;
        @NotNull
        private final ParametersDescriptor parameters;

        @NotNull
        public final byte[] getBytecodes() {
            return this.bytecodes;
        }

        @NotNull
        public final List<Pair<String, byte[]>> getAdditionalClasses() {
            return this.additionalClasses;
        }

        @NotNull
        public final SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        @NotNull
        public final ParametersDescriptor getParameters() {
            return this.parameters;
        }

        public CompiledDataDescriptor(@NotNull byte[] bytecodes, @NotNull List<Pair<String, byte[]>> additionalClasses, @NotNull SourcePosition sourcePosition2, @NotNull ParametersDescriptor parameters2) {
            Intrinsics.checkParameterIsNotNull((Object)bytecodes, (String)"bytecodes");
            Intrinsics.checkParameterIsNotNull(additionalClasses, (String)"additionalClasses");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
            Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
            this.bytecodes = bytecodes;
            this.additionalClasses = additionalClasses;
            this.sourcePosition = sourcePosition2;
            this.parameters = parameters2;
        }

        @NotNull
        public final byte[] component1() {
            return this.bytecodes;
        }

        @NotNull
        public final List<Pair<String, byte[]>> component2() {
            return this.additionalClasses;
        }

        @NotNull
        public final SourcePosition component3() {
            return this.sourcePosition;
        }

        @NotNull
        public final ParametersDescriptor component4() {
            return this.parameters;
        }

        @NotNull
        public final CompiledDataDescriptor copy(@NotNull byte[] bytecodes, @NotNull List<Pair<String, byte[]>> additionalClasses, @NotNull SourcePosition sourcePosition2, @NotNull ParametersDescriptor parameters2) {
            Intrinsics.checkParameterIsNotNull((Object)bytecodes, (String)"bytecodes");
            Intrinsics.checkParameterIsNotNull(additionalClasses, (String)"additionalClasses");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
            Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
            return new CompiledDataDescriptor(bytecodes, additionalClasses, sourcePosition2, parameters2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CompiledDataDescriptor copy$default(CompiledDataDescriptor compiledDataDescriptor, byte[] byArray, List list2, SourcePosition sourcePosition2, ParametersDescriptor parametersDescriptor, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                byArray = compiledDataDescriptor.bytecodes;
            }
            if ((n & 2) != 0) {
                list2 = compiledDataDescriptor.additionalClasses;
            }
            if ((n & 4) != 0) {
                sourcePosition2 = compiledDataDescriptor.sourcePosition;
            }
            if ((n & 8) != 0) {
                parametersDescriptor = compiledDataDescriptor.parameters;
            }
            return compiledDataDescriptor.copy(byArray, list2, sourcePosition2, parametersDescriptor);
        }

        public String toString() {
            return "CompiledDataDescriptor(bytecodes=" + Arrays.toString(this.bytecodes) + ", additionalClasses=" + this.additionalClasses + ", sourcePosition=" + this.sourcePosition + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            List<Pair<String, byte[]>> list2 = this.additionalClasses;
            SourcePosition sourcePosition2 = this.sourcePosition;
            ParametersDescriptor parametersDescriptor = this.parameters;
            return (((this.bytecodes != null ? Arrays.hashCode(this.bytecodes) : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (sourcePosition2 != null ? sourcePosition2.hashCode() : 0)) * 31 + (parametersDescriptor != null ? parametersDescriptor.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompiledDataDescriptor)) break block3;
                    CompiledDataDescriptor compiledDataDescriptor = (CompiledDataDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.bytecodes, (Object)compiledDataDescriptor.bytecodes) || !Intrinsics.areEqual(this.additionalClasses, compiledDataDescriptor.additionalClasses) || !Intrinsics.areEqual((Object)this.sourcePosition, (Object)compiledDataDescriptor.sourcePosition) || !Intrinsics.areEqual((Object)this.parameters, (Object)compiledDataDescriptor.parameters)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0096\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Parameter;", "()V", "list", "Ljava/util/ArrayList;", "add", "", "name", "", "jetType", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/eval4j/Value;", "iterator", "", "idea"})
    public static final class ParametersDescriptor
    implements Iterable<Parameter>,
    KMappedMarker {
        private final ArrayList<Parameter> list = new ArrayList();

        public final void add(@NotNull String name2, @NotNull KotlinType jetType, @Nullable Value value2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)jetType, (String)"jetType");
            this.list.add(new Parameter(name2, jetType, value2));
        }

        public static /* bridge */ /* synthetic */ void add$default(ParametersDescriptor parametersDescriptor, String string, KotlinType kotlinType, Value value2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
            }
            if ((n & 4) != 0) {
                value2 = null;
            }
            parametersDescriptor.add(string, kotlinType, value2);
        }

        @Override
        @NotNull
        public Iterator<Parameter> iterator() {
            return this.list.iterator();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Parameter;", "", "callText", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/eval4j/Value;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/eval4j/Value;)V", "getCallText", "()Ljava/lang/String;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getValue", "()Lorg/jetbrains/eval4j/Value;", "component1", "component2", "component3", "copy", "idea"})
    public static final class Parameter {
        @NotNull
        private final String callText;
        @NotNull
        private final KotlinType type;
        @Nullable
        private final Value value;

        @NotNull
        public final String getCallText() {
            return this.callText;
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public Parameter(@NotNull String callText, @NotNull KotlinType type2, @Nullable Value value2) {
            Intrinsics.checkParameterIsNotNull((Object)callText, (String)"callText");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            this.callText = callText;
            this.type = type2;
            this.value = value2;
        }

        public /* synthetic */ Parameter(String string, KotlinType kotlinType, Value value2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                value2 = null;
            }
            this(string, kotlinType, value2);
        }

        @NotNull
        public final String component1() {
            return this.callText;
        }

        @NotNull
        public final KotlinType component2() {
            return this.type;
        }

        @Nullable
        public final Value component3() {
            return this.value;
        }

        @NotNull
        public final Parameter copy(@NotNull String callText, @NotNull KotlinType type2, @Nullable Value value2) {
            Intrinsics.checkParameterIsNotNull((Object)callText, (String)"callText");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return new Parameter(callText, type2, value2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Parameter copy$default(Parameter parameter, String string, KotlinType kotlinType, Value value2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                string = parameter.callText;
            }
            if ((n & 2) != 0) {
                kotlinType = parameter.type;
            }
            if ((n & 4) != 0) {
                value2 = parameter.value;
            }
            return parameter.copy(string, kotlinType, value2);
        }

        public String toString() {
            return "Parameter(callText=" + this.callText + ", type=" + this.type + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.callText;
            KotlinType kotlinType = this.type;
            Value value2 = this.value;
            return ((string != null ? string.hashCode() : 0) * 31 + (kotlinType != null ? kotlinType.hashCode() : 0)) * 31 + (value2 != null ? value2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameter)) break block3;
                    Parameter parameter = (Parameter)object;
                    if (!Intrinsics.areEqual((Object)this.callText, (Object)parameter.callText) || !Intrinsics.areEqual((Object)this.type, (Object)parameter.type) || !Intrinsics.areEqual((Object)this.value, (Object)parameter.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b6\u0018\u00002\u00020\u0001:\u0002\f\rB\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "", "classNames", "", "", "shouldBeCached", "", "(Ljava/util/List;Z)V", "getClassNames", "()Ljava/util/List;", "getShouldBeCached", "()Z", "CachedClassNames", "NonCachedClassNames", "idea"})
    public static abstract class ComputedClassNames {
        @NotNull
        private final List<String> classNames;
        private final boolean shouldBeCached;

        @NotNull
        public final List<String> getClassNames() {
            return this.classNames;
        }

        public final boolean getShouldBeCached() {
            return this.shouldBeCached;
        }

        private ComputedClassNames(List<String> classNames2, boolean shouldBeCached) {
            this.classNames = classNames2;
            this.shouldBeCached = shouldBeCached;
        }

        public /* synthetic */ ComputedClassNames(@NotNull List classNames2, boolean shouldBeCached, DefaultConstructorMarker $constructor_marker) {
            this(classNames2, shouldBeCached);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames$CachedClassNames;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "className", "", "(Ljava/lang/String;)V", "classNames", "", "(Ljava/util/List;)V", "idea"})
        public static final class CachedClassNames
        extends ComputedClassNames {
            public CachedClassNames(@NotNull List<String> classNames2) {
                Intrinsics.checkParameterIsNotNull(classNames2, (String)"classNames");
                super(classNames2, true, null);
            }

            public CachedClassNames(@Nullable String className) {
                this(KotlinDebuggerCachesKt.access$toList(className));
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames$NonCachedClassNames;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "className", "", "(Ljava/lang/String;)V", "classNames", "", "(Ljava/util/List;)V", "idea"})
        public static final class NonCachedClassNames
        extends ComputedClassNames {
            public NonCachedClassNames(@NotNull List<String> classNames2) {
                Intrinsics.checkParameterIsNotNull(classNames2, (String)"classNames");
                super(classNames2, false, null);
            }

            public NonCachedClassNames(@Nullable String className) {
                this(KotlinDebuggerCachesKt.access$toList(className));
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J7\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\"\b\b\u0000\u0010\u001a*\u00020\u00122\u0006\u0010\u001b\u001a\u0002H\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\u0010\u001fJ8\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020!0(J\u000e\u0010)\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Companion;", "", "()V", "LOG", "Lorg/apache/log4j/Logger;", "getLOG", "()Lorg/apache/log4j/Logger;", "addTypeMapper", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "createTypeMapperForLibraryFile", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "createTypeMapperForSourceFile", "getElementToCreateTypeMapperForLibraryFile", "Lcom/intellij/psi/PsiElement;", "getInstance", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "project", "Lcom/intellij/openapi/project/Project;", "getOrComputeClassNames", "", "", "T", "psiElement", "create", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "getOrCreateCompiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lkotlin/Function2;", "getOrCreateTypeMapper", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final KotlinDebuggerCaches getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, KotlinDebuggerCaches.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (KotlinDebuggerCaches)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final CompiledDataDescriptor getOrCreateCompiledData(@NotNull KtCodeFragment codeFragment, @NotNull SourcePosition sourcePosition2, @NotNull EvaluationContextImpl evaluationContext, @NotNull Function2<? super KtCodeFragment, ? super SourcePosition, CompiledDataDescriptor> create2) {
            Object v4;
            Object object;
            String text2;
            KotlinDebuggerCaches evaluateExpressionCache;
            block9: {
                void $receiver$iv;
                Object cache2;
                Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
                Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
                Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
                Intrinsics.checkParameterIsNotNull(create2, (String)"create");
                Project project = codeFragment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"codeFragment.project");
                evaluateExpressionCache = this.getInstance(project);
                text2 = codeFragment.importsToString() + "\n" + codeFragment.getText();
                CachedValue cachedValue2 = evaluateExpressionCache.cachedCompiledData;
                Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue2, (String)"evaluateExpressionCache.cachedCompiledData");
                CachedValue cachedValue3 = cachedValue2;
                synchronized (cachedValue3) {
                    Object object2 = evaluateExpressionCache.cachedCompiledData.getValue();
                    if (object2 == null) {
                        Intrinsics.throwNpe();
                    }
                    cache2 = (MultiMap)object2;
                    Collection collection = cache2.get((Object)text2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"cache[text]");
                    object = collection;
                }
                Collection cached = object;
                cache2 = cached;
                for (Object element$iv : $receiver$iv) {
                    CompiledDataDescriptor it = (CompiledDataDescriptor)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getSourcePosition(), (Object)sourcePosition2) || evaluateExpressionCache.canBeEvaluatedInThisContext(it, evaluationContext))) continue;
                    v4 = element$iv;
                    break block9;
                }
                v4 = null;
            }
            CompiledDataDescriptor answer = v4;
            if (answer != null) {
                return answer;
            }
            CompiledDataDescriptor newCompiledData = (CompiledDataDescriptor)create2.invoke((Object)codeFragment, (Object)sourcePosition2);
            this.getLOG().debug((Object)("Compile bytecode for " + codeFragment.getText()));
            CachedValue cachedValue4 = evaluateExpressionCache.cachedCompiledData;
            Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue4, (String)"evaluateExpressionCache.cachedCompiledData");
            object = cachedValue4;
            synchronized (object) {
                ((MultiMap)evaluateExpressionCache.cachedCompiledData.getValue()).putValue((Object)text2, (Object)newCompiledData);
                Unit unit = Unit.INSTANCE;
            }
            return newCompiledData;
        }

        @NotNull
        public final <T extends PsiElement> List<String> getOrComputeClassNames(@NotNull T psiElement, @NotNull Function1<? super T, ? extends ComputedClassNames> create2) {
            Intrinsics.checkParameterIsNotNull(psiElement, (String)"psiElement");
            Intrinsics.checkParameterIsNotNull(create2, (String)"create");
            Project project = (Project)ApplicationUtilsKt.runReadAction((Function0)new Function0<Project>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    return this.$psiElement.getProject();
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"runReadAction { psiElement.project }");
            KotlinDebuggerCaches cache2 = this.getInstance(project);
            Map classNamesCache = (Map)cache2.cachedClassNames.getValue();
            List cachedValue2 = (List)classNamesCache.get(psiElement);
            if (cachedValue2 != null) {
                return cachedValue2;
            }
            ComputedClassNames computedClassNames = (ComputedClassNames)create2.invoke(psiElement);
            if (computedClassNames.getShouldBeCached()) {
                Map map2 = classNamesCache;
                List<String> list2 = computedClassNames.getClassNames();
                map2.put(psiElement, list2);
            }
            return computedClassNames.getClassNames();
        }

        @NotNull
        public final KotlinTypeMapper getOrCreateTypeMapper(@NotNull PsiElement psiElement) {
            Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
            Project project = (Project)ApplicationUtilsKt.runReadAction((Function0)new Function0<Project>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    return this.$psiElement.getProject();
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"runReadAction { psiElement.project }");
            KotlinDebuggerCaches cache2 = this.getInstance(project);
            KtFile file2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final KtFile invoke() {
                    PsiFile psiFile = this.$psiElement.getContainingFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    return (KtFile)psiFile;
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            });
            boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject()) != null;
            PsiElement key = !isInLibrary ? (PsiElement)file2 : psiElement;
            Map typeMappersCache = (Map)cache2.cachedTypeMappers.getValue();
            KotlinTypeMapper cachedValue2 = (KotlinTypeMapper)typeMappersCache.get(key);
            if (cachedValue2 != null) {
                return cachedValue2;
            }
            if (!isInLibrary) {
                KotlinTypeMapper newValue = this.createTypeMapperForSourceFile(file2);
                Map map2 = typeMappersCache;
                KotlinTypeMapper kotlinTypeMapper = newValue;
                map2.put(file2, kotlinTypeMapper);
                return newValue;
            }
            KtElement element2 = this.getElementToCreateTypeMapperForLibraryFile(psiElement);
            KotlinTypeMapper newValue = this.createTypeMapperForLibraryFile(element2, file2);
            Map map3 = typeMappersCache;
            KotlinTypeMapper kotlinTypeMapper = newValue;
            map3.put(psiElement, kotlinTypeMapper);
            return newValue;
        }

        private final KotlinTypeMapper createTypeMapperForLibraryFile(KtElement element2, KtFile file2) {
            return (KotlinTypeMapper)ApplicationUtilsKt.runReadAction((Function0)new Function0<KotlinTypeMapper>(element2, file2){
                final /* synthetic */ KtElement $element;
                final /* synthetic */ KtFile $file;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    AnalysisResult analysisResult = ResolutionUtils.analyzeAndGetResult(this.$element);
                    Project project = this.$file.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                    ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.THROW_EXCEPTION;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.THROW_EXCEPTION");
                    GenerationState state = new GenerationState(project, classBuilderFactory, analysisResult.getModuleDescriptor(), analysisResult.getBindingContext(), CollectionsKt.listOf((Object)this.$file), false, false, null, false, false, false, false, null, null, null, null, null, null, null, null, null, 2097120, null);
                    state.beforeCompile();
                    return state.getTypeMapper();
                }
                {
                    this.$element = ktElement;
                    this.$file = ktFile;
                    super(0);
                }
            });
        }

        private final KtElement getElementToCreateTypeMapperForLibraryFile(PsiElement element2) {
            return (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>(element2){
                final /* synthetic */ PsiElement $element;

                @NotNull
                public final KtElement invoke() {
                    KtElement ktElement;
                    if (this.$element instanceof KtElement) {
                        ktElement = (KtElement)this.$element;
                    } else {
                        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)this.$element, KtElement.class);
                        if (psiElement == null) {
                            Intrinsics.throwNpe();
                        }
                        KtElement ktElement2 = (KtElement)psiElement;
                        ktElement = ktElement2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"PsiTreeUtil.getParentOfT\u2026 KtElement::class.java)!!");
                    }
                    return ktElement;
                }
                {
                    this.$element = psiElement;
                    super(0);
                }
            });
        }

        private final KotlinTypeMapper createTypeMapperForSourceFile(KtFile file2) {
            return (KotlinTypeMapper)ApplicationUtilsKt.runReadAction((Function0)new Function0<KotlinTypeMapper>(file2){
                final /* synthetic */ KtFile $file;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    AnalysisResult analysisResult = ResolutionUtils.analyzeFullyAndGetResult(this.$file, new KtFile[0]);
                    analysisResult.throwIfError();
                    Project project = this.$file.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                    ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.THROW_EXCEPTION;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.THROW_EXCEPTION");
                    GenerationState state = new GenerationState(project, classBuilderFactory, analysisResult.getModuleDescriptor(), analysisResult.getBindingContext(), CollectionsKt.listOf((Object)this.$file), false, false, null, false, false, false, false, null, null, null, null, null, null, null, null, null, 2097120, null);
                    state.beforeCompile();
                    return state.getTypeMapper();
                }
                {
                    this.$file = ktFile;
                    super(0);
                }
            });
        }

        public final void addTypeMapper(@NotNull KtFile file2, @NotNull KotlinTypeMapper typeMapper) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            Map map2 = (Map)this.getInstance(project).cachedTypeMappers.getValue();
            KotlinTypeMapper kotlinTypeMapper = typeMapper;
            map2.put(file2, kotlinTypeMapper);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

