/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddBracesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "caretOffset", "", "getTargetExpression", "caretLocation", "idea"})
public final class AddBracesIntention
extends SelfTargetingIntention<KtExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = this.getTargetExpression(element2, caretOffset);
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression2 = ktExpression;
        if (expression2 instanceof KtBlockExpression) {
            return false;
        }
        PsiElement psiElement = expression2.getParent();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtContainerNode");
        }
        String string = UtilsKt.description((KtContainerNode)psiElement);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String description = string;
        this.setText("Add braces to '" + description + "' statement");
        return true;
    }

    @Override
    protected boolean allowCaretInsideElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return !(element2 instanceof KtBlockExpression);
    }

    @Override
    public void applyTo(@NotNull KtExpression element2, @Nullable Editor editor) {
        block7: {
            PsiElement psiElement;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (editor == null) {
                throw (Throwable)new IllegalArgumentException("This intention requires an editor");
            }
            KtExpression ktExpression = this.getTargetExpression(element2, editor.getCaretModel().getOffset());
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression expression2 = ktExpression;
            PsiElement psiElement2 = element2.getNextSibling();
            if (Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getText() : null), (Object)";")) {
                PsiElement psiElement3 = element2.getNextSibling();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                psiElement3.delete();
            }
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
            expression2.replace((PsiElement)psiFactory.createSingleStatementBlock(expression2));
            if (!(element2 instanceof KtDoWhileExpression)) break block7;
            KtExpression ktExpression2 = ((KtDoWhileExpression)element2).getBody();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            if (!((psiElement = ktExpression2.getParent().getNextSibling()) instanceof PsiWhiteSpace)) {
                psiElement = null;
            }
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement;
            if (psiWhiteSpace != null) {
                psiWhiteSpace.delete();
            }
        }
    }

    private final KtExpression getTargetExpression(@NotNull KtExpression $receiver, int caretLocation) {
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtIfExpression) {
            KtExpression ktExpression2 = ((KtIfExpression)$receiver).getThen();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression thenExpr = ktExpression2;
            KtExpression elseExpr = ((KtIfExpression)$receiver).getElse();
            if (elseExpr != null) {
                PsiElement psiElement = ((KtIfExpression)$receiver).getElseKeyword();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                if (caretLocation >= PsiUtilsKt.getStartOffset(psiElement)) {
                    return elseExpr;
                }
            }
            return thenExpr;
        }
        if (ktExpression instanceof KtWhileExpression) {
            return ((KtWhileExpression)$receiver).getBody();
        }
        if (ktExpression instanceof KtDoWhileExpression) {
            return ((KtDoWhileExpression)$receiver).getBody();
        }
        if (ktExpression instanceof KtForExpression) {
            return ((KtForExpression)$receiver).getBody();
        }
        return null;
    }

    public AddBracesIntention() {
        super(KtExpression.class, "Add braces", null, 4, null);
    }
}

