/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertNegatedExpressionWithDemorgansLawIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "splitBooleanSequence", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "idea"})
public final class ConvertNegatedExpressionWithDemorgansLawIntention
extends SelfTargetingOffsetIndependentIntention<KtPrefixExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtPrefixExpression element2) {
        KtParenthesizedExpression parenthesizedExpression;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        IElementType prefixOperator = element2.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)prefixOperator, (Object)((Object)KtTokens.EXCL)) ^ true) {
            return false;
        }
        KtExpression ktExpression = element2.getBaseExpression();
        if (!(ktExpression instanceof KtParenthesizedExpression)) {
            ktExpression = null;
        }
        KtParenthesizedExpression ktParenthesizedExpression = parenthesizedExpression = (KtParenthesizedExpression)ktExpression;
        KtExpression ktExpression2 = ktParenthesizedExpression != null ? ktParenthesizedExpression.getExpression() : null;
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression baseExpression = ktBinaryExpression;
        IElementType iElementType = baseExpression.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            this.setText("Replace '&&' with '||'");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            this.setText("Replace '||' with '&&'");
        } else {
            return false;
        }
        return this.splitBooleanSequence(baseExpression) != null;
    }

    @Override
    public void applyTo(@NotNull KtPrefixExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        this.applyTo(element2);
    }

    public final void applyTo(@NotNull KtPrefixExpression element2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getBaseExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
        }
        KtParenthesizedExpression parenthesizedExpression = (KtParenthesizedExpression)ktExpression;
        KtExpression ktExpression2 = parenthesizedExpression.getExpression();
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression baseExpression = (KtBinaryExpression)ktExpression2;
        IElementType iElementType = baseExpression.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            string = KtTokens.OROR.getValue();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            string = KtTokens.ANDAND.getValue();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        String operatorText = string;
        List<KtExpression> list2 = this.splitBooleanSequence(baseExpression);
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        List operands = CollectionsKt.asReversed(list2);
        KtExpression newExpression2 = CreateByPatternKt.buildExpression(KtPsiFactoryKt.KtPsiFactory((PsiElement)element2), (Function1<? super BuilderByPattern<KtExpression>, Unit>)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(operands, operatorText){
            final /* synthetic */ List $operands;
            final /* synthetic */ String $operatorText;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                List list2;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Iterable iterable = this.$operands;
                BuilderByPattern<KtExpression> builderByPattern = $receiver;
                void var3_4 = $receiver$iv;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    KtExpression ktExpression = (KtExpression)item$iv$iv;
                    list2 = destination$iv$iv;
                    KtExpression ktExpression2 = UtilsKt.negate((KtExpression)it);
                    list2.add(ktExpression2);
                }
                list2 = (List)destination$iv$iv;
                Iterable iterable2 = list2;
                String string = this.$operatorText;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"operatorText");
                builderByPattern.appendExpressions(iterable2, string);
            }
            {
                this.$operands = list2;
                this.$operatorText = string;
                super(1);
            }
        }));
        element2.replace((PsiElement)newExpression2);
    }

    private final List<KtExpression> splitBooleanSequence(KtBinaryExpression expression2) {
        IElementType operation;
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        IElementType firstOperator = expression2.getOperationToken();
        KtExpression remainingExpression = expression2;
        while (!(!(remainingExpression instanceof KtBinaryExpression) || Intrinsics.areEqual((Object)(operation = ((KtBinaryExpression)remainingExpression).getOperationToken()), (Object)((Object)KtTokens.ANDAND)) ^ true && Intrinsics.areEqual((Object)operation, (Object)((Object)KtTokens.OROR)) ^ true)) {
            if (Intrinsics.areEqual((Object)operation, (Object)firstOperator) ^ true) {
                return null;
            }
            KtExpression ktExpression = ((KtBinaryExpression)remainingExpression).getRight();
            if (ktExpression == null) {
                return null;
            }
            result2.add(ktExpression);
            if (((KtBinaryExpression)remainingExpression).getLeft() != null) continue;
            return null;
        }
        result2.add(remainingExpression);
        return result2;
    }

    public ConvertNegatedExpressionWithDemorgansLawIntention() {
        super(KtPrefixExpression.class, "DeMorgan Law", null, 4, null);
    }
}

