/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.ImportPath;

public class KtImportsFactory {
    @NotNull
    private final Project project;
    private final Map<ImportPath, KtImportDirective> importsCache;

    public KtImportsFactory(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/psi/KtImportsFactory", "<init>"));
        }
        this.importsCache = Maps.newHashMap();
        this.project = project;
    }

    @NotNull
    public KtImportDirective createImportDirective(@NotNull ImportPath importPath) {
        if (importPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPath", "org/jetbrains/kotlin/psi/KtImportsFactory", "createImportDirective"));
        }
        KtImportDirective directive = this.importsCache.get(importPath);
        if (directive != null) {
            KtImportDirective ktImportDirective = directive;
            if (ktImportDirective == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtImportsFactory", "createImportDirective"));
            }
            return ktImportDirective;
        }
        KtImportDirective createdDirective = KtPsiFactoryKt.KtPsiFactory(this.project).createImportDirective(importPath);
        this.importsCache.put(importPath, createdDirective);
        KtImportDirective ktImportDirective = createdDirective;
        if (ktImportDirective == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtImportsFactory", "createImportDirective"));
        }
        return ktImportDirective;
    }

    @NotNull
    public Collection<KtImportDirective> createImportDirectives(@NotNull Collection<ImportPath> importPaths) {
        if (importPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPaths", "org/jetbrains/kotlin/psi/KtImportsFactory", "createImportDirectives"));
        }
        Collection collection = Collections2.transform(importPaths, (Function)new Function<ImportPath, KtImportDirective>(){

            public KtImportDirective apply(@Nullable ImportPath path) {
                assert (path != null);
                return KtImportsFactory.this.createImportDirective(path);
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtImportsFactory", "createImportDirectives"));
        }
        return collection;
    }
}

