/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.CompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.NoExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.QualifierScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001ay\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\n*\u00020\u000b\"\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b21\u0010\f\u001a-\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00120\u00110\r\u00a2\u0006\u0002\b\u0013H\u0002\u001a:\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00020\u00150\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0016"}, d2={"createFunctionProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerContext;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "createSimpleProcessor", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "collectCandidates", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "Lkotlin/ExtensionFunctionType;", "createVariableProcessor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "resolution"})
public final class ScopeTowerProcessorsKt {
    private static final <D extends CallableDescriptor, C extends Candidate<? extends D>> ScopeTowerProcessor<C> createSimpleProcessor(TowerContext<D, ? extends C> context, Receiver explicitReceiver, Function3<? super ScopeTowerLevel, ? super Name, ? super ReceiverValue, ? extends Collection<? extends CandidateWithBoundDispatchReceiver<? extends D>>> collectCandidates) {
        if (explicitReceiver instanceof ReceiverValue) {
            return new ExplicitReceiverScopeTowerProcessor<D, C>(context, (ReceiverValue)explicitReceiver, collectCandidates);
        }
        if (explicitReceiver instanceof QualifierReceiver) {
            QualifierScopeTowerProcessor<D, ? extends C> qualifierProcessor = new QualifierScopeTowerProcessor<D, C>(context, (QualifierReceiver)explicitReceiver, collectCandidates);
            ReceiverValue receiverValue = ((QualifierReceiver)explicitReceiver).getClassValueReceiver();
            if (receiverValue == null) {
                return qualifierProcessor;
            }
            ReceiverValue classValue = receiverValue;
            return new CompositeScopeTowerProcessor(qualifierProcessor, new ExplicitReceiverScopeTowerProcessor<D, C>(context, classValue, collectCandidates));
        }
        boolean bl = explicitReceiver == null;
        if (_Assertions.ENABLED && !bl) {
            StringBuilder stringBuilder = new StringBuilder().append("Illegal explicit receiver: ").append(explicitReceiver).append("(");
            Receiver receiver = explicitReceiver;
            if (receiver == null) {
                Intrinsics.throwNpe();
            }
            String string = stringBuilder.append(receiver.getClass().getSimpleName()).append(")").toString();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return new NoExplicitReceiverScopeTowerProcessor<D, C>(context, collectCandidates);
    }

    @NotNull
    public static final <C extends Candidate<? extends VariableDescriptor>> ScopeTowerProcessor<C> createVariableProcessor(@NotNull TowerContext<VariableDescriptor, ? extends C> context, @Nullable Receiver explicitReceiver) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver, createVariableProcessor.1.INSTANCE);
    }

    @NotNull
    public static final <C extends Candidate<? extends FunctionDescriptor>> ScopeTowerProcessor<C> createFunctionProcessor(@NotNull TowerContext<FunctionDescriptor, ? extends C> context, @Nullable Receiver explicitReceiver) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver, createFunctionProcessor.1.INSTANCE);
    }
}

