/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.MissingDependencyClassChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.serialization.deserialization.NotFoundClasses;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/MissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "collectNotFoundClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend.java"})
public final class MissingDependencyClassChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        for (ClassId classId : this.collectNotFoundClasses((CallableDescriptor)obj)) {
            context.trace.report(ErrorsJvm.MISSING_DEPENDENCY_CLASS.on((PsiElement)resolvedCall2.getCall().getCallElement(), classId.asSingleFqName()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ClassId> collectNotFoundClasses(CallableDescriptor descriptor2) {
        void $receiver$iv;
        Object object;
        KotlinType p1;
        Object object2;
        Set result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(1);
        Function1<ClassDescriptor, Unit> consider$ = new Function1<ClassDescriptor, Unit>(result2){
            final /* synthetic */ Set $result;

            public final void invoke(@NotNull ClassDescriptor classDescriptor) {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
                    if (classDescriptor instanceof NotFoundClasses.MockClassDescriptor) {
                        this.$result.add(DescriptorUtilsKt.getClassId(classDescriptor));
                        return;
                    }
                    DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
                    if (!(declarationDescriptor instanceof ClassDescriptor)) {
                        declarationDescriptor = null;
                    }
                    ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                    if (classDescriptor2 == null) break block2;
                    ClassDescriptor classDescriptor3 = classDescriptor2;
                    ClassDescriptor p1 = classDescriptor3;
                    this.invoke(p1);
                }
            }
            {
                this.$result = set;
                super(1);
            }
        };
        Function1<KotlinType, Unit> consider$2 = new Function1<KotlinType, Unit>(this, consider$){
            final /* synthetic */ MissingDependencyClassChecker this$0;
            final /* synthetic */ collectNotFoundClasses.1 $consider;

            public final void invoke(@NotNull KotlinType type2) {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                    if (CallCheckerKt.isComputingDeferredType(this.this$0, type2)) break block2;
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                    if (classDescriptor != null) {
                        ClassDescriptor classDescriptor2 = classDescriptor;
                        ClassDescriptor p1 = classDescriptor2;
                        this.$consider.invoke(p1);
                    }
                }
            }
            {
                this.this$0 = missingDependencyClassChecker;
                this.$consider = var2_2;
                super(1);
            }
        };
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType != null) {
            object2 = kotlinType;
            p1 = object2;
            consider$2.invoke(p1);
        }
        if ((object = descriptor2.getExtensionReceiverParameter()) != null && (object = object.getValue()) != null && (object = object.getType()) != null) {
            object2 = object;
            p1 = (KotlinType)object2;
            consider$2.invoke(p1);
        }
        object2 = descriptor2.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"it.type");
            consider$2.invoke(kotlinType2);
        }
        object2 = result2;
        Object object3 = object2;
        if (object3 == null) {
            object3 = SetsKt.emptySet();
        }
        return object3;
    }
}

