/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingFieldFromLocal;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClassBuilderModeUtilKt;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SourceInfo;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DelegatingToPartContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class MemberCodegen<T extends KtElement> {
    protected final GenerationState state;
    protected final T element;
    protected final FieldOwnerContext context;
    protected final ClassBuilder v;
    protected final FunctionCodegen functionCodegen;
    protected final PropertyCodegen propertyCodegen;
    protected final KotlinTypeMapper typeMapper;
    protected final BindingContext bindingContext;
    protected final JvmFileClassesProvider fileClassesProvider;
    private final MemberCodegen<?> parentCodegen;
    private final ReifiedTypeParametersUsages reifiedTypeParametersUsages;
    protected final Collection<ClassDescriptor> innerClasses;
    protected ExpressionCodegen clInit;
    private NameGenerator inlineNameGenerator;
    private DefaultSourceMapper sourceMapper;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public MemberCodegen(@NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, @NotNull FieldOwnerContext context, T element, @NotNull ClassBuilder builder) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        this.reifiedTypeParametersUsages = new ReifiedTypeParametersUsages();
        this.innerClasses = new LinkedHashSet<ClassDescriptor>();
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.fileClassesProvider = state2.getFileClassesProvider();
        this.element = element;
        this.context = context;
        this.v = builder;
        this.functionCodegen = new FunctionCodegen(context, this.v, state2, this);
        this.propertyCodegen = new PropertyCodegen(context, this.v, this.functionCodegen, this);
        this.parentCodegen = parentCodegen;
        this.constantExpressionEvaluator = new ConstantExpressionEvaluator(state2.getModule().getBuiltIns());
    }

    protected MemberCodegen(@NotNull MemberCodegen<T> wrapped, T declaration, FieldOwnerContext codegenContext) {
        if (wrapped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        this(wrapped.state, wrapped.getParentCodegen(), codegenContext, declaration, wrapped.v);
    }

    public void generate() {
        this.generateDeclaration();
        this.generateBody();
        this.generateSyntheticParts();
        if (ClassBuilderModeUtilKt.shouldGenerateMetadata(this.state.getClassBuilderMode())) {
            this.generateKotlinMetadataAnnotation();
        }
        this.done();
    }

    protected abstract void generateDeclaration();

    protected abstract void generateBody();

    protected void generateSyntheticParts() {
    }

    protected abstract void generateKotlinMetadataAnnotation();

    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return null;
    }

    public static void markLineNumberForDescriptor(@Nullable ClassDescriptor declarationDescriptor, @NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/MemberCodegen", "markLineNumberForDescriptor"));
        }
        if (declarationDescriptor == null) {
            return;
        }
        PsiElement classElement = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
        if (classElement != null) {
            MemberCodegen.markLineNumberForElement(classElement, v);
        }
    }

    public static void markLineNumberForElement(@NotNull PsiElement element, @NotNull InstructionAdapter v) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/MemberCodegen", "markLineNumberForElement"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/MemberCodegen", "markLineNumberForElement"));
        }
        Integer lineNumber = CodegenUtil.getLineNumberForElement(element, false);
        if (lineNumber != null) {
            Label label = new Label();
            v.visitLabel(label);
            v.visitLineNumber(lineNumber, label);
        }
    }

    protected void done() {
        if (this.clInit != null) {
            this.clInit.v.visitInsn(177);
            FunctionCodegen.endVisit(this.clInit.v, "static initializer", this.element);
        }
        this.writeInnerClasses();
        if (this.sourceMapper != null) {
            SourceMapper.Companion.flushToClassBuilder(this.sourceMapper, this.v);
        }
        this.v.done();
    }

    public void genFunctionOrProperty(@NotNull KtDeclaration functionOrProperty) {
        if (functionOrProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionOrProperty", "org/jetbrains/kotlin/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        if (functionOrProperty instanceof KtNamedFunction) {
            try {
                this.functionCodegen.gen((KtNamedFunction)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else if (functionOrProperty instanceof KtProperty) {
            try {
                this.propertyCodegen.gen((KtProperty)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + functionOrProperty);
        }
    }

    public static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtClassOrObject aClass2, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen) {
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        ClassDescriptor descriptor2 = state2.getBindingContext().get(BindingContext.CLASS, aClass2);
        if (descriptor2 == null || ErrorUtils.isError(descriptor2)) {
            MemberCodegen.badDescriptor(descriptor2, state2.getClassBuilderMode());
            return;
        }
        if (descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED)) {
            MemberCodegen.badDescriptor(descriptor2, state2.getClassBuilderMode());
        }
        Type classType = state2.getTypeMapper().mapClass(descriptor2);
        ClassBuilder classBuilder2 = state2.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(aClass2, descriptor2), classType, aClass2.getContainingFile());
        ClassContext classContext = parentContext.intoClass(descriptor2, OwnerKind.IMPLEMENTATION, state2);
        new ImplementationBodyCodegen(aClass2, classContext, classBuilder2, state2, parentCodegen, false).generate();
    }

    private static void badDescriptor(ClassDescriptor descriptor2, ClassBuilderMode mode) {
        if (mode == ClassBuilderMode.FULL) {
            throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + (Object)((Object)mode) + ": " + descriptor2);
        }
    }

    public void genClassOrObject(KtClassOrObject aClass2) {
        MemberCodegen.genClassOrObject(this.context, aClass2, this.state, this);
    }

    private void writeInnerClasses() {
        ClassDescriptor classDescriptor = this.classForInnerClassRecord();
        if (classDescriptor != null) {
            if (this.parentCodegen != null) {
                this.parentCodegen.innerClasses.add(classDescriptor);
            }
            for (MemberCodegen<?> codegen = this; codegen != null; codegen = codegen.getParentCodegen()) {
                ClassDescriptor outerClass = codegen.classForInnerClassRecord();
                if (outerClass == null) continue;
                this.innerClasses.add(outerClass);
            }
        }
        for (ClassDescriptor innerClass : this.innerClasses) {
            this.writeInnerClass(innerClass);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "writeInnerClass"));
        }
        DeclarationDescriptor containing = innerClass.getContainingDeclaration();
        String outerClassInternalName = null;
        if (containing instanceof ClassDescriptor) {
            outerClassInternalName = this.typeMapper.mapClass((ClassDescriptor)containing).getInternalName();
        }
        String innerName = innerClass.getName().isSpecial() ? null : innerClass.getName().asString();
        String innerClassInternalName = this.typeMapper.mapClass(innerClass).getInternalName();
        this.v.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName, AsmUtil.calculateInnerClassAccessFlags(innerClass));
    }

    protected void writeOuterClassAndEnclosingMethod() {
        CodegenContext context = this.context.getParentContext();
        while (context instanceof InlineLambdaContext) {
            context = context.getParentContext().getParentContext();
        }
        assert (context != null) : "Outermost context can't be null: " + this.context;
        Type enclosingAsmType = this.computeOuterClass(context);
        if (enclosingAsmType != null) {
            Method method = this.computeEnclosingMethod(context);
            this.v.visitOuterClass(enclosingAsmType.getInternalName(), method == null ? null : method.getName(), method == null ? null : method.getDescriptor());
        }
    }

    @Nullable
    private Type computeOuterClass(@NotNull CodegenContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeOuterClass"));
        }
        CodegenContext<ClassOrPackageFragmentDescriptor> outermost = context.getClassOrPackageParentContext();
        if (outermost instanceof ClassContext) {
            return this.typeMapper.mapType((ClassifierDescriptor)((ClassContext)outermost).getContextDescriptor());
        }
        if (outermost instanceof MultifileClassFacadeContext || outermost instanceof DelegatingToPartContext) {
            Type implementationOwnerType = CodegenContextUtil.getImplementationOwnerClassType(outermost);
            if (implementationOwnerType != null) {
                return implementationOwnerType;
            }
            return FileClasses.getFileClassType(this.fileClassesProvider, this.element.getContainingKtFile());
        }
        return null;
    }

    @Nullable
    private Method computeEnclosingMethod(@NotNull CodegenContext context) {
        Method method;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeEnclosingMethod"));
        }
        if (context instanceof MethodContext && !(method = this.typeMapper.mapAsmMethod(((MethodContext)context).getFunctionDescriptor())).getName().equals("<clinit>")) {
            return method;
        }
        return null;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        if (this.inlineNameGenerator == null) {
            String prefix = InlineCodegenUtil.getInlineName(this.context, this.typeMapper, this.fileClassesProvider);
            this.inlineNameGenerator = new NameGenerator(prefix);
        }
        NameGenerator nameGenerator = this.inlineNameGenerator;
        if (nameGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getInlineNameGenerator"));
        }
        return nameGenerator;
    }

    @NotNull
    protected final ExpressionCodegen createOrGetClInitCodegen() {
        if (this.clInit == null) {
            Object contextDescriptor = this.context.getContextDescriptor();
            SimpleFunctionDescriptorImpl clInitDescriptor = this.createClInitFunctionDescriptor((DeclarationDescriptor)contextDescriptor);
            MethodVisitor mv = this.createClInitMethodVisitor((DeclarationDescriptor)contextDescriptor);
            this.clInit = new ExpressionCodegen(mv, new FrameMap(), Type.VOID_TYPE, this.context.intoFunction(clInitDescriptor), this.state, this);
        }
        ExpressionCodegen expressionCodegen = this.clInit;
        if (expressionCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "createOrGetClInitCodegen"));
        }
        return expressionCodegen;
    }

    @NotNull
    protected MethodVisitor createClInitMethodVisitor(@NotNull DeclarationDescriptor contextDescriptor) {
        if (contextDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitMethodVisitor"));
        }
        MethodVisitor methodVisitor = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(contextDescriptor), 8, "<clinit>", "()V", null, null);
        if (methodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitMethodVisitor"));
        }
        return methodVisitor;
    }

    @NotNull
    protected SimpleFunctionDescriptorImpl createClInitFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitFunctionDescriptor"));
        }
        SimpleFunctionDescriptorImpl clInit = SimpleFunctionDescriptorImpl.create(descriptor2, Annotations.Companion.getEMPTY(), Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED, KotlinSourceElementKt.toSourceElement(this.element));
        clInit.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), DescriptorUtilsKt.getModule(descriptor2).getBuiltIns().getUnitType(), (Modality)null, Visibilities.PRIVATE);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = clInit;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    protected void generateInitializers(@NotNull Function0<ExpressionCodegen> createCodegen) {
        if (createCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createCodegen", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateInitializers"));
        }
        NotNullLazyValue<ExpressionCodegen> codegen = LockBasedStorageManager.NO_LOCKS.createLazyValue(createCodegen);
        for (KtDeclaration declaration : ((KtDeclarationContainer)this.element).getDeclarations()) {
            KtExpression body;
            if (declaration instanceof KtProperty) {
                if (!this.shouldInitializeProperty((KtProperty)declaration)) continue;
                this.initializeProperty((ExpressionCodegen)codegen.invoke(), (KtProperty)declaration);
                continue;
            }
            if (!(declaration instanceof KtAnonymousInitializer) || (body = ((KtAnonymousInitializer)declaration).getBody()) == null) continue;
            ((ExpressionCodegen)codegen.invoke()).gen(body, Type.VOID_TYPE);
        }
    }

    public void beforeMethodBody(@NotNull MethodVisitor mv) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/MemberCodegen", "beforeMethodBody"));
        }
    }

    private void initializeProperty(@NotNull ExpressionCodegen codegen, @NotNull KtProperty property) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/MemberCodegen", "initializeProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "initializeProperty"));
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        KtExpression initializer2 = property.getDelegateExpressionOrInitializer();
        assert (initializer2 != null) : "shouldInitializeProperty must return false if initializer is null";
        StackValue.Property propValue = codegen.intermediateValueForProperty(propertyDescriptor, true, false, null, true, StackValue.LOCAL_0);
        propValue.store(codegen.gen(initializer2), codegen.v);
    }

    protected boolean shouldInitializeProperty(@NotNull KtProperty property) {
        ConstantValue<?> initializerValue;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "shouldInitializeProperty"));
        }
        if (!property.hasDelegateExpressionOrInitializer()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        if (propertyDescriptor.isConst()) {
            return false;
        }
        KtExpression initializer2 = property.getInitializer();
        ConstantValue<?> constantValue = initializerValue = initializer2 != null ? ExpressionCodegen.getCompileTimeConstant(initializer2, this.bindingContext) : null;
        if (initializerValue == null) {
            return this.state.getClassBuilderMode() == ClassBuilderMode.FULL;
        }
        KotlinType jetType = this.getPropertyOrDelegateType(property, propertyDescriptor);
        Type type2 = this.typeMapper.mapType(jetType);
        return !MemberCodegen.skipDefaultValue(propertyDescriptor, initializerValue.getValue(), type2);
    }

    @NotNull
    private KotlinType getPropertyOrDelegateType(@NotNull KtProperty property, @NotNull PropertyDescriptor descriptor2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        KtExpression delegateExpression = property.getDelegateExpression();
        if (delegateExpression != null) {
            KotlinType delegateType = this.bindingContext.getType(delegateExpression);
            assert (delegateType != null) : "Type of delegate expression should be recorded";
            KotlinType kotlinType = delegateType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = descriptor2.getType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        return kotlinType;
    }

    private static boolean skipDefaultValue(@NotNull PropertyDescriptor propertyDescriptor, Object value, @NotNull Type type2) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "skipDefaultValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/MemberCodegen", "skipDefaultValue"));
        }
        if (AsmUtil.isPrimitive(type2)) {
            if (!propertyDescriptor.getType().isMarkedNullable() && value instanceof Number) {
                if (type2 == Type.INT_TYPE && ((Number)value).intValue() == 0) {
                    return true;
                }
                if (type2 == Type.BYTE_TYPE && ((Number)value).byteValue() == 0) {
                    return true;
                }
                if (type2 == Type.LONG_TYPE && ((Number)value).longValue() == 0L) {
                    return true;
                }
                if (type2 == Type.SHORT_TYPE && ((Number)value).shortValue() == 0) {
                    return true;
                }
                if (type2 == Type.DOUBLE_TYPE && ((Number)value).doubleValue() == 0.0) {
                    return true;
                }
                if (type2 == Type.FLOAT_TYPE && ((Number)value).floatValue() == 0.0f) {
                    return true;
                }
            }
            if (type2 == Type.BOOLEAN_TYPE && value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return true;
            }
            if (type2 == Type.CHAR_TYPE && value instanceof Character && ((Character)value).charValue() == '\u0000') {
                return true;
            }
        } else if (value == null) {
            return true;
        }
        return false;
    }

    protected void generatePropertyMetadataArrayFieldIfNeeded(@NotNull Type thisAsmType) {
        if (thisAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generatePropertyMetadataArrayFieldIfNeeded"));
        }
        ArrayList<KtProperty> delegatedProperties = new ArrayList<KtProperty>();
        for (KtDeclaration declaration : ((KtDeclarationContainer)this.element).getDeclarations()) {
            KtProperty property;
            if (!(declaration instanceof KtProperty) || !(property = (KtProperty)declaration).hasDelegate()) continue;
            delegatedProperties.add(property);
        }
        if (delegatedProperties.isEmpty()) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4122, "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE, null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        InstructionAdapter iv = this.createOrGetClInitCodegen().v;
        iv.iconst(delegatedProperties.size());
        iv.newarray(AsmTypes.K_PROPERTY_TYPE);
        int size = delegatedProperties.size();
        for (int i = 0; i < size; ++i) {
            PropertyDescriptor property = (PropertyDescriptor)BindingContextUtils.getNotNull(this.bindingContext, BindingContext.VARIABLE, delegatedProperties.get(i));
            iv.dup();
            iv.iconst(i);
            int receiverCount = (property.getDispatchReceiverParameter() != null ? 1 : 0) + (property.getExtensionReceiverParameter() != null ? 1 : 0);
            Type implType = property.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL[receiverCount] : AsmTypes.PROPERTY_REFERENCE_IMPL[receiverCount];
            iv.anew(implType);
            iv.dup();
            ClosureCodegen.generateCallableReferenceDeclarationContainer(iv, property, this.state);
            iv.aconst(property.getName().asString());
            iv.aconst(PropertyReferenceCodegen.getPropertyReferenceSignature(property, this.state));
            iv.invokespecial(implType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, AsmTypes.K_DECLARATION_CONTAINER_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE), false);
            Method wrapper = PropertyReferenceCodegen.getWrapperMethodForPropertyReference(property, receiverCount);
            iv.invokestatic("kotlin/jvm/internal/Reflection", wrapper.getName(), wrapper.getDescriptor(), false);
            StackValue.onStack(implType).put(AsmTypes.K_PROPERTY_TYPE, iv);
            iv.astore(AsmTypes.K_PROPERTY_TYPE);
        }
        iv.putstatic(thisAsmType.getInternalName(), "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE);
    }

    public String getClassName() {
        return this.v.getThisName();
    }

    @NotNull
    public FieldOwnerContext<?> getContext() {
        FieldOwnerContext fieldOwnerContext = this.context;
        if (fieldOwnerContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getContext"));
        }
        return fieldOwnerContext;
    }

    @NotNull
    public ReifiedTypeParametersUsages getReifiedTypeParametersUsages() {
        ReifiedTypeParametersUsages reifiedTypeParametersUsages = this.reifiedTypeParametersUsages;
        if (reifiedTypeParametersUsages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getReifiedTypeParametersUsages"));
        }
        return reifiedTypeParametersUsages;
    }

    public MemberCodegen<?> getParentCodegen() {
        return this.parentCodegen;
    }

    public String toString() {
        return this.context.toString();
    }

    @NotNull
    public DefaultSourceMapper getOrCreateSourceMapper() {
        if (this.sourceMapper == null) {
            this.sourceMapper = new DefaultSourceMapper(SourceInfo.Companion.createInfo((KtElement)this.element, this.getClassName()));
        }
        DefaultSourceMapper defaultSourceMapper = this.sourceMapper;
        if (defaultSourceMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getOrCreateSourceMapper"));
        }
        return defaultSourceMapper;
    }

    protected void generateConstInstance(@NotNull Type thisAsmType, @NotNull Type fieldAsmType) {
        if (thisAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateConstInstance"));
        }
        if (fieldAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateConstInstance"));
        }
        this.v.newField(JvmDeclarationOriginKt.OtherOrigin(this.element), 25, "INSTANCE", fieldAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            InstructionAdapter iv = this.createOrGetClInitCodegen().v;
            iv.anew(thisAsmType);
            iv.dup();
            iv.invokespecial(thisAsmType.getInternalName(), "<init>", "()V", false);
            iv.putstatic(thisAsmType.getInternalName(), "INSTANCE", fieldAsmType.getDescriptor());
        }
    }

    protected void generateSyntheticAccessors() {
        for (AccessorForCallableDescriptor<?> accessor : this.context.getAccessors()) {
            this.generateSyntheticAccessor(accessor);
        }
    }

    private void generateSyntheticAccessor(@NotNull AccessorForCallableDescriptor<?> accessorForCallableDescriptor) {
        if (accessorForCallableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorForCallableDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateSyntheticAccessor"));
        }
        if (accessorForCallableDescriptor instanceof FunctionDescriptor) {
            final FunctionDescriptor accessor = (FunctionDescriptor)((Object)accessorForCallableDescriptor);
            final FunctionDescriptor original = (FunctionDescriptor)accessorForCallableDescriptor.getCalleeDescriptor();
            this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original), accessor, new FunctionGenerationStrategy.CodegenBased<FunctionDescriptor>(this.state, accessor){

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/MemberCodegen$1", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/MemberCodegen$1", "doGenerateBody"));
                    }
                    MemberCodegen.markLineNumberForElement(MemberCodegen.this.element, codegen.v);
                    MemberCodegen.this.generateMethodCallTo(original, accessor, codegen.v).coerceTo(signature.getReturnType(), codegen.v);
                    codegen.v.areturn(signature.getReturnType());
                }
            });
        } else if (accessorForCallableDescriptor instanceof AccessorForPropertyDescriptor) {
            class PropertyAccessorStrategy
            extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
                public PropertyAccessorStrategy(PropertyAccessorDescriptor callableDescriptor) {
                    if (propertyDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy", "<init>"));
                    }
                    super(MemberCodegen.this.state, callableDescriptor);
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    boolean syntheticBackingField = accessor instanceof AccessorForPropertyBackingFieldFromLocal;
                    boolean forceFieldForCompanionProperty = JvmAbi.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isCompanionObject(accessor.getContainingDeclaration());
                    boolean forceField = forceFieldForCompanionProperty || syntheticBackingField || original.getVisibility() == JavaVisibilities.PROTECTED_STATIC_VISIBILITY;
                    StackValue.Property property = codegen.intermediateValueForProperty(original, forceField, syntheticBackingField, accessor.getSuperCallTarget(), forceFieldForCompanionProperty, StackValue.none());
                    InstructionAdapter iv = codegen.v;
                    MemberCodegen.markLineNumberForElement(MemberCodegen.this.element, iv);
                    Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                    int reg = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                        property.put(signature.getReturnType(), iv);
                    } else {
                        ((StackValue)property).store(StackValue.onStack(property.type), iv, true);
                    }
                    iv.areturn(signature.getReturnType());
                }
            }
            final AccessorForPropertyDescriptor accessor = (AccessorForPropertyDescriptor)accessorForCallableDescriptor;
            final PropertyDescriptor original = accessor.getCalleeDescriptor();
            if (accessor.isWithSyntheticGetterAccessor()) {
                PropertyGetterDescriptorImpl getter = accessor.getGetter();
                assert (getter != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getGetter() != null ? original.getGetter() : original), getter, new PropertyAccessorStrategy(getter));
            }
            if (accessor.isVar() && accessor.isWithSyntheticSetterAccessor()) {
                PropertySetterDescriptor setter = accessor.getSetter();
                assert (setter != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getSetter() != null ? original.getSetter() : original), setter, new PropertyAccessorStrategy(setter));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected StackValue generateMethodCallTo(@NotNull FunctionDescriptor functionDescriptor, @Nullable FunctionDescriptor accessorDescriptor, @NotNull InstructionAdapter iv) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateMethodCallTo"));
        }
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateMethodCallTo"));
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(functionDescriptor, accessorDescriptor instanceof AccessorForCallableDescriptor && ((AccessorForCallableDescriptor)((Object)accessorDescriptor)).getSuperCallTarget() != null);
        boolean hasDispatchReceiver = !DescriptorUtils.isStaticDeclaration(functionDescriptor) && !DescriptorUtils.isInterface(functionDescriptor.getContainingDeclaration());
        int reg = hasDispatchReceiver ? 1 : 0;
        boolean accessorIsConstructor = accessorDescriptor instanceof AccessorForConstructorDescriptor;
        if (!accessorIsConstructor && functionDescriptor instanceof ConstructorDescriptor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
        } else if ((accessorIsConstructor || accessorDescriptor != null && KotlinTypeMapper.isAccessor(accessorDescriptor) && hasDispatchReceiver) && !AnnotationUtilKt.isPlatformStaticInObjectOrClass(functionDescriptor)) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
        }
        for (Type argType : callableMethod.getParameterTypes()) {
            if (AsmTypes.DEFAULT_CONSTRUCTOR_MARKER.equals(argType)) {
                iv.aconst(null);
                continue;
            }
            iv.load(reg, argType);
            reg += argType.getSize();
        }
        callableMethod.genInvokeInstruction(iv);
        return StackValue.onStack(callableMethod.getReturnType());
    }
}

